/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.DnsCache;
import com.linecorp.armeria.client.DnsCacheListener;
import com.linecorp.armeria.client.DnsResolverGroupBuilder;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.client.dns.DefaultDnsResolver;
import com.linecorp.armeria.internal.client.dns.DnsQuestionWithoutTrailingDot;
import com.linecorp.armeria.internal.client.dns.DnsUtil;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Cache;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.AbstractAddressResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RefreshingAddressResolver
extends AbstractAddressResolver<InetSocketAddress>
implements DnsCacheListener {
    private static final Logger logger = LoggerFactory.getLogger(RefreshingAddressResolver.class);
    private final Cache<String, CacheEntry> addressResolverCache;
    private final DefaultDnsResolver resolver;
    private final List<DnsRecordType> dnsRecordTypes;
    private final int negativeTtl;
    @Nullable
    private final Backoff autoRefreshBackoff;
    @Nullable
    private final ToLongFunction<String> autoRefreshTimeoutFunction;
    private final boolean autoRefresh;
    private volatile boolean resolverClosed;

    RefreshingAddressResolver(EventLoop eventLoop, DefaultDnsResolver resolver, List<DnsRecordType> dnsRecordTypes, Cache<String, CacheEntry> addressResolverCache, DnsCache dnsResolverCache, int negativeTtl, boolean autoRefresh, @Nullable Backoff autoRefreshBackoff, @Nullable ToLongFunction<String> autoRefreshTimeoutFunction) {
        super(eventLoop);
        this.addressResolverCache = addressResolverCache;
        this.resolver = resolver;
        this.dnsRecordTypes = dnsRecordTypes;
        this.negativeTtl = negativeTtl;
        this.autoRefresh = autoRefresh;
        if (autoRefresh) {
            assert (autoRefreshBackoff != null);
            assert (autoRefreshTimeoutFunction != null);
        }
        this.autoRefreshBackoff = autoRefreshBackoff;
        this.autoRefreshTimeoutFunction = autoRefreshTimeoutFunction;
        dnsResolverCache.addListener(this);
    }

    @Override
    protected boolean doIsResolved(InetSocketAddress address) {
        return !Objects.requireNonNull(address, "address").isUnresolved();
    }

    @Override
    protected void doResolve(InetSocketAddress unresolvedAddress, Promise<InetSocketAddress> promise) throws Exception {
        Objects.requireNonNull(unresolvedAddress, "unresolvedAddress");
        Objects.requireNonNull(promise, "promise");
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.doResolve0(unresolvedAddress, promise);
        } else {
            executor.execute(() -> this.doResolve0(unresolvedAddress, promise));
        }
    }

    private void doResolve0(InetSocketAddress unresolvedAddress, Promise<InetSocketAddress> promise) {
        if (this.resolverClosed) {
            promise.tryFailure(new IllegalStateException("resolver is closed already."));
            return;
        }
        String hostname = unresolvedAddress.getHostString();
        int port = unresolvedAddress.getPort();
        CacheEntry entry = this.addressResolverCache.getIfPresent(hostname);
        if (entry != null) {
            this.complete(promise, entry, port);
            return;
        }
        CompletableFuture<CacheEntry> entryFuture = this.sendQuery(hostname);
        entryFuture.handle((entry0, unused) -> {
            if (entry0.cacheable()) {
                this.addressResolverCache.put(hostname, (CacheEntry)entry0);
            }
            this.complete(promise, (CacheEntry)entry0, port);
            return null;
        });
    }

    @Override
    protected void doResolveAll(InetSocketAddress unresolvedAddress, Promise<List<InetSocketAddress>> promise) throws Exception {
        throw new UnsupportedOperationException();
    }

    private void complete(Promise<InetSocketAddress> promise, CacheEntry entry, int port) {
        Throwable cause = entry.cause();
        if (cause != null) {
            promise.tryFailure(cause);
        } else {
            promise.trySuccess(new InetSocketAddress(entry.address(), port));
        }
    }

    private CompletableFuture<CacheEntry> sendQuery(String hostname) {
        List questions = this.dnsRecordTypes.stream().map(type -> DnsQuestionWithoutTrailingDot.of(hostname, type)).collect(ImmutableList.toImmutableList());
        return this.sendQueries(questions, hostname, null);
    }

    private CompletableFuture<CacheEntry> sendQueries(List<DnsQuestion> questions, String hostname, @Nullable Long creationTimeNanos) {
        return this.resolver.resolve(questions, hostname).handle((records, cause) -> {
            if (cause != null) {
                cause = Exceptions.peel(cause);
                return new CacheEntry(hostname, null, questions, creationTimeNanos, (Throwable)cause);
            }
            InetAddress inetAddress = null;
            for (DnsRecord r : records) {
                byte[] addrBytes = DnsUtil.extractAddressBytes(r, logger, hostname);
                if (addrBytes == null) continue;
                try {
                    inetAddress = InetAddress.getByAddress(hostname, addrBytes);
                    break;
                }
                catch (UnknownHostException e) {
                    return new CacheEntry(hostname, null, questions, creationTimeNanos, new IllegalArgumentException("Invalid address: " + hostname, e));
                }
            }
            if (inetAddress == null) {
                return new CacheEntry(hostname, null, questions, creationTimeNanos, new UnknownHostException("failed to receive DNS records for " + hostname));
            }
            return new CacheEntry(hostname, inetAddress, questions, creationTimeNanos, null);
        });
    }

    @Override
    public void onRemoval(DnsQuestion question, @Nullable List<DnsRecord> records, @Nullable UnknownHostException cause) {
        if (this.resolverClosed) {
            return;
        }
        DnsRecordType type = question.type();
        if (!type.equals(DnsRecordType.A) && !type.equals(DnsRecordType.AAAA)) {
            return;
        }
        assert (question instanceof DnsQuestionWithoutTrailingDot);
        DnsQuestionWithoutTrailingDot cast = (DnsQuestionWithoutTrailingDot)question;
        String hostname = cast.originalName();
        if (!this.autoRefresh) {
            this.addressResolverCache.invalidate(hostname);
            return;
        }
        CacheEntry entry = this.addressResolverCache.getIfPresent(hostname);
        if (entry != null) {
            if (entry.refreshable()) {
                this.executor().execute(entry::refresh);
            } else {
                this.addressResolverCache.invalidate(hostname);
            }
        }
    }

    @Override
    public void onEviction(DnsQuestion question, @Nullable List<DnsRecord> records, @Nullable UnknownHostException cause) {
        if (this.resolverClosed) {
            return;
        }
        DnsRecordType type = question.type();
        if (!type.equals(DnsRecordType.A) && !type.equals(DnsRecordType.AAAA)) {
            return;
        }
        DnsQuestionWithoutTrailingDot cast = (DnsQuestionWithoutTrailingDot)question;
        this.addressResolverCache.invalidate(cast.originalName());
    }

    @Override
    public void close() {
        this.resolverClosed = true;
        this.resolver.close();
    }

    final class CacheEntry {
        private final String hostname;
        @Nullable
        private final InetAddress address;
        private final List<DnsQuestion> questions;
        @Nullable
        private final Throwable cause;
        private final boolean cacheable;
        @Nullable
        private final ScheduledFuture<?> negativeCacheFuture;
        private final long originalCreationTimeNanos;
        private boolean refreshing;
        @Nullable
        private ScheduledFuture<?> retryFuture;
        private int numAttemptsSoFar = 1;

        CacheEntry(@Nullable String hostname, InetAddress address, @Nullable List<DnsQuestion> questions, @Nullable Long originalCreationTimeNanos, Throwable cause) {
            this.hostname = hostname;
            this.address = address;
            this.questions = questions;
            this.cause = cause;
            boolean cacheable = false;
            io.netty.util.concurrent.ScheduledFuture<?> negativeCacheFuture = null;
            if (address != null) {
                cacheable = true;
            } else if (RefreshingAddressResolver.this.negativeTtl > 0 && cause instanceof UnknownHostException) {
                UnknownHostException unknownHostException = (UnknownHostException)cause;
                boolean bl = cacheable = unknownHostException.getCause() == null;
                if (cacheable) {
                    negativeCacheFuture = RefreshingAddressResolver.this.executor().schedule(() -> RefreshingAddressResolver.this.addressResolverCache.invalidate(hostname), (long)RefreshingAddressResolver.this.negativeTtl, TimeUnit.SECONDS);
                }
            }
            this.cacheable = cacheable;
            this.negativeCacheFuture = negativeCacheFuture;
            this.originalCreationTimeNanos = originalCreationTimeNanos != null ? originalCreationTimeNanos : (RefreshingAddressResolver.this.autoRefreshTimeoutFunction == DnsResolverGroupBuilder.DEFAULT_AUTO_REFRESH_TIMEOUT_FUNCTION ? 0L : System.nanoTime());
        }

        @Nullable
        InetAddress address() {
            return this.address;
        }

        @Nullable
        Throwable cause() {
            return this.cause;
        }

        void clear() {
            RefreshingAddressResolver.this.executor().execute(() -> {
                if (this.retryFuture != null) {
                    this.retryFuture.cancel(false);
                }
                if (this.negativeCacheFuture != null) {
                    this.negativeCacheFuture.cancel(false);
                }
            });
        }

        void refresh() {
            if (RefreshingAddressResolver.this.resolverClosed) {
                return;
            }
            if (this.refreshing) {
                return;
            }
            this.refreshing = true;
            String hostname = this.address.getHostName();
            RefreshingAddressResolver.this.sendQueries(this.questions, hostname, this.originalCreationTimeNanos).thenAccept(entry -> {
                if (RefreshingAddressResolver.this.executor().inEventLoop()) {
                    this.maybeUpdate(hostname, (CacheEntry)entry);
                } else {
                    RefreshingAddressResolver.this.executor().execute(() -> this.maybeUpdate(hostname, (CacheEntry)entry));
                }
            });
        }

        @Nullable
        private Object maybeUpdate(String hostname, CacheEntry entry) {
            if (RefreshingAddressResolver.this.resolverClosed) {
                return null;
            }
            this.refreshing = false;
            Throwable cause = entry.cause();
            if (cause != null) {
                long nextDelayMillis = RefreshingAddressResolver.this.autoRefreshBackoff.nextDelayMillis(this.numAttemptsSoFar++);
                if (nextDelayMillis < 0L) {
                    RefreshingAddressResolver.this.addressResolverCache.invalidate(hostname);
                } else {
                    ScheduledFuture<?> retryFuture = this.retryFuture;
                    if (retryFuture != null) {
                        retryFuture.cancel(false);
                    }
                    this.retryFuture = RefreshingAddressResolver.this.executor().schedule(() -> {
                        if (this.refreshable()) {
                            this.refresh();
                        } else {
                            RefreshingAddressResolver.this.addressResolverCache.invalidate(hostname);
                        }
                    }, nextDelayMillis, TimeUnit.MILLISECONDS);
                }
                return null;
            }
            this.numAttemptsSoFar = 1;
            RefreshingAddressResolver.this.addressResolverCache.put(hostname, entry);
            return null;
        }

        boolean refreshable() {
            if (this.address == null) {
                return false;
            }
            if (RefreshingAddressResolver.this.autoRefreshTimeoutFunction == DnsResolverGroupBuilder.DEFAULT_AUTO_REFRESH_TIMEOUT_FUNCTION) {
                return true;
            }
            try {
                long timeoutMillis = RefreshingAddressResolver.this.autoRefreshTimeoutFunction.applyAsLong(this.hostname);
                if (timeoutMillis == Long.MAX_VALUE) {
                    return true;
                }
                if (timeoutMillis <= 0L) {
                    return false;
                }
                long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.originalCreationTimeNanos);
                return elapsedMillis < timeoutMillis;
            }
            catch (Exception ex) {
                logger.warn("Unexpected exception while invoking 'autoRefreshTimeoutFunction.applyAsLong({})'", (Object)this.hostname, (Object)ex);
                return false;
            }
        }

        boolean cacheable() {
            return this.cacheable;
        }

        long originalCreationTimeNanos() {
            return this.originalCreationTimeNanos;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("hostname", this.hostname).add("address", this.address).add("questions", this.questions).add("cause", this.cause).add("cacheable", this.cacheable).add("numAttemptsSoFar", this.numAttemptsSoFar).add("originalCreationTimeNanos", this.originalCreationTimeNanos).toString();
        }
    }
}

