/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.InvalidResponseException;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;

public final class InvalidHttpResponseException
extends InvalidResponseException {
    private static final long serialVersionUID = 3883287492432644897L;
    private final AggregatedHttpResponse response;

    public InvalidHttpResponseException(AggregatedHttpResponse response) {
        this(response, null);
    }

    public InvalidHttpResponseException(AggregatedHttpResponse response, @Nullable Throwable cause) {
        super(Objects.requireNonNull(response, "response").toString(), cause);
        InvalidHttpResponseException.ensureNonPooledObject(response);
        this.response = response;
    }

    public InvalidHttpResponseException(AggregatedHttpResponse response, String message, @Nullable Throwable cause) {
        super(Objects.requireNonNull(message, "message"), cause);
        Objects.requireNonNull(response, "response");
        InvalidHttpResponseException.ensureNonPooledObject(response);
        this.response = response;
    }

    public AggregatedHttpResponse response() {
        return this.response;
    }

    private static void ensureNonPooledObject(AggregatedHttpResponse response) {
        Preconditions.checkArgument(!response.content().isPooled(), "Cannot create an %s with the pooled content: %s (expected: a non-pooled content)", (Object)InvalidHttpResponseException.class.getSimpleName(), (Object)response);
    }
}

