/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.ResponseTimeoutException;
import com.linecorp.armeria.common.ContentTooLargeException;
import com.linecorp.armeria.common.ContentTooLargeExceptionBuilder;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.ResponseCompleteException;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.StreamWriter;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.client.ClientRequestContextExtension;
import com.linecorp.armeria.internal.client.DecodedHttpResponse;
import com.linecorp.armeria.internal.client.HttpSession;
import com.linecorp.armeria.internal.common.CancellationScheduler;
import com.linecorp.armeria.internal.common.InboundTrafficController;
import com.linecorp.armeria.internal.common.KeepAliveHandler;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.EventExecutor;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HttpResponseDecoder {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseDecoder.class);
    private final IntObjectMap<HttpResponseWrapper> responses = new IntObjectHashMap<HttpResponseWrapper>();
    private final Channel channel;
    private final InboundTrafficController inboundTrafficController;
    @Nullable
    private HttpSession httpSession;
    private int unfinishedResponses;
    private boolean closing;

    HttpResponseDecoder(Channel channel, InboundTrafficController inboundTrafficController) {
        this.channel = channel;
        this.inboundTrafficController = inboundTrafficController;
    }

    final Channel channel() {
        return this.channel;
    }

    final InboundTrafficController inboundTrafficController() {
        return this.inboundTrafficController;
    }

    HttpResponseWrapper addResponse(int id, DecodedHttpResponse res, ClientRequestContext ctx, EventLoop eventLoop, long responseTimeoutMillis, long maxContentLength) {
        HttpResponseWrapper newRes = new HttpResponseWrapper(res, ctx, responseTimeoutMillis, maxContentLength);
        HttpResponseWrapper oldRes = this.responses.put(id, newRes);
        KeepAliveHandler keepAliveHandler = this.keepAliveHandler();
        if (keepAliveHandler != null) {
            keepAliveHandler.increaseNumRequests();
        }
        assert (oldRes == null) : "addResponse(" + id + ", " + res + ", " + responseTimeoutMillis + "): " + oldRes;
        this.onResponseAdded(id, eventLoop, newRes);
        return newRes;
    }

    abstract void onResponseAdded(int var1, EventLoop var2, HttpResponseWrapper var3);

    @Nullable
    final HttpResponseWrapper getResponse(int id) {
        return this.responses.get(id);
    }

    @Nullable
    final HttpResponseWrapper removeResponse(int id) {
        if (this.closing) {
            return null;
        }
        HttpResponseWrapper removed = this.responses.remove(id);
        if (removed != null) {
            --this.unfinishedResponses;
            assert (this.unfinishedResponses >= 0) : this.unfinishedResponses;
        }
        return removed;
    }

    final boolean hasUnfinishedResponses() {
        return this.unfinishedResponses != 0;
    }

    final boolean reserveUnfinishedResponse(int maxUnfinishedResponses) {
        if (this.unfinishedResponses >= maxUnfinishedResponses) {
            return false;
        }
        ++this.unfinishedResponses;
        return true;
    }

    final void decrementUnfinishedResponses() {
        --this.unfinishedResponses;
    }

    final void failUnfinishedResponses(Throwable cause) {
        if (this.closing) {
            return;
        }
        this.closing = true;
        Iterator iterator = this.responses.values().iterator();
        while (iterator.hasNext()) {
            HttpResponseWrapper res = (HttpResponseWrapper)iterator.next();
            iterator.remove();
            --this.unfinishedResponses;
            res.close(cause);
        }
    }

    HttpSession session() {
        if (this.httpSession != null) {
            return this.httpSession;
        }
        this.httpSession = HttpSession.get(this.channel);
        return this.httpSession;
    }

    @Nullable
    abstract KeepAliveHandler keepAliveHandler();

    final boolean needsToDisconnectNow() {
        return !this.session().isAcquirable() && !this.hasUnfinishedResponses();
    }

    static Exception contentTooLargeException(HttpResponseWrapper res, long transferred) {
        ContentTooLargeExceptionBuilder builder = ContentTooLargeException.builder().maxContentLength(res.maxContentLength()).transferred(transferred);
        if (res.contentLengthHeaderValue() >= 0L) {
            builder.contentLength(res.contentLengthHeaderValue());
        }
        return builder.build();
    }

    static final class HttpResponseWrapper
    implements StreamWriter<HttpObject> {
        private final DecodedHttpResponse delegate;
        private final ClientRequestContext ctx;
        private final long maxContentLength;
        private final long responseTimeoutMillis;
        private boolean responseStarted;
        private long contentLengthHeaderValue = -1L;
        private boolean done;
        private boolean closed;

        HttpResponseWrapper(DecodedHttpResponse delegate, ClientRequestContext ctx, long responseTimeoutMillis, long maxContentLength) {
            this.delegate = delegate;
            this.ctx = ctx;
            this.maxContentLength = maxContentLength;
            this.responseTimeoutMillis = responseTimeoutMillis;
        }

        long maxContentLength() {
            return this.maxContentLength;
        }

        long writtenBytes() {
            return this.delegate.writtenBytes();
        }

        long contentLengthHeaderValue() {
            return this.contentLengthHeaderValue;
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long demand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> whenComplete() {
            return this.delegate.whenComplete();
        }

        @Override
        public void subscribe(Subscriber<? super HttpObject> subscriber, EventExecutor executor, SubscriptionOption ... options) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void abort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void abort(Throwable cause) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryWrite(HttpObject o) {
            if (this.done) {
                PooledObjects.close(o);
                return false;
            }
            return this.delegate.tryWrite(o);
        }

        void startResponse() {
            if (this.responseStarted) {
                return;
            }
            this.responseStarted = true;
            this.ctx.logBuilder().startResponse();
            this.ctx.logBuilder().responseFirstBytesTransferred();
            this.initTimeout();
        }

        boolean tryWriteResponseHeaders(ResponseHeaders responseHeaders) {
            assert (responseHeaders.status().codeClass() != HttpStatusClass.INFORMATIONAL);
            this.contentLengthHeaderValue = responseHeaders.contentLength();
            this.ctx.logBuilder().defer(RequestLogProperty.RESPONSE_HEADERS);
            try {
                boolean bl = this.delegate.tryWrite(responseHeaders);
                return bl;
            }
            finally {
                this.ctx.logBuilder().responseHeaders(responseHeaders);
            }
        }

        boolean tryWriteData(HttpData data) {
            if (this.done) {
                PooledObjects.close(data);
                return false;
            }
            data.touch(this.ctx);
            this.ctx.logBuilder().increaseResponseLength(data);
            return this.delegate.tryWrite(data);
        }

        boolean tryWriteTrailers(HttpHeaders trailers) {
            if (this.done) {
                return false;
            }
            this.done = true;
            this.ctx.logBuilder().defer(RequestLogProperty.RESPONSE_TRAILERS);
            try {
                boolean bl = this.delegate.tryWrite(trailers);
                return bl;
            }
            finally {
                this.ctx.logBuilder().responseTrailers(trailers);
            }
        }

        @Override
        public CompletableFuture<Void> whenConsumed() {
            return this.delegate.whenConsumed();
        }

        void onSubscriptionCancelled(@Nullable Throwable cause) {
            this.close(cause, true);
        }

        @Override
        public void close() {
            this.close(null, false);
        }

        @Override
        public void close(Throwable cause) {
            this.close(cause, false);
        }

        private void close(@Nullable Throwable cause, boolean cancel) {
            if (this.closed) {
                return;
            }
            this.done = true;
            this.closed = true;
            this.cancelTimeoutOrLog(cause, cancel);
            HttpRequest request = this.ctx.request();
            assert (request != null);
            if (cause != null) {
                request.abort(cause);
                return;
            }
            long requestAutoAbortDelayMillis = this.ctx.requestAutoAbortDelayMillis();
            if (requestAutoAbortDelayMillis == 0L) {
                request.abort(ResponseCompleteException.get());
                return;
            }
            if (requestAutoAbortDelayMillis > 0L && requestAutoAbortDelayMillis < Long.MAX_VALUE) {
                this.ctx.eventLoop().schedule(() -> request.abort(ResponseCompleteException.get()), requestAutoAbortDelayMillis, TimeUnit.MILLISECONDS);
            }
        }

        private void closeAction(@Nullable Throwable cause) {
            if (cause != null) {
                this.delegate.close(cause);
                this.ctx.logBuilder().endResponse(cause);
            } else {
                this.delegate.close();
                this.ctx.logBuilder().endResponse();
            }
        }

        private void cancelAction(@Nullable Throwable cause) {
            if (cause != null && !(cause instanceof CancelledSubscriptionException)) {
                this.ctx.logBuilder().endResponse(cause);
            } else {
                this.ctx.logBuilder().endResponse();
            }
        }

        private void cancelTimeoutOrLog(@Nullable Throwable cause, boolean cancel) {
            CancellationScheduler responseCancellationScheduler = null;
            ClientRequestContextExtension ctxExtension = this.ctx.as(ClientRequestContextExtension.class);
            if (ctxExtension != null) {
                responseCancellationScheduler = ctxExtension.responseCancellationScheduler();
            }
            if (responseCancellationScheduler == null || !responseCancellationScheduler.isFinished()) {
                if (responseCancellationScheduler != null) {
                    responseCancellationScheduler.clearTimeout(false);
                }
                if (cancel) {
                    this.cancelAction(cause);
                } else {
                    this.closeAction(cause);
                }
                return;
            }
            if (this.delegate.isOpen()) {
                this.closeAction(cause);
            }
            if (cause instanceof ResponseTimeoutException) {
                return;
            }
            if (cause == null || !logger.isWarnEnabled() || Exceptions.isExpected(cause)) {
                return;
            }
            StringBuilder logMsg = new StringBuilder("Unexpected exception while closing a request");
            String authority = this.ctx.request().authority();
            if (authority != null) {
                logMsg.append(" to ").append(authority);
            }
            logger.warn(logMsg.append(':').toString(), cause);
        }

        void initTimeout() {
            ClientRequestContextExtension ctxExtension = this.ctx.as(ClientRequestContextExtension.class);
            if (ctxExtension != null) {
                CancellationScheduler responseCancellationScheduler = ctxExtension.responseCancellationScheduler();
                responseCancellationScheduler.init(this.ctx.eventLoop(), this.newCancellationTask(), TimeUnit.MILLISECONDS.toNanos(this.responseTimeoutMillis), false);
            }
        }

        private CancellationScheduler.CancellationTask newCancellationTask() {
            return new CancellationScheduler.CancellationTask(){

                @Override
                public boolean canSchedule() {
                    return delegate.isOpen() && !done;
                }

                @Override
                public void run(Throwable cause) {
                    delegate.close(cause);
                    ctx.request().abort(cause);
                    ctx.logBuilder().endResponse(cause);
                }
            };
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

