/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.proxy.HAProxyConfig;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageEncoder;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.handler.proxy.ProxyConnectException;
import io.netty.handler.proxy.ProxyConnectionEvent;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

final class HAProxyHandler
extends ChannelOutboundHandlerAdapter {
    private final HAProxyConfig haProxyConfig;
    private static final String PROTOCOL = "haproxy";
    private static final String AUTH = "none";

    HAProxyHandler(HAProxyConfig haProxyConfig) {
        this.haProxyConfig = haProxyConfig;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().addBefore(ctx.name(), null, HAProxyMessageEncoder.INSTANCE);
        super.handlerAdded(ctx);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        InetSocketAddress proxyAddress = this.haProxyConfig.proxyAddress();
        assert (proxyAddress != null);
        promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (!f.isSuccess()) {
                return;
            }
            try {
                ctx.write(HAProxyHandler.createMessage(this.haProxyConfig, ctx.channel(), remoteAddress)).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f0 -> {
                    if (f0.isSuccess()) {
                        ctx.pipeline().remove(HAProxyMessageEncoder.INSTANCE);
                    } else {
                        ctx.fireExceptionCaught(HAProxyHandler.wrapException(f0.cause()));
                        ctx.close();
                    }
                }));
                HAProxyHandler.reschedule(ctx, () -> {
                    ProxyConnectionEvent event = new ProxyConnectionEvent(PROTOCOL, AUTH, proxyAddress, remoteAddress);
                    ctx.pipeline().fireUserEventTriggered(event);
                });
            }
            catch (Exception e) {
                HAProxyHandler.reschedule(ctx, () -> {
                    ctx.pipeline().fireUserEventTriggered(HAProxyHandler.wrapException(e));
                    ctx.close();
                });
            }
            finally {
                ctx.pipeline().remove(this);
            }
        }));
        super.connect(ctx, proxyAddress, localAddress, promise);
    }

    private static ProxyConnectException wrapException(Throwable e) {
        if (e instanceof ProxyConnectException) {
            return (ProxyConnectException)e;
        }
        return new ProxyConnectException(e);
    }

    private static void reschedule(ChannelHandlerContext ctx, Runnable runnable) {
        ctx.channel().eventLoop().execute(runnable);
    }

    private static HAProxyMessage createMessage(HAProxyConfig haProxyConfig, Channel channel, SocketAddress remoteAddress) throws ProxyConnectException {
        InetSocketAddress srcSocketAddress = haProxyConfig.sourceAddress() != null ? haProxyConfig.sourceAddress() : (InetSocketAddress)channel.localAddress();
        InetSocketAddress destSocketAddress = (InetSocketAddress)remoteAddress;
        InetAddress srcAddress = srcSocketAddress.getAddress();
        InetAddress destAddress = destSocketAddress.getAddress();
        if (srcAddress instanceof Inet4Address && destAddress instanceof Inet4Address) {
            return new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, srcAddress.getHostAddress(), destAddress.getHostAddress(), srcSocketAddress.getPort(), destSocketAddress.getPort());
        }
        return new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP6, HAProxyHandler.translateToInet6(srcAddress).getHostAddress(), HAProxyHandler.translateToInet6(destAddress).getHostAddress(), srcSocketAddress.getPort(), destSocketAddress.getPort());
    }

    private static Inet6Address translateToInet6(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return (Inet6Address)inetAddress;
        }
        return NetUtil.getByName(inetAddress.getHostAddress());
    }
}

