/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.DefaultDnsCache;
import com.linecorp.armeria.client.DnsCache;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.util.ThreadFactories;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public final class DnsCacheBuilder {
    private static final ScheduledExecutorService DEFAULT_EXECUTOR = Executors.newSingleThreadScheduledExecutor(ThreadFactories.newThreadFactory("armeria-dns-cache-executor", true));
    static final DnsCache DEFAULT_CACHE = DnsCache.builder().build();
    private String cacheSpec = Flags.dnsCacheSpec();
    private MeterRegistry meterRegistry = Flags.meterRegistry();
    private ScheduledExecutorService executor = DEFAULT_EXECUTOR;
    private int minTtl = 1;
    private int maxTtl = Integer.MAX_VALUE;
    private int negativeTtl;

    DnsCacheBuilder() {
    }

    public DnsCacheBuilder cacheSpec(String cacheSpec) {
        this.cacheSpec = cacheSpec;
        return this;
    }

    public DnsCacheBuilder meterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        return this;
    }

    public DnsCacheBuilder executor(ScheduledExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        this.executor = executor;
        return this;
    }

    public DnsCacheBuilder ttl(int minTtl, int maxTtl) {
        Preconditions.checkArgument(minTtl > 0 && minTtl <= maxTtl, "minTtl: %s, maxTtl: %s (expected: 1 <= minTtl <= maxTtl)", minTtl, maxTtl);
        this.minTtl = minTtl;
        this.maxTtl = maxTtl;
        return this;
    }

    public DnsCacheBuilder negativeTtl(int negativeTtl) {
        Preconditions.checkArgument(negativeTtl >= 0, "negativeTtl: %s (expected: >= 0)", negativeTtl);
        this.negativeTtl = negativeTtl;
        return this;
    }

    public DnsCache build() {
        return new DefaultDnsCache(this.cacheSpec, this.meterRegistry, this.executor, this.minTtl, this.maxTtl, this.negativeTtl);
    }
}

