/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.skywalking.oap.server.core;

public class Const {
    public static final int NONE = 0;
    public static final String SERVICE_ID_CONNECTOR = ".";
    public static final String SERVICE_ID_PARSER_SPLIT = "\\.";
    public static final String ID_CONNECTOR = "_";
    public static final String ID_PARSER_SPLIT = "\\_";
    public static final String RELATION_ID_CONNECTOR = "-";
    public static final String RELATION_ID_PARSER_SPLIT = "\\-";
    public static final String LINE = "-";
    public static final String UNDERSCORE = "_";
    public static final String COMMA = ",";
    public static final String SPACE = " ";
    public static final String KEY_VALUE_SPLIT = ",";
    public static final String ARRAY_SPLIT = "|";
    public static final String ARRAY_PARSER_SPLIT = "\\|";
    public static final String USER_SERVICE_NAME = "User";
    public static final String USER_INSTANCE_NAME = "User";
    public static final String USER_ENDPOINT_NAME = "User";
    public static final String SEGMENT_SPAN_SPLIT = "S";
    public static final String UNKNOWN = "Unknown";
    public static final String EMPTY_STRING = "";
    public static final String POINT = ".";
    public static final String DOUBLE_COLONS_SPLIT = "::";
    public static final String BLANK_ENTITY_NAME = "_blank";

    public static final class TLS_MODE {
        public static final String NON_TLS = "NONE";

        public static final String M_TLS = "mTLS";

        public static final String TLS = "TLS";
    }
}
