/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.ai.pipeline.services;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.ai.pipeline.grpc.HttpRawUri;
import org.apache.skywalking.oap.server.ai.pipeline.grpc.HttpUriRecognitionRequest;
import org.apache.skywalking.oap.server.ai.pipeline.grpc.HttpUriRecognitionResponse;
import org.apache.skywalking.oap.server.ai.pipeline.grpc.HttpUriRecognitionServiceGrpc;
import org.apache.skywalking.oap.server.ai.pipeline.grpc.HttpUriRecognitionSyncRequest;
import org.apache.skywalking.oap.server.ai.pipeline.services.api.HttpUriPattern;
import org.apache.skywalking.oap.server.ai.pipeline.services.api.HttpUriRecognition;
import org.apache.skywalking.oap.server.library.client.grpc.GRPCClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUriRecognitionService
implements HttpUriRecognition {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUriRecognitionService.class);
    private HttpUriRecognitionServiceGrpc.HttpUriRecognitionServiceBlockingStub stub;
    private String version = "NULL";

    public HttpUriRecognitionService(String addr, int port) {
        if (StringUtil.isEmpty((String)addr) || port <= 0) {
            return;
        }
        GRPCClient client = new GRPCClient(addr, port);
        client.connect();
        ManagedChannel channel = client.getChannel();
        this.stub = HttpUriRecognitionServiceGrpc.newBlockingStub((Channel)channel);
    }

    @Override
    public boolean isInitialized() {
        return this.stub != null;
    }

    @Override
    public List<HttpUriPattern> fetchAllPatterns(String service) {
        try {
            if (this.stub == null) {
                return null;
            }
            HttpUriRecognitionResponse httpUriRecognitionResponse = ((HttpUriRecognitionServiceGrpc.HttpUriRecognitionServiceBlockingStub)this.stub.withDeadlineAfter(30L, TimeUnit.SECONDS)).fetchAllPatterns(HttpUriRecognitionSyncRequest.newBuilder().setService(service).setVersion(this.version).build());
            String newVersion = httpUriRecognitionResponse.getVersion();
            if (this.version.equals(newVersion)) {
                return null;
            }
            return httpUriRecognitionResponse.getPatternsList().stream().map(pattern -> new HttpUriPattern(pattern.getPattern())).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("fetch all patterns failed from remote server.", (Throwable)e);
            return null;
        }
    }

    @Override
    public void feedRawData(String service, List<HttpUriRecognition.HTTPUri> unrecognizedURIs) {
        try {
            if (this.stub == null) {
                return;
            }
            HttpUriRecognitionRequest.Builder builder = HttpUriRecognitionRequest.newBuilder();
            builder.setService(service);
            unrecognizedURIs.forEach(httpUri -> builder.getUnrecognizedUrisBuilderList().add(HttpRawUri.newBuilder().setName(httpUri.getName()).setMatchedCounter(httpUri.getMatchedCounter())));
            ((HttpUriRecognitionServiceGrpc.HttpUriRecognitionServiceBlockingStub)this.stub.withDeadlineAfter(30L, TimeUnit.SECONDS)).feedRawData(builder.build());
        }
        catch (Exception e) {
            log.error("feed matched and unmatched URIs to the remote server.", (Throwable)e);
        }
    }
}

