/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.TypeFromAST;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.Directive;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.ObjectField;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.validation.DocumentVisitor;
import java.util.ArrayList;
import java.util.List;

@Internal
public class TraversalContext
implements DocumentVisitor {
    private final GraphQLSchema schema;
    private final List<GraphQLOutputType> outputTypeStack = new ArrayList<GraphQLOutputType>();
    private final List<GraphQLCompositeType> parentTypeStack = new ArrayList<GraphQLCompositeType>();
    private final List<GraphQLInputType> inputTypeStack = new ArrayList<GraphQLInputType>();
    private final List<GraphQLFieldDefinition> fieldDefStack = new ArrayList<GraphQLFieldDefinition>();
    private final List<String> nameStack = new ArrayList<String>();
    private GraphQLDirective directive;
    private GraphQLArgument argument;

    public TraversalContext(GraphQLSchema graphQLSchema) {
        this.schema = graphQLSchema;
    }

    @Override
    public void enter(Node node, List<Node> path) {
        if (node instanceof OperationDefinition) {
            this.enterImpl((OperationDefinition)node);
        } else if (node instanceof SelectionSet) {
            this.enterImpl((SelectionSet)node);
        } else if (node instanceof Field) {
            this.enterImpl((Field)node);
        } else if (node instanceof Directive) {
            this.enterImpl((Directive)node);
        } else if (node instanceof InlineFragment) {
            this.enterImpl((InlineFragment)node);
        } else if (node instanceof FragmentDefinition) {
            this.enterImpl((FragmentDefinition)node);
        } else if (node instanceof VariableDefinition) {
            this.enterImpl((VariableDefinition)node);
        } else if (node instanceof Argument) {
            this.enterImpl((Argument)node);
        } else if (node instanceof ArrayValue) {
            this.enterImpl((ArrayValue)node);
        } else if (node instanceof ObjectField) {
            this.enterImpl((ObjectField)node);
        }
    }

    private void enterImpl(SelectionSet selectionSet) {
        GraphQLUnmodifiedType rawType = GraphQLTypeUtil.unwrapAll(this.getOutputType());
        GraphQLCompositeType parentType = null;
        if (rawType instanceof GraphQLCompositeType) {
            parentType = (GraphQLCompositeType)((Object)rawType);
        }
        this.addParentType(parentType);
    }

    private void enterImpl(Field field) {
        this.enterName(field.getName());
        GraphQLCompositeType parentType = this.getParentType();
        GraphQLFieldDefinition fieldDefinition = null;
        if (parentType != null) {
            fieldDefinition = this.getFieldDef(this.schema, parentType, field);
        }
        this.addFieldDef(fieldDefinition);
        this.addOutputType(fieldDefinition != null ? fieldDefinition.getType() : null);
    }

    private void enterImpl(Directive directive) {
        this.directive = this.schema.getDirective(directive.getName());
    }

    private void enterImpl(OperationDefinition operationDefinition) {
        if (operationDefinition.getOperation() == OperationDefinition.Operation.MUTATION) {
            this.addOutputType(this.schema.getMutationType());
        } else if (operationDefinition.getOperation() == OperationDefinition.Operation.QUERY) {
            this.addOutputType(this.schema.getQueryType());
        } else if (operationDefinition.getOperation() == OperationDefinition.Operation.SUBSCRIPTION) {
            this.addOutputType(this.schema.getSubscriptionType());
        } else {
            Assert.assertShouldNeverHappen();
        }
    }

    private void enterImpl(InlineFragment inlineFragment) {
        GraphQLType typeConditionType;
        TypeName typeCondition = inlineFragment.getTypeCondition();
        GraphQLOutputType type = typeCondition != null ? ((typeConditionType = this.schema.getType(typeCondition.getName())) instanceof GraphQLOutputType ? (GraphQLOutputType)typeConditionType : null) : this.getParentType();
        this.addOutputType(type);
    }

    private void enterImpl(FragmentDefinition fragmentDefinition) {
        this.enterName(fragmentDefinition.getName());
        GraphQLType type = this.schema.getType(fragmentDefinition.getTypeCondition().getName());
        this.addOutputType(type instanceof GraphQLOutputType ? (GraphQLOutputType)type : null);
    }

    private void enterImpl(VariableDefinition variableDefinition) {
        GraphQLType type = TypeFromAST.getTypeFromAST(this.schema, variableDefinition.getType());
        this.addInputType(type instanceof GraphQLInputType ? (GraphQLInputType)type : null);
    }

    private void enterImpl(Argument argument) {
        GraphQLArgument argumentType = null;
        if (this.getDirective() != null) {
            argumentType = this.find(this.getDirective().getArguments(), argument.getName());
        } else if (this.getFieldDef() != null) {
            argumentType = this.find(this.getFieldDef().getArguments(), argument.getName());
        }
        this.addInputType(argumentType != null ? argumentType.getType() : null);
        this.argument = argumentType;
    }

    private void enterImpl(ArrayValue arrayValue) {
        GraphQLNullableType nullableType = this.getNullableType(this.getInputType());
        GraphQLInputType inputType = null;
        if (GraphQLTypeUtil.isList(nullableType)) {
            inputType = (GraphQLInputType)GraphQLTypeUtil.unwrapOne(nullableType);
        }
        this.addInputType(inputType);
    }

    private void enterImpl(ObjectField objectField) {
        GraphQLUnmodifiedType objectType = GraphQLTypeUtil.unwrapAll(this.getInputType());
        GraphQLInputType inputType = null;
        if (objectType instanceof GraphQLInputObjectType) {
            GraphQLInputObjectType inputObjectType = (GraphQLInputObjectType)objectType;
            GraphQLInputObjectField inputField = this.schema.getFieldVisibility().getFieldDefinition(inputObjectType, objectField.getName());
            if (inputField != null) {
                inputType = inputField.getType();
            }
        }
        this.addInputType(inputType);
    }

    private GraphQLArgument find(List<GraphQLArgument> arguments, String name) {
        for (GraphQLArgument argument : arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    @Override
    public void leave(Node node, List<Node> ancestors) {
        if (node instanceof OperationDefinition) {
            this.outputTypeStack.remove(this.outputTypeStack.size() - 1);
        } else if (node instanceof SelectionSet) {
            this.parentTypeStack.remove(this.parentTypeStack.size() - 1);
        } else if (node instanceof Field) {
            this.leaveName(((Field)node).getName());
            this.fieldDefStack.remove(this.fieldDefStack.size() - 1);
            this.outputTypeStack.remove(this.outputTypeStack.size() - 1);
        } else if (node instanceof Directive) {
            this.directive = null;
        } else if (node instanceof InlineFragment) {
            this.outputTypeStack.remove(this.outputTypeStack.size() - 1);
        } else if (node instanceof FragmentDefinition) {
            this.leaveName(((FragmentDefinition)node).getName());
            this.outputTypeStack.remove(this.outputTypeStack.size() - 1);
        } else if (node instanceof VariableDefinition) {
            this.inputTypeStack.remove(this.inputTypeStack.size() - 1);
        } else if (node instanceof Argument) {
            this.argument = null;
            this.inputTypeStack.remove(this.inputTypeStack.size() - 1);
        } else if (node instanceof ArrayValue) {
            this.inputTypeStack.remove(this.inputTypeStack.size() - 1);
        } else if (node instanceof ObjectField) {
            this.inputTypeStack.remove(this.inputTypeStack.size() - 1);
        }
    }

    private void enterName(String name) {
        if (!this.isEmpty(name)) {
            this.nameStack.add(name);
        }
    }

    private void leaveName(String name) {
        if (!this.isEmpty(name)) {
            this.nameStack.remove(this.nameStack.size() - 1);
        }
    }

    private boolean isEmpty(String name) {
        return name == null || name.isEmpty();
    }

    private GraphQLNullableType getNullableType(GraphQLType type) {
        return (GraphQLNullableType)(GraphQLTypeUtil.isNonNull(type) ? GraphQLTypeUtil.unwrapOne(type) : type);
    }

    public GraphQLOutputType getOutputType() {
        return this.lastElement(this.outputTypeStack);
    }

    private void addOutputType(GraphQLOutputType type) {
        this.outputTypeStack.add(type);
    }

    private <T> T lastElement(List<T> list) {
        if (list.size() == 0) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public GraphQLCompositeType getParentType() {
        return this.lastElement(this.parentTypeStack);
    }

    private void addParentType(GraphQLCompositeType compositeType) {
        this.parentTypeStack.add(compositeType);
    }

    public GraphQLInputType getInputType() {
        return this.lastElement(this.inputTypeStack);
    }

    private void addInputType(GraphQLInputType graphQLInputType) {
        this.inputTypeStack.add(graphQLInputType);
    }

    public GraphQLFieldDefinition getFieldDef() {
        return this.lastElement(this.fieldDefStack);
    }

    public List<String> getQueryPath() {
        if (this.nameStack.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.nameStack);
    }

    private void addFieldDef(GraphQLFieldDefinition fieldDefinition) {
        this.fieldDefStack.add(fieldDefinition);
    }

    public GraphQLDirective getDirective() {
        return this.directive;
    }

    public GraphQLArgument getArgument() {
        return this.argument;
    }

    private GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLType parentType, Field field) {
        if (schema.getQueryType().equals(parentType)) {
            if (field.getName().equals(schema.getIntrospectionSchemaFieldDefinition().getName())) {
                return schema.getIntrospectionSchemaFieldDefinition();
            }
            if (field.getName().equals(schema.getIntrospectionTypeFieldDefinition().getName())) {
                return schema.getIntrospectionTypeFieldDefinition();
            }
        }
        if (field.getName().equals(schema.getIntrospectionTypenameFieldDefinition().getName()) && (parentType instanceof GraphQLObjectType || parentType instanceof GraphQLInterfaceType || parentType instanceof GraphQLUnionType)) {
            return schema.getIntrospectionTypenameFieldDefinition();
        }
        if (parentType instanceof GraphQLFieldsContainer) {
            return schema.getFieldVisibility().getFieldDefinition((GraphQLFieldsContainer)parentType, field.getName());
        }
        return null;
    }
}

