/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.PublicSpi;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategy;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

@PublicSpi
public abstract class AbstractAsyncExecutionStrategy
extends ExecutionStrategy {
    public AbstractAsyncExecutionStrategy() {
    }

    public AbstractAsyncExecutionStrategy(DataFetcherExceptionHandler dataFetcherExceptionHandler) {
        super(dataFetcherExceptionHandler);
    }

    protected BiConsumer<List<ExecutionResult>, Throwable> handleResults(ExecutionContext executionContext, List<String> fieldNames, CompletableFuture<ExecutionResult> overallResult) {
        return (results, exception) -> {
            if (exception != null) {
                this.handleNonNullException(executionContext, overallResult, (Throwable)exception);
                return;
            }
            LinkedHashMap resolvedValuesByField = new LinkedHashMap(fieldNames.size());
            int ix = 0;
            for (ExecutionResult executionResult : results) {
                String fieldName = (String)fieldNames.get(ix++);
                resolvedValuesByField.put(fieldName, executionResult.getData());
            }
            overallResult.complete(new ExecutionResultImpl(resolvedValuesByField, executionContext.getErrors()));
        };
    }
}

