/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.management.ui.template.UITemplate;
import org.apache.skywalking.oap.server.core.query.input.DashboardSetting;
import org.apache.skywalking.oap.server.core.query.type.DashboardConfiguration;
import org.apache.skywalking.oap.server.core.query.type.TemplateChangeStatus;
import org.apache.skywalking.oap.server.core.storage.SessionCacheCallback;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.HashMapConverter;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.TableMetaInfo;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCSQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUITemplateManagementDAO
extends JDBCSQLExecutor
implements UITemplateManagementDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCUITemplateManagementDAO.class);
    private final JDBCClient h2Client;
    private final TableHelper tableHelper;

    public DashboardConfiguration getTemplate(String id) {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        List<String> tables = this.tableHelper.getTablesWithinTTL("ui_template");
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(1);
            sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ?").append(" and id=? LIMIT 1 ");
            condition.add("ui_template");
            condition.add(id);
            DashboardConfiguration result = (DashboardConfiguration)this.h2Client.executeQuery(sql.toString(), resultSet -> {
                UITemplate.Builder builder = new UITemplate.Builder();
                UITemplate uiTemplate = (UITemplate)this.toStorageData(resultSet, "ui_template", (StorageBuilder<? extends StorageData>)builder);
                if (uiTemplate != null) {
                    return new DashboardConfiguration().fromEntity(uiTemplate);
                }
                return null;
            }, condition.toArray(new Object[0]));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<DashboardConfiguration> getAllTemplates(Boolean includingDisabled) {
        List<String> tables = this.tableHelper.getTablesWithinTTL("ui_template");
        ArrayList<DashboardConfiguration> configs = new ArrayList<DashboardConfiguration>();
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<Object> condition = new ArrayList<Object>(1);
            sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ? ");
            condition.add("ui_template");
            if (!includingDisabled.booleanValue()) {
                sql.append(" and ").append("disabled").append("=?");
                condition.add(BooleanUtils.booleanToValue((Boolean)includingDisabled));
            }
            this.h2Client.executeQuery(sql.toString(), resultSet -> {
                UITemplate.Builder builder = new UITemplate.Builder();
                UITemplate uiTemplate = null;
                do {
                    if ((uiTemplate = (UITemplate)this.toStorageData(resultSet, "ui_template", (StorageBuilder<? extends StorageData>)builder)) == null) continue;
                    configs.add(new DashboardConfiguration().fromEntity(uiTemplate));
                } while (uiTemplate != null);
                return null;
            }, condition.toArray(new Object[0]));
        }
        return configs;
    }

    public TemplateChangeStatus addTemplate(DashboardSetting setting) throws IOException {
        TemplateChangeStatus templateChangeStatus;
        block8: {
            UITemplate uiTemplate = setting.toEntity();
            Model model = TableMetaInfo.get("ui_template");
            SQLExecutor insertExecutor = this.getInsertExecutor(model, uiTemplate, 0L, new UITemplate.Builder(), (Convert2Storage<Map<String, Object>>)new HashMapConverter.ToStorage(), (SessionCacheCallback)null);
            Connection connection = this.h2Client.getConnection();
            try {
                insertExecutor.invoke(connection);
                templateChangeStatus = TemplateChangeStatus.builder().status(true).id(setting.getId()).build();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return TemplateChangeStatus.builder().status(false).id(setting.getId()).message("Can't add a new template").build();
                }
            }
            connection.close();
        }
        return templateChangeStatus;
    }

    public TemplateChangeStatus changeTemplate(DashboardSetting setting) throws IOException {
        UITemplate uiTemplate = setting.toEntity();
        return this.executeUpdate(uiTemplate);
    }

    public TemplateChangeStatus disableTemplate(String id) throws IOException {
        UITemplate uiTemplate = (UITemplate)this.getByID(this.h2Client, "ui_template", id, new UITemplate.Builder());
        if (uiTemplate == null) {
            return TemplateChangeStatus.builder().status(false).id(id).message("Can't find the template").build();
        }
        uiTemplate.setDisabled(1);
        return this.executeUpdate(uiTemplate);
    }

    private TemplateChangeStatus executeUpdate(UITemplate uiTemplate) throws IOException {
        TemplateChangeStatus templateChangeStatus;
        block8: {
            Model model = TableMetaInfo.get("ui_template");
            SQLExecutor updateExecutor = this.getUpdateExecutor(model, uiTemplate, 0L, new UITemplate.Builder(), (SessionCacheCallback)null);
            Connection connection = this.h2Client.getConnection();
            try {
                updateExecutor.invoke(connection);
                templateChangeStatus = TemplateChangeStatus.builder().status(true).id(uiTemplate.getTemplateId()).build();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return TemplateChangeStatus.builder().status(false).id(uiTemplate.getTemplateId()).message("Can't add/update the template").build();
                }
            }
            connection.close();
        }
        return templateChangeStatus;
    }

    @Generated
    public JDBCUITemplateManagementDAO(JDBCClient h2Client, TableHelper tableHelper) {
        this.h2Client = h2Client;
        this.tableHelper = tableHelper;
    }
}

