/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;
import org.apache.skywalking.oap.server.core.query.type.IntValues;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.query.type.NullableValue;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCSQLExecutor;

public class JDBCMetricsQueryDAO
extends JDBCSQLExecutor
implements IMetricsQueryDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public NullableValue readMetricsValue(MetricsCondition condition, String valueColumnName, Duration duration) {
        String op;
        List<String> tables = this.tableHelper.getTablesForRead(condition.getName(), duration.getStartTimeBucket(), duration.getEndTimeBucket());
        List pointOfTimes = duration.assembleDurationPoints();
        String entityId = condition.getEntity().buildId();
        List ids = pointOfTimes.stream().map(pointOfTime -> TableHelper.generateId(condition.getName(), pointOfTime.id(entityId))).collect(Collectors.toList());
        int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
        Function function = ValueColumnMetadata.INSTANCE.getValueFunction(condition.getName());
        if (function == Function.Latest) {
            return this.readMetricsValues(condition, valueColumnName, duration).getValues().latestValue(defaultValue);
        }
        switch (function) {
            case Avg: {
                op = "avg";
                break;
            }
            default: {
                op = "sum";
            }
        }
        ArrayList results = new ArrayList();
        for (String table : tables) {
            StringBuilder sql = this.buildMetricsValueSql(op, valueColumnName, table);
            ArrayList<String> parameters = new ArrayList<String>();
            if (entityId != null) {
                sql.append("entity_id = ? and ");
                parameters.add(entityId);
            }
            sql.append("id in ");
            sql.append(ids.stream().map(it -> "?").collect(Collectors.joining(", ", "(", ")")));
            parameters.addAll(ids);
            sql.append(" and ").append("table_name").append(" = ?");
            parameters.add(condition.getName());
            sql.append(" group by entity_id");
            this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                if (resultSet.next()) {
                    results.add(resultSet.getLong("result"));
                }
                return null;
            }, parameters.toArray(new Object[0]));
        }
        if (results.size() == 0) {
            return new NullableValue((long)defaultValue, true);
        }
        if (op.equals("avg")) {
            return new NullableValue(results.stream().mapToLong(it -> it).sum() / (long)results.size(), false);
        }
        return new NullableValue(results.stream().mapToLong(it -> it).sum(), false);
    }

    protected StringBuilder buildMetricsValueSql(String op, String valueColumnName, String conditionName) {
        return new StringBuilder("select entity_id id, " + op + "(" + valueColumnName + ") result from " + conditionName + " where ");
    }

    public MetricsValues readMetricsValues(MetricsCondition condition, String valueColumnName, Duration duration) {
        MetricsValues metricsValues = new MetricsValues();
        IntValues intValues = metricsValues.getValues();
        List<String> tables = this.tableHelper.getTablesForRead(condition.getName(), duration.getStartTimeBucket(), duration.getEndTimeBucket());
        List pointOfTimes = duration.assembleDurationPoints();
        String entityId = condition.getEntity().buildId();
        List<String> ids = pointOfTimes.stream().map(pointOfTime -> TableHelper.generateId(condition.getName(), pointOfTime.id(entityId))).collect(Collectors.toList());
        for (String table : tables) {
            StringBuilder sql = new StringBuilder("select id, " + valueColumnName + " from " + table).append(" where id in ").append(ids.stream().map(it -> "?").collect(Collectors.joining(", ", "(", ")")));
            this.buildShardingCondition(sql, ids, entityId);
            this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                while (resultSet.next()) {
                    KVInt kv = new KVInt();
                    kv.setId(resultSet.getString("id"));
                    kv.setValue(resultSet.getLong(valueColumnName));
                    intValues.addKVInt(kv);
                }
                return null;
            }, ids.toArray(new Object[0]));
        }
        metricsValues.setValues(IMetricsQueryDAO.Util.sortValues((IntValues)intValues, ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName())));
        return metricsValues;
    }

    public List<MetricsValues> readLabeledMetricsValues(MetricsCondition condition, String valueColumnName, List<String> labels, Duration duration) {
        HashMap idMap = new HashMap();
        List<String> tables = this.tableHelper.getTablesForRead(condition.getName(), duration.getStartTimeBucket(), duration.getEndTimeBucket());
        List pointOfTimes = duration.assembleDurationPoints();
        String entityId = condition.getEntity().buildId();
        List<String> ids = pointOfTimes.stream().map(pointOfTime -> TableHelper.generateId(condition.getName(), pointOfTime.id(entityId))).collect(Collectors.toList());
        for (String table : tables) {
            StringBuilder sql = new StringBuilder("select id, " + valueColumnName + " from " + table).append(" where id in ").append(ids.stream().map(it -> "?").collect(Collectors.joining(", ", "(", ")")));
            this.buildShardingCondition(sql, ids, entityId);
            this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                while (resultSet.next()) {
                    String id = resultSet.getString("id");
                    DataTable multipleValues = new DataTable(5);
                    multipleValues.toObject(resultSet.getString(valueColumnName));
                    idMap.put(id, multipleValues);
                }
                return null;
            }, ids.toArray(new Object[0]));
        }
        return IMetricsQueryDAO.Util.sortValues((List)IMetricsQueryDAO.Util.composeLabelValue((MetricsCondition)condition, labels, idMap), ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName()));
    }

    public HeatMap readHeatMap(MetricsCondition condition, String valueColumnName, Duration duration) {
        List<String> tables = this.tableHelper.getTablesForRead(condition.getName(), duration.getStartTimeBucket(), duration.getEndTimeBucket());
        HeatMap heatMap = new HeatMap();
        for (String table : tables) {
            List pointOfTimes = duration.assembleDurationPoints();
            String entityId = condition.getEntity().buildId();
            List<String> ids = pointOfTimes.stream().map(pointOfTime -> TableHelper.generateId(condition.getName(), pointOfTime.id(entityId))).collect(Collectors.toList());
            StringBuilder sql = new StringBuilder("select id, " + valueColumnName + " dataset, id from " + table).append(" where id in ").append(ids.stream().map(it -> "?").collect(Collectors.joining(", ", "(", ")")));
            this.buildShardingCondition(sql, ids, entityId);
            int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
            this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                while (resultSet.next()) {
                    heatMap.buildColumn(resultSet.getString("id"), resultSet.getString("dataset"), defaultValue);
                }
                heatMap.fixMissingColumns(ids, defaultValue);
                return null;
            }, ids.toArray(new Object[0]));
        }
        return heatMap;
    }

    protected void buildShardingCondition(StringBuilder sql, List<String> parameters, String entityId) {
    }

    @Generated
    public JDBCMetricsQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

