/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.endpoint.EndpointTraffic;
import org.apache.skywalking.oap.server.core.analysis.manual.instance.InstanceTraffic;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessDetectType;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessTraffic;
import org.apache.skywalking.oap.server.core.analysis.manual.service.ServiceTraffic;
import org.apache.skywalking.oap.server.core.query.enumeration.Language;
import org.apache.skywalking.oap.server.core.query.enumeration.ProfilingSupportStatus;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Attribute;
import org.apache.skywalking.oap.server.core.query.type.Endpoint;
import org.apache.skywalking.oap.server.core.query.type.Process;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.JDBCEntityConverters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCMetadataQueryDAO
implements IMetadataQueryDAO {
    private static final Gson GSON = new Gson();
    private final JDBCClient jdbcClient;
    private final int metadataQueryMaxSize;
    private final TableHelper tableHelper;

    public JDBCMetadataQueryDAO(JDBCClient jdbcClient, int metadataQueryMaxSize, ModuleManager moduleManager) {
        this.jdbcClient = jdbcClient;
        this.metadataQueryMaxSize = metadataQueryMaxSize;
        this.tableHelper = new TableHelper(moduleManager, jdbcClient);
    }

    public List<Service> listServices(String layer, String group) {
        ArrayList results = new ArrayList();
        List<String> tables = this.tableHelper.getTablesWithinTTL("service_traffic");
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQLForListServices(layer, group, table);
            results.addAll((Collection)this.jdbcClient.executeQuery(sqlAndParameters.sql(), this::buildServices, sqlAndParameters.parameters()));
        }
        return results.stream().limit(this.metadataQueryMaxSize).collect(Collectors.toList());
    }

    protected SQLAndParameters buildSQLForListServices(String layer, String group, String table) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(5);
        sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ? ");
        parameters.add("service_traffic");
        if (StringUtil.isNotEmpty((String)layer)) {
            sql.append(" and ").append("layer").append(" = ?");
            parameters.add(Layer.valueOf((String)layer).value());
        }
        if (StringUtil.isNotEmpty((String)group)) {
            sql.append(" and ").append("service_group").append(" = ?");
            parameters.add(group);
        }
        sql.append(" limit ").append(this.metadataQueryMaxSize);
        return new SQLAndParameters(sql.toString(), parameters);
    }

    public List<Service> getServices(String serviceId) {
        List<String> tables = this.tableHelper.getTablesWithinTTL("service_traffic");
        ArrayList results = new ArrayList();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQLForGetServices(serviceId, table);
            results.addAll((Collection)this.jdbcClient.executeQuery(sqlAndParameters.sql(), this::buildServices, sqlAndParameters.parameters()));
        }
        return results.stream().limit(this.metadataQueryMaxSize).collect(Collectors.toList());
    }

    protected SQLAndParameters buildSQLForGetServices(String serviceId, String table) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(5);
        sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ?").append(" and ").append("service_id").append(" = ?");
        parameters.add("service_traffic");
        parameters.add(serviceId);
        sql.append(" limit ").append(this.metadataQueryMaxSize);
        return new SQLAndParameters(sql.toString(), parameters);
    }

    public List<ServiceInstance> listInstances(Duration duration, String serviceId) {
        ArrayList results = new ArrayList();
        long minuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)duration.getStartTimestamp());
        List<String> tables = this.tableHelper.getTablesForRead("instance_traffic", duration.getStartTimeBucket(), duration.getEndTimeBucket());
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQLForListInstances(serviceId, minuteTimeBucket, table);
            results.addAll((Collection)this.jdbcClient.executeQuery(sqlAndParameters.sql(), this::buildInstances, sqlAndParameters.parameters()));
        }
        return results.stream().limit(this.metadataQueryMaxSize).collect(Collectors.toList());
    }

    protected SQLAndParameters buildSQLForListInstances(String serviceId, long minuteTimeBucket, String table) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(5);
        sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ?");
        parameters.add("instance_traffic");
        sql.append(" and ").append("last_ping").append(" >= ?");
        parameters.add(minuteTimeBucket);
        sql.append(" and ").append("service_id").append("=?");
        parameters.add(serviceId);
        sql.append(" limit ").append(this.metadataQueryMaxSize);
        return new SQLAndParameters(sql.toString(), parameters);
    }

    public ServiceInstance getInstance(String instanceId) {
        List<String> tables = this.tableHelper.getTablesWithinTTL("instance_traffic");
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(5);
            sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ?");
            condition.add("instance_traffic");
            sql.append(" and ").append("id").append(" = ?");
            condition.add(instanceId);
            sql.append(" limit ").append(this.metadataQueryMaxSize);
            ServiceInstance result = (ServiceInstance)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                List<ServiceInstance> instances = this.buildInstances(resultSet);
                return instances.size() > 0 ? instances.get(0) : null;
            }, condition.toArray(new Object[0]));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<ServiceInstance> getInstances(List<String> instanceIds) throws IOException {
        List<String> tables = this.tableHelper.getTablesWithinTTL("instance_traffic");
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(5);
            sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ?");
            condition.add("instance_traffic");
            for (String instanceId : instanceIds) {
                sql.append(" and ").append("id").append(" = ?");
                condition.add(instanceId);
            }
            sql.append(" limit ").append(instanceIds.size());
            List result = (List)this.jdbcClient.executeQuery(sql.toString(), resultSet -> this.buildInstances(resultSet), condition.toArray(new Object[0]));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<Endpoint> findEndpoint(String keyword, String serviceId, int limit) {
        ArrayList results = new ArrayList();
        List<String> tables = this.tableHelper.getTablesWithinTTL("endpoint_traffic");
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(5);
            sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ?");
            condition.add("endpoint_traffic");
            sql.append(" and ").append("service_id").append("=?");
            condition.add(serviceId);
            sql.append(" and ").append("table_name").append(" = ?");
            condition.add("endpoint_traffic");
            if (!Strings.isNullOrEmpty((String)keyword)) {
                sql.append(" and ").append("endpoint_traffic_name").append(" like concat('%',?,'%') ");
                condition.add(keyword);
            }
            sql.append(" limit ").append(limit);
            results.addAll((Collection)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
                while (resultSet.next()) {
                    EndpointTraffic endpointTraffic = new EndpointTraffic.Builder().storage2Entity(JDBCEntityConverters.toEntity(resultSet));
                    Endpoint endpoint = new Endpoint();
                    endpoint.setId(endpointTraffic.id().build());
                    endpoint.setName(endpointTraffic.getName());
                    endpoints.add(endpoint);
                }
                return endpoints;
            }, condition.toArray(new Object[0])));
        }
        return results.stream().limit(limit).collect(Collectors.toList());
    }

    public List<Process> listProcesses(String serviceId, ProfilingSupportStatus supportStatus, long lastPingStartTimeBucket, long lastPingEndTimeBucket) {
        List<String> tables = lastPingStartTimeBucket > 0L && lastPingEndTimeBucket > 0L ? this.tableHelper.getTablesForRead("process_traffic", lastPingStartTimeBucket, lastPingEndTimeBucket) : this.tableHelper.getTablesWithinTTL("process_traffic");
        ArrayList results = new ArrayList();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQLForListProcesses(serviceId, supportStatus, lastPingStartTimeBucket, lastPingEndTimeBucket, table);
            results.addAll((Collection)this.jdbcClient.executeQuery(sqlAndParameters.sql(), this::buildProcesses, sqlAndParameters.parameters()));
        }
        return results.stream().limit(this.metadataQueryMaxSize).collect(Collectors.toList());
    }

    protected SQLAndParameters buildSQLForListProcesses(String serviceId, ProfilingSupportStatus supportStatus, long lastPingStartTimeBucket, long lastPingEndTimeBucket, String table) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        sql.append("select * from ").append(table);
        sql.append(" where ").append("table_name").append(" = ? ");
        parameters.add("process_traffic");
        this.appendProcessWhereQuery(sql, parameters, serviceId, null, null, supportStatus, lastPingStartTimeBucket, lastPingEndTimeBucket, false);
        sql.append(" limit ").append(this.metadataQueryMaxSize);
        return new SQLAndParameters(sql.toString(), parameters);
    }

    public List<Process> listProcesses(String serviceInstanceId, Duration duration, boolean includeVirtual) {
        List<String> tables = this.tableHelper.getTablesForRead("process_traffic", duration.getStartTimeBucket(), duration.getEndTimeBucket());
        ArrayList results = new ArrayList();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQLForListProcesses(serviceInstanceId, duration, includeVirtual, table);
            results.addAll((Collection)this.jdbcClient.executeQuery(sqlAndParameters.sql(), this::buildProcesses, sqlAndParameters.parameters()));
        }
        return results.stream().limit(this.metadataQueryMaxSize).collect(Collectors.toList());
    }

    protected SQLAndParameters buildSQLForListProcesses(String serviceInstanceId, Duration duration, boolean includeVirtual, String table) {
        long lastPingStartTimeBucket = duration.getStartTimeBucket();
        long lastPingEndTimeBucket = duration.getEndTimeBucket();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> condition = new ArrayList<Object>();
        sql.append("select * from ").append(table);
        sql.append(" where ").append("table_name").append(" = ? ");
        condition.add("process_traffic");
        this.appendProcessWhereQuery(sql, condition, null, serviceInstanceId, null, null, lastPingStartTimeBucket, lastPingEndTimeBucket, includeVirtual);
        sql.append(" limit ").append(this.metadataQueryMaxSize);
        return new SQLAndParameters(sql.toString(), condition);
    }

    public List<Process> listProcesses(String agentId) {
        List<String> tables = this.tableHelper.getTablesWithinTTL("process_traffic");
        ArrayList results = new ArrayList();
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<Object> condition = new ArrayList<Object>(2);
            sql.append("select * from ").append(table);
            sql.append(" where ").append("table_name").append(" = ? ");
            condition.add("process_traffic");
            this.appendProcessWhereQuery(sql, condition, null, null, agentId, null, 0L, 0L, false);
            sql.append(" limit ").append(this.metadataQueryMaxSize);
            results.addAll((Collection)this.jdbcClient.executeQuery(sql.toString(), this::buildProcesses, condition.toArray(new Object[0])));
        }
        return results.stream().limit(this.metadataQueryMaxSize).collect(Collectors.toList());
    }

    public long getProcessCount(String serviceId, ProfilingSupportStatus profilingSupportStatus, long lastPingStartTimeBucket, long lastPingEndTimeBucket) {
        List<String> tables = this.tableHelper.getTablesForRead("process_traffic", lastPingStartTimeBucket, lastPingEndTimeBucket);
        long total = 0L;
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<Object> condition = new ArrayList<Object>(5);
            sql.append("select count(1) total from ").append(table);
            sql.append(" where ").append("table_name").append(" = ? ");
            condition.add("process_traffic");
            this.appendProcessWhereQuery(sql, condition, serviceId, null, null, profilingSupportStatus, lastPingStartTimeBucket, lastPingEndTimeBucket, false);
            total += ((Long)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                if (!resultSet.next()) {
                    return 0L;
                }
                return resultSet.getLong("total");
            }, condition.toArray(new Object[0]))).longValue();
        }
        return total;
    }

    public long getProcessCount(String instanceId) {
        List<String> tables = this.tableHelper.getTablesWithinTTL("process_traffic");
        long total = 0L;
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<Object> condition = new ArrayList<Object>(3);
            sql.append("select count(1) total from ").append(table);
            sql.append(" where ").append("table_name").append(" = ? ");
            condition.add("process_traffic");
            this.appendProcessWhereQuery(sql, condition, null, instanceId, null, null, 0L, 0L, false);
            total += ((Long)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                if (!resultSet.next()) {
                    return 0L;
                }
                return resultSet.getLong("total");
            }, condition.toArray(new Object[0]))).longValue();
        }
        return total;
    }

    private List<Service> buildServices(ResultSet resultSet) throws SQLException {
        ArrayList<Service> services = new ArrayList<Service>();
        while (resultSet.next()) {
            ServiceTraffic serviceTraffic = new ServiceTraffic.Builder().storage2Entity(JDBCEntityConverters.toEntity(resultSet));
            String serviceName = serviceTraffic.getName();
            Service service = new Service();
            service.setId(serviceTraffic.getServiceId());
            service.setName(serviceName);
            service.setShortName(serviceTraffic.getShortName());
            service.setGroup(serviceTraffic.getGroup());
            service.getLayers().add(serviceTraffic.getLayer().name());
            services.add(service);
        }
        return services;
    }

    private List<ServiceInstance> buildInstances(ResultSet resultSet) throws SQLException {
        ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
        while (resultSet.next()) {
            InstanceTraffic instanceTraffic = new InstanceTraffic.Builder().storage2Entity(JDBCEntityConverters.toEntity(resultSet));
            ServiceInstance serviceInstance = new ServiceInstance();
            serviceInstance.setId(instanceTraffic.id().build());
            serviceInstance.setName(instanceTraffic.getName());
            serviceInstance.setInstanceUUID(serviceInstance.getId());
            JsonObject properties = instanceTraffic.getProperties();
            if (properties != null) {
                for (Map.Entry property : properties.entrySet()) {
                    String key = (String)property.getKey();
                    String value = ((JsonElement)property.getValue()).getAsString();
                    if (key.equals("language")) {
                        serviceInstance.setLanguage(Language.value((String)value));
                        continue;
                    }
                    serviceInstance.getAttributes().add(new Attribute(key, value));
                }
            } else {
                serviceInstance.setLanguage(Language.UNKNOWN);
            }
            serviceInstances.add(serviceInstance);
        }
        return serviceInstances;
    }

    private void appendProcessWhereQuery(StringBuilder sql, List<Object> condition, String serviceId, String instanceId, String agentId, ProfilingSupportStatus profilingSupportStatus, long lastPingStartTimeBucket, long lastPingEndTimeBucket, boolean includeVirtual) {
        if (StringUtil.isNotEmpty((String)serviceId)) {
            sql.append(" and ").append("service_id").append("=?");
            condition.add(serviceId);
        }
        if (StringUtil.isNotEmpty((String)instanceId)) {
            if (!condition.isEmpty()) {
                sql.append(" and ");
            }
            sql.append("instance_id").append("=?");
            condition.add(instanceId);
        }
        if (StringUtil.isNotEmpty((String)agentId)) {
            if (!condition.isEmpty()) {
                sql.append(" and ");
            }
            sql.append("agent_id").append("=?");
            condition.add(agentId);
        }
        if (profilingSupportStatus != null) {
            if (!condition.isEmpty()) {
                sql.append(" and ");
            }
            sql.append("profiling_support_status").append("=?");
            condition.add(profilingSupportStatus.value());
        }
        if (lastPingStartTimeBucket > 0L) {
            if (!condition.isEmpty()) {
                sql.append(" and ");
            }
            sql.append("last_ping").append(">=?");
            condition.add(lastPingStartTimeBucket);
        }
        if (!includeVirtual) {
            if (!condition.isEmpty()) {
                sql.append(" and ");
            }
            sql.append("detect_type").append("!=?");
            condition.add(ProcessDetectType.VIRTUAL.value());
        }
    }

    public Process getProcess(String processId) {
        List<String> tables = this.tableHelper.getTablesWithinTTL("process_traffic");
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(5);
            sql.append("select * from ").append(table).append(" where ");
            sql.append("table_name").append(" = ? ");
            condition.add("process_traffic");
            sql.append(" and ").append("id").append(" = ?");
            condition.add(processId);
            sql.append(" limit ").append(this.metadataQueryMaxSize);
            Process result = (Process)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                List<Process> processes = this.buildProcesses(resultSet);
                return processes.size() > 0 ? processes.get(0) : null;
            }, condition.toArray(new Object[0]));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private List<Process> buildProcesses(ResultSet resultSet) throws SQLException {
        ArrayList<Process> processes = new ArrayList<Process>();
        while (resultSet.next()) {
            String labelsJson;
            ProcessTraffic processTraffic = new ProcessTraffic.Builder().storage2Entity(JDBCEntityConverters.toEntity(resultSet));
            Process process = new Process();
            process.setId(processTraffic.id().build());
            process.setName(processTraffic.getName());
            String serviceId = processTraffic.getServiceId();
            process.setServiceId(serviceId);
            process.setServiceName(IDManager.ServiceID.analysisId((String)serviceId).getName());
            String instanceId = processTraffic.getInstanceId();
            process.setInstanceId(instanceId);
            process.setInstanceName(IDManager.ServiceInstanceID.analysisId((String)instanceId).getName());
            process.setAgentId(processTraffic.getAgentId());
            process.setDetectType(ProcessDetectType.valueOf((int)processTraffic.getDetectType()).name());
            process.setProfilingSupportStatus(ProfilingSupportStatus.valueOf((int)processTraffic.getProfilingSupportStatus()).name());
            JsonObject properties = processTraffic.getProperties();
            if (properties != null) {
                for (Map.Entry property : properties.entrySet()) {
                    String key = (String)property.getKey();
                    String value = ((JsonElement)property.getValue()).getAsString();
                    process.getAttributes().add(new Attribute(key, value));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(labelsJson = processTraffic.getLabelsJson()))) {
                List labels = (List)GSON.fromJson(labelsJson, ArrayList.class);
                process.getLabels().addAll(labels);
            }
            processes.add(process);
        }
        return processes;
    }
}

