/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.AlarmMessage;
import org.apache.skywalking.oap.server.core.query.type.Alarms;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCAlarmQueryDAO
implements IAlarmQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCAlarmQueryDAO.class);
    protected final JDBCClient jdbcClient;
    protected final ModuleManager manager;
    protected final TableHelper tableHelper;
    private Set<String> searchableTagKeys;

    public Alarms getAlarm(Integer scopeId, String keyword, int limit, int from, Duration duration, List<Tag> tags) {
        if (this.searchableTagKeys == null) {
            ConfigService configService = (ConfigService)this.manager.find("core").provider().getService(ConfigService.class);
            this.searchableTagKeys = new HashSet<String>(Arrays.asList(configService.getSearchableAlarmTags().split(",")));
        }
        if (tags != null && !this.searchableTagKeys.containsAll(tags.stream().map(Tag::getKey).collect(Collectors.toSet()))) {
            log.warn("Searching tags that are not searchable: {}", tags.stream().map(Tag::getKey).filter(Predicate.not(this.searchableTagKeys::contains)).collect(Collectors.toSet()));
            return new Alarms();
        }
        List<String> tables = this.tableHelper.getTablesForRead("alarm_record", duration.getStartTimeBucket(), duration.getEndTimeBucket());
        ArrayList alarmMsgs = new ArrayList();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQL(scopeId, keyword, limit, from, duration, tags, table);
            this.jdbcClient.executeQuery(sqlAndParameters.sql(), resultSet -> {
                while (resultSet.next()) {
                    AlarmMessage message = new AlarmMessage();
                    message.setId(resultSet.getString("id0"));
                    message.setId1(resultSet.getString("id1"));
                    message.setMessage(resultSet.getString("alarm_message"));
                    message.setStartTime(Long.valueOf(resultSet.getLong("start_time")));
                    message.setScope(Scope.Finder.valueOf((int)resultSet.getInt("scope")));
                    message.setScopeId(resultSet.getInt("scope"));
                    String dataBinaryBase64 = resultSet.getString("tags_raw_data");
                    if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                        this.parserDataBinaryBase64(dataBinaryBase64, message.getTags());
                    }
                    alarmMsgs.add(message);
                }
                return null;
            }, sqlAndParameters.parameters());
        }
        return new Alarms(alarmMsgs.stream().sorted(Comparator.comparing(AlarmMessage::getStartTime).reversed()).skip(from).limit(limit).collect(Collectors.toList()));
    }

    protected SQLAndParameters buildSQL(Integer scopeId, String keyword, int limit, int from, Duration duration, List<Tag> tags, String table) {
        int i;
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        long startTB = 0L;
        long endTB = 0L;
        if (Objects.nonNull(duration)) {
            startTB = duration.getStartTimeBucketInSec();
            endTB = duration.getEndTimeBucketInSec();
        }
        sql.append("select * from ").append(table);
        long timeBucket = TableHelper.getTimeBucket(table);
        String tagTable = TableHelper.getTable("alarm_record_tag", timeBucket);
        if (!CollectionUtils.isEmpty(tags)) {
            for (i = 0; i < tags.size(); ++i) {
                sql.append(" inner join ").append(tagTable).append(" ");
                sql.append(tagTable + i);
                sql.append(" on ").append(table).append(".").append("id").append(" = ");
                sql.append(tagTable + i).append(".").append("id");
            }
        }
        sql.append(" where ").append(table).append(".").append("table_name").append(" = ? ");
        parameters.add("alarm_record");
        if (Objects.nonNull(scopeId)) {
            sql.append(" and ").append("scope").append(" = ?");
            parameters.add(scopeId);
        }
        if (startTB != 0L && endTB != 0L) {
            sql.append(" and ").append(table).append(".").append("time_bucket").append(" >= ?");
            parameters.add(startTB);
            sql.append(" and ").append(table).append(".").append("time_bucket").append(" <= ?");
            parameters.add(endTB);
        }
        if (!Strings.isNullOrEmpty((String)keyword)) {
            sql.append(" and ").append("alarm_message").append(" like concat('%',?,'%') ");
            parameters.add(keyword);
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            for (i = 0; i < tags.size(); ++i) {
                sql.append(" and ").append(tagTable + i).append(".");
                sql.append("tags").append(" = ?");
                parameters.add(tags.get(i).toString());
            }
        }
        sql.append(" order by ").append("start_time").append(" desc ");
        sql.append(" limit ").append(from + limit);
        return new SQLAndParameters(sql.toString(), parameters);
    }

    @Generated
    public JDBCAlarmQueryDAO(JDBCClient jdbcClient, ModuleManager manager, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.manager = manager;
        this.tableHelper = tableHelper;
    }
}

