/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCAggregationQueryDAO
implements IAggregationQueryDAO {
    protected final JDBCClient jdbcClient;
    protected final TableHelper tableHelper;

    public List<SelectedRecord> sortMetrics(TopNCondition metrics, String valueColumnName, Duration duration, List<KeyValue> additionalConditions) {
        ArrayList results = new ArrayList();
        List<String> tables = this.tableHelper.getTablesForRead(metrics.getName(), duration.getStartTimeBucket(), duration.getEndTimeBucket());
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQL(metrics, valueColumnName, duration, additionalConditions, table);
            this.jdbcClient.executeQuery(sqlAndParameters.sql(), resultSet -> {
                while (resultSet.next()) {
                    SelectedRecord topNEntity = new SelectedRecord();
                    topNEntity.setId(resultSet.getString("entity_id"));
                    topNEntity.setValue(String.valueOf(resultSet.getInt("result")));
                    results.add(topNEntity);
                }
                return null;
            }, sqlAndParameters.parameters());
        }
        Comparator<SelectedRecord> comparator = Order.ASC.equals((Object)metrics.getOrder()) ? Comparator.comparing(it -> Long.parseLong(it.getValue())) : Comparator.comparing(it -> Long.parseLong(it.getValue())).reversed();
        return results.stream().collect(Collectors.groupingBy(SelectedRecord::getId)).entrySet().stream().map(entry -> {
            SelectedRecord selectedRecord = new SelectedRecord();
            int average = (int)((List)entry.getValue()).stream().map(SelectedRecord::getValue).mapToLong(Long::parseLong).average().orElse(0.0);
            selectedRecord.setId((String)entry.getKey());
            selectedRecord.setValue(String.valueOf(average));
            return selectedRecord;
        }).sorted(comparator).limit(metrics.getTopN()).collect(Collectors.toList());
    }

    protected SQLAndParameters buildSQL(TopNCondition metrics, String valueColumnName, Duration duration, List<KeyValue> queries, String table) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(10);
        sql.append("select result, ").append("entity_id").append(" from (select avg(").append(valueColumnName).append(") as result,").append("entity_id").append(" from ").append(table).append(" where ").append("table_name").append(" = ?").append(" and ").append("time_bucket").append(" >= ? ").append(" and ").append("time_bucket").append(" <= ?");
        parameters.add(metrics.getName());
        parameters.add(duration.getStartTimeBucket());
        parameters.add(duration.getEndTimeBucket());
        if (queries != null) {
            queries.forEach(query -> {
                sql.append(" and ").append(query.getKey()).append(" = ?");
                parameters.add(query.getValue());
            });
        }
        sql.append(" group by ").append("entity_id");
        sql.append(")  as T order by result").append(Order.ASC.equals((Object)metrics.getOrder()) ? " asc" : " desc").append(" limit ").append(metrics.getTopN());
        return new SQLAndParameters(sql.toString(), parameters);
    }

    @Generated
    public JDBCAggregationQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

