/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.FunctionCategory;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.TableMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableHelper.class);
    private final ModuleManager moduleManager;
    private final JDBCClient jdbcClient;
    private final AtomicReference<Object> configService = new AtomicReference();
    private final LoadingCache<String, Boolean> tableExistence = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).build((CacheLoader)new CacheLoader<String, Boolean>(){

        @NonNull
        public Boolean load(@NonNull String tableName) throws Exception {
            if (tableName == null) {
                throw new NullPointerException("tableName is marked non-null but is null");
            }
            return TableHelper.this.jdbcClient.tableExists(tableName);
        }
    });

    public static String getTableName(Model model) {
        String aggFuncName = FunctionCategory.uniqueFunctionName((Class)model.getStreamClass()).replaceAll("-", "_");
        return StringUtil.isNotBlank((String)aggFuncName) ? aggFuncName : model.getName();
    }

    public static String getLatestTableForWrite(Model model) {
        String tableName = TableHelper.getTableName(model);
        if (!model.isTimeSeries()) {
            return tableName;
        }
        long dayTimeBucket = TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Day);
        return tableName + "_" + dayTimeBucket;
    }

    public static String getTable(Model model, long timeBucket) {
        String tableName = TableHelper.getTableName(model);
        if (timeBucket == 0L) {
            timeBucket = TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Day);
        }
        if (!model.isTimeSeries()) {
            return tableName;
        }
        return tableName + "_" + TimeBucket.getTimeBucket((long)TimeBucket.getTimestamp((long)timeBucket), (DownSampling)DownSampling.Day);
    }

    public static String getTable(String rawTableName, long timeBucket) {
        if (timeBucket == 0L) {
            timeBucket = TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Day);
        }
        return rawTableName + "_" + TimeBucket.getTimeBucket((long)TimeBucket.getTimestamp((long)timeBucket), (DownSampling)DownSampling.Day);
    }

    public List<String> getTablesForRead(String modelName, long timeBucketStart, long timeBucketEnd) {
        Model model = TableMetaInfo.get(modelName);
        String rawTableName = TableHelper.getTableName(model);
        if (!model.isTimeSeries()) {
            return Collections.singletonList(rawTableName);
        }
        List<String> ttlTables = this.getTablesWithinTTL(modelName);
        return this.getTablesInTimeBucketRange(modelName, timeBucketStart, timeBucketEnd).stream().filter(ttlTables::contains).filter(table -> {
            try {
                return (Boolean)this.tableExistence.get(table);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public List<String> getTablesInTimeBucketRange(String modelName, long timeBucketStart, long timeBucketEnd) {
        Model model = TableMetaInfo.get(modelName);
        String rawTableName = TableHelper.getTableName(model);
        if (!model.isTimeSeries()) {
            return Collections.singletonList(rawTableName);
        }
        long timestampStart = TimeBucket.getTimestamp((long)timeBucketStart);
        long timestampEnd = TimeBucket.getTimestamp((long)timeBucketEnd);
        LongStream.Builder timeBuckets = LongStream.builder();
        for (long timestamp = timestampStart; timestamp <= timestampEnd; timestamp += TimeUnit.DAYS.toMillis(1L)) {
            timeBuckets.add(TimeBucket.getTimeBucket((long)timestamp, (DownSampling)DownSampling.Day));
        }
        return timeBuckets.build().distinct().mapToObj(timeBucket -> TableHelper.getTable(rawTableName, timeBucket)).collect(Collectors.toList());
    }

    public List<String> getTablesWithinTTL(String modelName) {
        Model model = TableMetaInfo.get(modelName);
        String rawTableName = TableHelper.getTableName(model);
        if (!model.isTimeSeries()) {
            return Collections.singletonList(rawTableName);
        }
        List<Long> ttlTimeBuckets = this.getTTLTimeBuckets(model);
        return ttlTimeBuckets.stream().map(it -> TableHelper.getTable(rawTableName, (long)it)).filter(table -> {
            try {
                return (Boolean)this.tableExistence.get(table);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public static String generateId(Model model, String originalID) {
        if (model.isRecord() && !model.isSuperDataset()) {
            return TableHelper.generateId(model.getName(), originalID);
        }
        if (!model.isMetric() || !TableHelper.isFunctionMetric(model)) {
            return originalID;
        }
        return TableHelper.generateId(model.getName(), originalID);
    }

    public static String generateId(String modelName, String originalID) {
        return modelName + "_" + originalID;
    }

    public static boolean isFunctionMetric(Model model) {
        return StringUtil.isNotBlank((String)FunctionCategory.uniqueFunctionName((Class)model.getStreamClass()));
    }

    public static long getTimeBucket(String table) {
        String[] split = table.split("_");
        return Long.parseLong(split[split.length - 1]);
    }

    List<Long> getTTLTimeBuckets(Model model) {
        int ttl = model.isRecord() ? this.getConfigService().getRecordDataTTL() : this.getConfigService().getMetricsDataTTL();
        return LongStream.rangeClosed(0L, ttl).mapToObj(it -> TimeBucket.getTimeBucket((long)(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(it)), (DownSampling)DownSampling.Day)).distinct().collect(Collectors.toList());
    }

    @Generated
    public TableHelper(ModuleManager moduleManager, JDBCClient jdbcClient) {
        this.moduleManager = moduleManager;
        this.jdbcClient = jdbcClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    private ConfigService getConfigService() {
        Object value = this.configService.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.configService;
            synchronized (atomicReference) {
                value = this.configService.get();
                if (value == null) {
                    ConfigService actualValue = (ConfigService)this.moduleManager.find("core").provider().getService(ConfigService.class);
                    value = actualValue == null ? this.configService : actualValue;
                    this.configService.set(value);
                }
            }
        }
        return (ConfigService)(value == this.configService ? null : value);
    }
}

