/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.metric;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.internal.common.metric.RequestMetricSupport;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.TransientServiceOption;
import com.linecorp.armeria.server.metric.MetricCollectingServiceBuilder;
import io.netty.util.AttributeKey;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;

public final class MetricCollectingService
extends SimpleDecoratingHttpService {
    private static final AttributeKey<Boolean> REQUEST_METRICS_SET = AttributeKey.valueOf(MetricCollectingService.class, (String)"REQUEST_METRICS_SET");
    private final MeterIdPrefixFunction meterIdPrefixFunction;
    @Nullable
    private final BiPredicate<? super RequestContext, ? super RequestLog> successFunction;

    public static Function<? super HttpService, MetricCollectingService> newDecorator(MeterIdPrefixFunction meterIdPrefixFunction) {
        Objects.requireNonNull(meterIdPrefixFunction, "meterIdPrefixFunction");
        return MetricCollectingService.builder(meterIdPrefixFunction).newDecorator();
    }

    public static MetricCollectingServiceBuilder builder(MeterIdPrefixFunction meterIdPrefixFunction) {
        return new MetricCollectingServiceBuilder(meterIdPrefixFunction);
    }

    MetricCollectingService(HttpService delegate, MeterIdPrefixFunction meterIdPrefixFunction, @Nullable BiPredicate<? super RequestContext, ? super RequestLog> successFunction) {
        super(delegate);
        this.meterIdPrefixFunction = Objects.requireNonNull(meterIdPrefixFunction, "meterIdPrefixFunction");
        this.successFunction = successFunction;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        if (ctx.config().transientServiceOptions().contains((Object)TransientServiceOption.WITH_METRIC_COLLECTION)) {
            RequestMetricSupport.setup(ctx, REQUEST_METRICS_SET, this.meterIdPrefixFunction, true, this.successFunction != null ? this.successFunction::test : ctx.config().successFunction());
        }
        return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
    }
}

