/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.docs.DescriptionInfo;
import com.linecorp.armeria.server.docs.DescriptiveTypeInfo;
import com.linecorp.armeria.server.docs.EnumValueInfo;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

public final class EnumInfo
implements DescriptiveTypeInfo {
    private final String name;
    private final List<EnumValueInfo> values;
    private final DescriptionInfo descriptionInfo;

    public EnumInfo(Class<? extends Enum<?>> enumType) {
        this(enumType.getName(), enumType);
    }

    public EnumInfo(Class<? extends Enum<?>> enumType, DescriptionInfo descriptionInfo) {
        this(enumType.getName(), enumType, descriptionInfo);
    }

    public EnumInfo(String name, Class<? extends Enum<?>> enumType) {
        this(name, enumType, DescriptionInfo.empty());
    }

    public EnumInfo(String name, Class<? extends Enum<?>> enumType, DescriptionInfo descriptionInfo) {
        this(name, EnumInfo.toEnumValues(enumType), descriptionInfo);
    }

    public EnumInfo(String name, Iterable<EnumValueInfo> values) {
        this(name, values, DescriptionInfo.empty());
    }

    public EnumInfo(String name, Iterable<EnumValueInfo> values, DescriptionInfo descriptionInfo) {
        this.name = Objects.requireNonNull(name, "name");
        this.values = ImmutableList.copyOf(Objects.requireNonNull(values, "values"));
        this.descriptionInfo = Objects.requireNonNull(descriptionInfo, "descriptionInfo");
    }

    @Override
    public String name() {
        return this.name;
    }

    @JsonProperty
    public List<EnumValueInfo> values() {
        return this.values;
    }

    public EnumInfo withValues(Iterable<EnumValueInfo> values) {
        Objects.requireNonNull(values, "values");
        if (values.equals(this.values)) {
            return this;
        }
        return new EnumInfo(this.name, values, this.descriptionInfo);
    }

    @Override
    public DescriptionInfo descriptionInfo() {
        return this.descriptionInfo;
    }

    public EnumInfo withDescriptionInfo(DescriptionInfo descriptionInfo) {
        Objects.requireNonNull(descriptionInfo, "descriptionInfo");
        if (descriptionInfo.equals(this.descriptionInfo)) {
            return this;
        }
        return new EnumInfo(this.name, this.values, descriptionInfo);
    }

    private static List<EnumValueInfo> toEnumValues(Class<? extends Enum<?>> enumType) {
        Class<? extends Enum<?>> rawEnumType = Objects.requireNonNull(enumType, "enumType");
        EnumSet<Enum<?>> values = EnumSet.allOf(rawEnumType);
        return values.stream().map(e -> new EnumValueInfo(e.name())).collect(ImmutableList.toImmutableList());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnumInfo)) {
            return false;
        }
        EnumInfo that = (EnumInfo)o;
        return this.name.equals(that.name) && this.values.equals(that.values) && this.descriptionInfo.equals(that.descriptionInfo);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values, this.descriptionInfo);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("values", this.values).add("descriptionInfo", this.descriptionInfo).toString();
    }
}

