/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.docs.TypeSignature;
import com.linecorp.armeria.server.docs.TypeSignatureType;
import java.util.Objects;
import java.util.regex.Pattern;

class DefaultTypeSignature
implements TypeSignature {
    private static final Pattern BASE_PATTERN = Pattern.compile("^([^.<>]+)$");
    private final TypeSignatureType type;
    private final String name;

    static void checkBaseTypeName(String baseTypeName, String parameterName) {
        Objects.requireNonNull(baseTypeName, parameterName);
        Preconditions.checkArgument(BASE_PATTERN.matcher(baseTypeName).matches(), "%s: %s", (Object)parameterName, (Object)baseTypeName);
    }

    DefaultTypeSignature(TypeSignatureType type, String name) {
        this.type = type;
        this.name = name;
    }

    @Override
    public TypeSignatureType type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultTypeSignature)) {
            return false;
        }
        DefaultTypeSignature that = (DefaultTypeSignature)o;
        return this.type == that.type && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    public String toString() {
        return this.signature();
    }
}

