/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.auth;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.auth.AuthFailureHandler;
import com.linecorp.armeria.server.auth.AuthSuccessHandler;
import com.linecorp.armeria.server.auth.AuthorizationStatusImpl;

public interface AuthorizationStatus {
    public static AuthorizationStatus of(boolean isAuthorized) {
        return isAuthorized ? AuthorizationStatusImpl.SUCCESS : AuthorizationStatusImpl.FAILURE;
    }

    public static AuthorizationStatus ofSuccess() {
        return AuthorizationStatusImpl.SUCCESS;
    }

    public static AuthorizationStatus ofSuccess(@Nullable AuthSuccessHandler successHandler) {
        return new AuthorizationStatusImpl(successHandler);
    }

    public static AuthorizationStatus ofFailure(@Nullable AuthFailureHandler failureHandler) {
        return new AuthorizationStatusImpl(failureHandler);
    }

    public boolean isAuthorized();

    @Nullable
    public AuthSuccessHandler successHandler();

    @Nullable
    public AuthFailureHandler failureHandler();
}

