/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.DefaultHttpRequest;
import com.linecorp.armeria.internal.common.InboundTrafficController;
import com.linecorp.armeria.server.DecodedHttpRequestWriter;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.channel.EventLoop;
import javax.annotation.Nonnull;

final class StreamingDecodedHttpRequest
extends DefaultHttpRequest
implements DecodedHttpRequestWriter {
    private final EventLoop eventLoop;
    private final int id;
    private final int streamId;
    private final boolean keepAlive;
    private final InboundTrafficController inboundTrafficController;
    private final long maxRequestLength;
    private final RoutingContext routingCtx;
    private final ExchangeType exchangeType;
    private final long requestStartTimeNanos;
    private final long requestStartTimeMicros;
    @Nullable
    private ServiceRequestContext ctx;
    private long transferredBytes;
    @Nullable
    private HttpResponse response;
    private boolean isResponseAborted;

    StreamingDecodedHttpRequest(EventLoop eventLoop, int id, int streamId, RequestHeaders headers, boolean keepAlive, InboundTrafficController inboundTrafficController, long maxRequestLength, RoutingContext routingCtx, ExchangeType exchangeType, long requestStartTimeNanos, long requestStartTimeMicros) {
        super(headers);
        this.eventLoop = eventLoop;
        this.id = id;
        this.streamId = streamId;
        this.keepAlive = keepAlive;
        this.inboundTrafficController = inboundTrafficController;
        this.maxRequestLength = maxRequestLength;
        assert (routingCtx.hasResult());
        this.routingCtx = routingCtx;
        this.exchangeType = exchangeType;
        this.requestStartTimeNanos = requestStartTimeNanos;
        this.requestStartTimeMicros = requestStartTimeMicros;
    }

    @Override
    public void init(ServiceRequestContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public RoutingContext routingContext() {
        return this.routingCtx;
    }

    @Override
    @Nonnull
    public Routed<ServiceConfig> route() {
        return this.routingCtx.result();
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int streamId() {
        return this.streamId;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public long maxRequestLength() {
        return this.ctx != null ? this.ctx.maxRequestLength() : this.maxRequestLength;
    }

    @Override
    public long transferredBytes() {
        return this.transferredBytes;
    }

    @Override
    public void increaseTransferredBytes(long delta) {
        this.transferredBytes = this.transferredBytes > Long.MAX_VALUE - delta ? Long.MAX_VALUE : (this.transferredBytes += delta);
    }

    public EventLoop defaultSubscriberExecutor() {
        return this.eventLoop;
    }

    @Override
    public boolean tryWrite(HttpObject obj) {
        boolean published;
        assert (this.ctx != null) : "uninitialized DecodedHttpRequest must be aborted.";
        if (obj instanceof HttpHeaders) {
            published = super.tryWrite(obj);
            this.ctx.logBuilder().requestTrailers((HttpHeaders)obj);
            this.close();
        } else {
            HttpData httpData = (HttpData)obj;
            httpData.touch(this.ctx);
            published = super.tryWrite(httpData);
            if (published) {
                this.ctx.logBuilder().increaseRequestLength(httpData);
                this.inboundTrafficController.inc(httpData.length());
            }
            if (obj.isEndOfStream()) {
                this.close();
            }
        }
        return published;
    }

    @Override
    protected void onRemoval(HttpObject obj) {
        if (obj instanceof HttpData) {
            int length = ((HttpData)obj).length();
            this.inboundTrafficController.dec(length);
        }
    }

    @Override
    public void setResponse(HttpResponse response) {
        if (this.isResponseAborted) {
            if (!response.isComplete()) {
                response.abort();
            }
        } else {
            this.response = response;
        }
    }

    @Override
    public void abortResponse(Throwable cause, boolean cancel) {
        this.isResponseAborted = true;
        if (cancel && this.ctx != null) {
            this.ctx.cancel(cause);
        }
        if (!this.tryClose(cause) && this.response != null && !this.response.isComplete()) {
            this.response.abort(cause);
        }
    }

    @Override
    public boolean needsAggregation() {
        return false;
    }

    @Override
    public ExchangeType exchangeType() {
        return this.exchangeType;
    }

    @Override
    public long requestStartTimeNanos() {
        return this.requestStartTimeNanos;
    }

    @Override
    public long requestStartTimeMicros() {
        return this.requestStartTimeMicros;
    }
}

