/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AbstractRequestContextBuilder;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.common.CancellationScheduler;
import com.linecorp.armeria.internal.server.DefaultServiceRequestContext;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.DefaultRoutingContext;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingResult;
import com.linecorp.armeria.server.RoutingStatus;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServerListener;
import com.linecorp.armeria.server.ServerListenerAdapter;
import com.linecorp.armeria.server.ServiceBindingBuilder;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLSession;

public final class ServiceRequestContextBuilder
extends AbstractRequestContextBuilder {
    private static final HttpService fakeService = (ctx, req) -> HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
    private static final ServerListener rejectingListener = new ServerListenerAdapter(){

        @Override
        public void serverStarting(Server server) {
            throw new UnsupportedOperationException();
        }
    };
    private static final CancellationScheduler.CancellationTask noopCancellationTask = new CancellationScheduler.CancellationTask(){

        @Override
        public boolean canSchedule() {
            return true;
        }

        @Override
        public void run(Throwable cause) {
        }
    };
    private static final CancellationScheduler noopRequestCancellationScheduler = new CancellationScheduler(0L);
    private final List<Consumer<? super ServerBuilder>> serverConfigurators = new ArrayList<Consumer<? super ServerBuilder>>(4);
    private HttpService service = fakeService;
    @Nullable
    private ServiceNaming defaultServiceNaming;
    @Nullable
    private String defaultLogName;
    @Nullable
    private Route route;
    @Nullable
    private RoutingResult routingResult;
    @Nullable
    private ProxiedAddresses proxiedAddresses;

    ServiceRequestContextBuilder(HttpRequest request) {
        super(true, request);
    }

    public ServiceRequestContextBuilder service(HttpService service) {
        this.service = Objects.requireNonNull(service, "service");
        return this;
    }

    public ServiceRequestContextBuilder defaultServiceName(String defaultServiceName) {
        Objects.requireNonNull(defaultServiceName, "defaultServiceName");
        return this.defaultServiceNaming(ServiceNaming.of(defaultServiceName));
    }

    public ServiceRequestContextBuilder defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceNaming = Objects.requireNonNull(defaultServiceNaming, "defaultServiceNaming");
        return this;
    }

    public ServiceRequestContextBuilder defaultLogName(String defaultLogName) {
        this.defaultLogName = Objects.requireNonNull(defaultLogName, "defaultLogName");
        return this;
    }

    public ServiceRequestContextBuilder route(Route route) {
        this.route = Objects.requireNonNull(route, "route");
        return this;
    }

    public ServiceRequestContextBuilder routingResult(RoutingResult routingResult) {
        this.routingResult = Objects.requireNonNull(routingResult, "routingResult");
        return this;
    }

    public ServiceRequestContextBuilder proxiedAddresses(ProxiedAddresses proxiedAddresses) {
        this.proxiedAddresses = Objects.requireNonNull(proxiedAddresses, "proxiedAddresses");
        return this;
    }

    public ServiceRequestContextBuilder serverConfigurator(Consumer<? super ServerBuilder> serverConfigurator) {
        this.serverConfigurators.add(Objects.requireNonNull(serverConfigurator, "serverConfigurator"));
        return this;
    }

    public ServiceRequestContext build() {
        CancellationScheduler requestCancellationScheduler;
        ProxiedAddresses proxiedAddresses = this.proxiedAddresses != null ? this.proxiedAddresses : ProxiedAddresses.of((InetSocketAddress)this.remoteAddress());
        ServerBuilder serverBuilder = Server.builder().meterRegistry(this.meterRegistry()).workerGroup((EventLoopGroup)this.eventLoop(), false);
        ServiceBindingBuilder serviceBindingBuilder = this.route != null ? serverBuilder.route().addRoute(this.route) : serverBuilder.route().path(this.requestTarget().path());
        if (this.defaultServiceNaming != null) {
            serviceBindingBuilder.defaultServiceNaming(this.defaultServiceNaming);
        }
        if (this.defaultLogName != null) {
            serviceBindingBuilder.defaultLogName(this.defaultLogName);
        }
        serviceBindingBuilder.build(this.service);
        this.serverConfigurators.forEach(configurator -> configurator.accept(serverBuilder));
        Server server = serverBuilder.build();
        server.addListener(rejectingListener);
        ServiceConfig serviceCfg = ServiceRequestContextBuilder.findServiceConfig(server, this.service);
        HttpRequest req = this.request();
        assert (req != null);
        RoutingContext routingCtx = DefaultRoutingContext.of(server.config().defaultVirtualHost(), ((InetSocketAddress)this.localAddress()).getHostString(), this.requestTarget(), req.headers(), RoutingStatus.OK);
        RoutingResult routingResult = this.routingResult != null ? this.routingResult : RoutingResult.builder().path(this.requestTarget().path()).query(this.requestTarget().query()).build();
        Route route = Route.builder().path(this.requestTarget().path()).build();
        Routed<ServiceConfig> routed = Routed.of(route, routingResult, serviceCfg);
        routingCtx.setResult(routed);
        ExchangeType exchangeType = this.service.exchangeType(routingCtx);
        InetAddress clientAddress = server.config().clientAddressMapper().apply(proxiedAddresses).getAddress();
        if (this.timedOut()) {
            requestCancellationScheduler = noopRequestCancellationScheduler;
        } else {
            requestCancellationScheduler = new CancellationScheduler(0L);
            CountDownLatch latch = new CountDownLatch(1);
            this.eventLoop().execute(() -> {
                requestCancellationScheduler.init((EventExecutor)this.eventLoop(), noopCancellationTask, 0L, true);
                latch.countDown();
            });
            try {
                latch.await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return new DefaultServiceRequestContext(serviceCfg, this.fakeChannel(), this.meterRegistry(), this.sessionProtocol(), this.id(), routingCtx, routingResult, exchangeType, req, this.sslSession(), proxiedAddresses, clientAddress, requestCancellationScheduler, this.isRequestStartTimeSet() ? this.requestStartTimeNanos() : System.nanoTime(), this.isRequestStartTimeSet() ? this.requestStartTimeMicros() : SystemInfo.currentTimeMicros(), HttpHeaders.of(), HttpHeaders.of());
    }

    private static ServiceConfig findServiceConfig(Server server, HttpService service) {
        for (ServiceConfig cfg : server.config().defaultVirtualHost().serviceConfigs()) {
            if (cfg.service().as(service.getClass()) == null) continue;
            return cfg;
        }
        throw new Error();
    }

    @Override
    public ServiceRequestContextBuilder meterRegistry(MeterRegistry meterRegistry) {
        return (ServiceRequestContextBuilder)super.meterRegistry(meterRegistry);
    }

    @Override
    public ServiceRequestContextBuilder eventLoop(EventLoop eventLoop) {
        return (ServiceRequestContextBuilder)super.eventLoop(eventLoop);
    }

    @Override
    public ServiceRequestContextBuilder alloc(ByteBufAllocator alloc) {
        return (ServiceRequestContextBuilder)super.alloc(alloc);
    }

    @Override
    public ServiceRequestContextBuilder sessionProtocol(SessionProtocol sessionProtocol) {
        return (ServiceRequestContextBuilder)super.sessionProtocol(sessionProtocol);
    }

    @Override
    public ServiceRequestContextBuilder id(RequestId id) {
        return (ServiceRequestContextBuilder)super.id(id);
    }

    @Override
    public ServiceRequestContextBuilder remoteAddress(SocketAddress remoteAddress) {
        Objects.requireNonNull(remoteAddress, "remoteAddress");
        Preconditions.checkArgument(remoteAddress instanceof InetSocketAddress, "remoteAddress: %s (expected: an InetSocketAddress)", (Object)remoteAddress);
        return (ServiceRequestContextBuilder)super.remoteAddress(remoteAddress);
    }

    @Override
    public ServiceRequestContextBuilder localAddress(SocketAddress localAddress) {
        Objects.requireNonNull(localAddress, "remoteAddress");
        Preconditions.checkArgument(localAddress instanceof InetSocketAddress, "localAddress: %s (expected: an InetSocketAddress)", (Object)localAddress);
        return (ServiceRequestContextBuilder)super.localAddress(localAddress);
    }

    @Override
    public ServiceRequestContextBuilder sslSession(SSLSession sslSession) {
        return (ServiceRequestContextBuilder)super.sslSession(sslSession);
    }

    @Override
    public ServiceRequestContextBuilder requestStartTime(long requestStartTimeNanos, long requestStartTimeMicros) {
        return (ServiceRequestContextBuilder)super.requestStartTime(requestStartTimeNanos, requestStartTimeMicros);
    }

    @Override
    public ServiceRequestContextBuilder timedOut(boolean timedOut) {
        return (ServiceRequestContextBuilder)super.timedOut(timedOut);
    }

    static {
        noopRequestCancellationScheduler.init((EventExecutor)ImmediateEventExecutor.INSTANCE, noopCancellationTask, 0L, true);
        noopRequestCancellationScheduler.finishNow();
    }
}

