/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.AbstractBindingBuilder;
import com.linecorp.armeria.server.DecoratingHttpServiceFunction;
import com.linecorp.armeria.server.DefaultServiceConfigSetters;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceConfigBuilder;
import com.linecorp.armeria.server.ServiceConfigSetters;
import com.linecorp.armeria.server.ServiceErrorHandler;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.ServiceWithRoutes;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

abstract class AbstractServiceBindingBuilder
extends AbstractBindingBuilder
implements ServiceConfigSetters {
    private final DefaultServiceConfigSetters defaultServiceConfigSetters = new DefaultServiceConfigSetters();

    AbstractServiceBindingBuilder() {
    }

    @Override
    public AbstractServiceBindingBuilder requestTimeout(Duration requestTimeout) {
        return this.requestTimeoutMillis(Objects.requireNonNull(requestTimeout, "requestTimeout").toMillis());
    }

    @Override
    public AbstractServiceBindingBuilder requestTimeoutMillis(long requestTimeoutMillis) {
        this.defaultServiceConfigSetters.requestTimeoutMillis(requestTimeoutMillis);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder maxRequestLength(long maxRequestLength) {
        this.defaultServiceConfigSetters.maxRequestLength(maxRequestLength);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder verboseResponses(boolean verboseResponses) {
        this.defaultServiceConfigSetters.verboseResponses(verboseResponses);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder accessLogFormat(String accessLogFormat) {
        return this.accessLogWriter(AccessLogWriter.custom(Objects.requireNonNull(accessLogFormat, "accessLogFormat")), true);
    }

    @Override
    public AbstractServiceBindingBuilder accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.accessLogWriter(accessLogWriter, shutdownOnStop);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder decorator(DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return (AbstractServiceBindingBuilder)ServiceConfigSetters.super.decorator(decoratingHttpServiceFunction);
    }

    @Override
    public AbstractServiceBindingBuilder decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        this.defaultServiceConfigSetters.decorator(decorator);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder decorators(Function<? super HttpService, ? extends HttpService> ... decorators) {
        this.defaultServiceConfigSetters.decorators(decorators);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder decorators(Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        this.defaultServiceConfigSetters.decorators(decorators);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder defaultServiceName(String defaultServiceName) {
        this.defaultServiceConfigSetters.defaultServiceName(defaultServiceName);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceConfigSetters.defaultServiceNaming(defaultServiceNaming);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder defaultLogName(String defaultLogName) {
        this.defaultServiceConfigSetters.defaultLogName(defaultLogName);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder blockingTaskExecutor(BlockingTaskExecutor blockingTaskExecutor, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder blockingTaskExecutor(int numThreads) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(numThreads);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder successFunction(SuccessFunction successFunction) {
        this.defaultServiceConfigSetters.successFunction(successFunction);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder multipartUploadsLocation(Path multipartUploadsLocation) {
        this.defaultServiceConfigSetters.multipartUploadsLocation(multipartUploadsLocation);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder requestIdGenerator(Function<? super RoutingContext, ? extends RequestId> requestIdGenerator) {
        this.defaultServiceConfigSetters.requestIdGenerator(requestIdGenerator);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder addHeader(CharSequence name, Object value) {
        this.defaultServiceConfigSetters.addHeader(name, value);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        this.defaultServiceConfigSetters.addHeaders(defaultHeaders);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder setHeader(CharSequence name, Object value) {
        this.defaultServiceConfigSetters.setHeader(name, value);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        this.defaultServiceConfigSetters.setHeaders(defaultHeaders);
        return this;
    }

    @Override
    public AbstractServiceBindingBuilder errorHandler(ServiceErrorHandler serviceErrorHandler) {
        this.defaultServiceConfigSetters.errorHandler(serviceErrorHandler);
        return this;
    }

    abstract void serviceConfigBuilder(ServiceConfigBuilder var1);

    final void build0(HttpService service) {
        ServiceWithRoutes serviceWithRoutes = service.as(ServiceWithRoutes.class);
        Set fallbackRoutes = MoreObjects.firstNonNull(serviceWithRoutes != null ? serviceWithRoutes.routes() : null, ImmutableSet.of());
        List<Route> routes = this.buildRouteList(fallbackRoutes);
        HttpService decoratedService = this.defaultServiceConfigSetters.decorator().apply(service);
        for (Route route : routes) {
            ServiceConfigBuilder serviceConfigBuilder = this.defaultServiceConfigSetters.toServiceConfigBuilder(route, decoratedService);
            this.serviceConfigBuilder(serviceConfigBuilder);
        }
    }

    final void build0(HttpService service, Route mappedRoute) {
        List<Route> routes = this.buildRouteList(ImmutableSet.of());
        assert (routes.size() == 1);
        HttpService decoratedService = this.defaultServiceConfigSetters.decorator().apply(service);
        ServiceConfigBuilder serviceConfigBuilder = this.defaultServiceConfigSetters.toServiceConfigBuilder(routes.get(0), decoratedService);
        serviceConfigBuilder.addMappedRoute(mappedRoute);
        this.serviceConfigBuilder(serviceConfigBuilder);
    }
}

