/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import com.linecorp.armeria.server.HttpHeaderUtil;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RouteBuilder;
import com.linecorp.armeria.server.RoutingPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

abstract class AbstractBindingBuilder {
    private Set<HttpMethod> methods = ImmutableSet.of();
    private Set<MediaType> consumeTypes = ImmutableSet.of();
    private Set<MediaType> produceTypes = ImmutableSet.of();
    private final List<RoutingPredicate<QueryParams>> paramPredicates = new ArrayList<RoutingPredicate<QueryParams>>();
    private final List<RoutingPredicate<HttpHeaders>> headerPredicates = new ArrayList<RoutingPredicate<HttpHeaders>>();
    private final Map<RouteBuilder, Set<HttpMethod>> routeBuilders = new LinkedHashMap<RouteBuilder, Set<HttpMethod>>();
    private final Set<RouteBuilder> pathBuilders = new LinkedHashSet<RouteBuilder>();
    private final List<Route> additionalRoutes = new ArrayList<Route>();
    private final List<Route> excludedRoutes = new ArrayList<Route>();

    AbstractBindingBuilder() {
    }

    public AbstractBindingBuilder path(String pathPattern) {
        this.pathBuilders.add(Route.builder().path(Objects.requireNonNull(pathPattern, "pathPattern")));
        return this;
    }

    public AbstractBindingBuilder pathPrefix(String prefix) {
        this.pathBuilders.add(Route.builder().pathPrefix(Objects.requireNonNull(prefix, "prefix")));
        return this;
    }

    public AbstractBindingBuilder get(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.GET);
        return this;
    }

    public AbstractBindingBuilder post(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.POST);
        return this;
    }

    public AbstractBindingBuilder put(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.PUT);
        return this;
    }

    public AbstractBindingBuilder patch(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.PATCH);
        return this;
    }

    public AbstractBindingBuilder delete(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.DELETE);
        return this;
    }

    public AbstractBindingBuilder options(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.OPTIONS);
        return this;
    }

    public AbstractBindingBuilder head(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.HEAD);
        return this;
    }

    public AbstractBindingBuilder trace(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.TRACE);
        return this;
    }

    public AbstractBindingBuilder connect(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.CONNECT);
        return this;
    }

    private void addRouteBuilder(String pathPattern, HttpMethod method) {
        this.addRouteBuilder(Route.builder().path(Objects.requireNonNull(pathPattern, "pathPattern")), EnumSet.of(method));
    }

    private void addRouteBuilder(RouteBuilder routeBuilder, Set<HttpMethod> methods) {
        Set methodSet = this.routeBuilders.computeIfAbsent(routeBuilder, key -> EnumSet.noneOf(HttpMethod.class));
        for (HttpMethod method : methods) {
            if (methodSet.add(method)) continue;
            throw new IllegalArgumentException("duplicate HTTP method: " + (Object)((Object)method) + ", for: " + routeBuilder);
        }
    }

    public AbstractBindingBuilder methods(HttpMethod ... methods) {
        return this.methods(ImmutableSet.copyOf(Objects.requireNonNull(methods, "methods")));
    }

    public AbstractBindingBuilder methods(Iterable<HttpMethod> methods) {
        Objects.requireNonNull(methods, "methods");
        Preconditions.checkArgument(!Iterables.isEmpty(methods), "methods can't be empty.");
        this.methods = Sets.immutableEnumSet(methods);
        return this;
    }

    public AbstractBindingBuilder consumes(MediaType ... consumeTypes) {
        this.consumes(ImmutableSet.copyOf(Objects.requireNonNull(consumeTypes, "consumeTypes")));
        return this;
    }

    public AbstractBindingBuilder consumes(Iterable<MediaType> consumeTypes) {
        HttpHeaderUtil.ensureUniqueMediaTypes(consumeTypes, "consumeTypes");
        this.consumeTypes = ImmutableSet.copyOf(consumeTypes);
        return this;
    }

    public AbstractBindingBuilder produces(MediaType ... produceTypes) {
        this.produces(ImmutableSet.copyOf(Objects.requireNonNull(produceTypes, "produceTypes")));
        return this;
    }

    public AbstractBindingBuilder produces(Iterable<MediaType> produceTypes) {
        HttpHeaderUtil.ensureUniqueMediaTypes(produceTypes, "produceTypes");
        this.produceTypes = ImmutableSet.copyOf(produceTypes);
        return this;
    }

    public AbstractBindingBuilder matchesParams(String ... paramPredicates) {
        return this.matchesParams(ImmutableList.copyOf(Objects.requireNonNull(paramPredicates, "paramPredicates")));
    }

    public AbstractBindingBuilder matchesParams(Iterable<String> paramPredicates) {
        this.paramPredicates.addAll(RoutingPredicate.copyOfParamPredicates(Objects.requireNonNull(paramPredicates, "paramPredicates")));
        return this;
    }

    public AbstractBindingBuilder matchesParams(String paramName, Predicate<? super String> valuePredicate) {
        Objects.requireNonNull(paramName, "paramName");
        Objects.requireNonNull(valuePredicate, "valuePredicate");
        this.paramPredicates.add(RoutingPredicate.ofParams(paramName, valuePredicate));
        return this;
    }

    public AbstractBindingBuilder matchesHeaders(String ... headerPredicates) {
        return this.matchesHeaders(ImmutableList.copyOf(Objects.requireNonNull(headerPredicates, "headerPredicates")));
    }

    public AbstractBindingBuilder matchesHeaders(Iterable<String> headerPredicates) {
        this.headerPredicates.addAll(RoutingPredicate.copyOfHeaderPredicates(Objects.requireNonNull(headerPredicates, "headerPredicates")));
        return this;
    }

    public AbstractBindingBuilder matchesHeaders(CharSequence headerName, Predicate<? super String> valuePredicate) {
        Objects.requireNonNull(headerName, "headerName");
        Objects.requireNonNull(valuePredicate, "valuePredicate");
        this.headerPredicates.add(RoutingPredicate.ofHeaders(headerName, valuePredicate));
        return this;
    }

    public AbstractBindingBuilder addRoute(Route route) {
        this.additionalRoutes.add(Objects.requireNonNull(route, "route"));
        return this;
    }

    public AbstractBindingBuilder exclude(String pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        this.excludedRoutes.add(Route.builder().path(pathPattern).build());
        return this;
    }

    public AbstractBindingBuilder exclude(Route excludedRoute) {
        this.excludedRoutes.add(Objects.requireNonNull(excludedRoute, "excludedRoute"));
        return this;
    }

    final List<Route> buildRouteList() {
        return this.buildRouteList(ImmutableSet.of());
    }

    final List<Route> buildRouteList(Collection<Route> fallbackRoutes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.additionalRoutes.isEmpty()) {
            if (this.pathBuilders.isEmpty() && this.routeBuilders.isEmpty()) {
                if (fallbackRoutes.isEmpty()) {
                    throw new IllegalStateException("Should set at least one path that the service is bound to before calling this.");
                }
                return ((ImmutableList.Builder)builder.addAll(fallbackRoutes)).build();
            }
            if (this.pathBuilders.isEmpty() && !this.methods.isEmpty()) {
                throw new IllegalStateException("Should set a path when the methods are set: " + this.methods);
            }
        }
        if (!this.pathBuilders.isEmpty()) {
            Set<HttpMethod> pathMethods = this.methods.isEmpty() ? HttpMethod.knownMethods() : this.methods;
            this.pathBuilders.forEach(pathBuilder -> this.addRouteBuilder((RouteBuilder)pathBuilder, pathMethods));
        }
        this.routeBuilders.forEach((routeBuilder, routeMethods) -> builder.add(routeBuilder.methods((Iterable<HttpMethod>)routeMethods).consumes(this.consumeTypes).produces(this.produceTypes).matchesParams(this.paramPredicates).matchesHeaders(this.headerPredicates).exclude(this.excludedRoutes).build()));
        this.additionalRoutes.forEach(builder::add);
        return builder.build();
    }
}

