/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.util;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi;
import com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.x509.KeyFactory;
import com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.security.AccessController;
import java.security.KeyFactorySpi;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactorySpi;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class MinifiedBouncyCastleProvider
extends Provider
implements ConfigurableProvider {
    private static final long serialVersionUID = -834653615603942658L;
    private static final String PROVIDER_NAME = "ArmeriaBC";
    private static final ReentrantLock lock = new ReentrantLock();
    private static final Map<ASN1ObjectIdentifier, AsymmetricKeyInfoConverter> keyInfoConverters = new ConcurrentHashMap<ASN1ObjectIdentifier, AsymmetricKeyInfoConverter>();

    public static void call(Runnable task) {
        MinifiedBouncyCastleProvider.call(() -> {
            task.run();
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T call(Supplier<T> task) {
        lock.lock();
        boolean needToAdd = true;
        for (Provider provider : Security.getProviders()) {
            if (!(provider instanceof MinifiedBouncyCastleProvider)) continue;
            needToAdd = false;
            break;
        }
        if (needToAdd) {
            Security.addProvider(new MinifiedBouncyCastleProvider());
            T t = task.get();
            return t;
            finally {
                Security.removeProvider(PROVIDER_NAME);
            }
        }
        T t = task.get();
        return t;
        finally {
            lock.unlock();
        }
    }

    public MinifiedBouncyCastleProvider() {
        super(PROVIDER_NAME, 1.0, "Armeria Bouncy Castle Provider");
        AccessController.doPrivileged(() -> {
            this.addFactories();
            return true;
        });
    }

    private void addFactories() {
        this.addKeyFactory(com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.rsa.KeyFactorySpi.class, "RSA", new String[0]);
        this.addKeyFactory(com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.dsa.KeyFactorySpi.class, "DSA", new String[0]);
        this.addKeyFactory(KeyFactorySpi.EC.class, "EC", new String[0]);
        this.addKeyFactory(KeyFactory.class, "X.509", "X509");
        this.addCertificateFactory(CertificateFactory.class, "X.509", "X509");
    }

    private void addKeyFactory(Class<? extends KeyFactorySpi> factoryType, String name, String ... aliases) {
        this.addFactory("KeyFactory.", factoryType, name, aliases);
    }

    private void addCertificateFactory(Class<? extends CertificateFactorySpi> factoryType, String name, String ... aliases) {
        this.addFactory("CertificateFactory.", factoryType, name, aliases);
    }

    private void addFactory(String prefix, Class<?> factoryType, String name, String ... aliases) {
        this.addAlgorithm(prefix + name, factoryType.getName());
        for (String alias : aliases) {
            this.addAlgorithm("Alg.Alias." + prefix + alias, name);
        }
    }

    public void setParameter(String parameterName, Object parameter) {
    }

    public boolean hasAlgorithm(String type, String name) {
        return this.containsKey(type + '.' + name) || this.containsKey("Alg.Alias." + type + '.' + name);
    }

    public void addAlgorithm(String key, String value) {
        Preconditions.checkState(!this.containsKey(key), "duplicate algorithm: %s", key);
        this.put(key, value);
    }

    public void addAlgorithm(String type, ASN1ObjectIdentifier oid, String className) {
        this.addAlgorithm(type + '.' + oid, className);
        this.addAlgorithm(type + ".OID." + oid, className);
    }

    public void addKeyInfoConverter(ASN1ObjectIdentifier oid, AsymmetricKeyInfoConverter keyInfoConverter) {
        keyInfoConverters.put(oid, keyInfoConverter);
    }

    public AsymmetricKeyInfoConverter getKeyInfoConverter(ASN1ObjectIdentifier oid) {
        return keyInfoConverters.get(oid);
    }

    public void addAttributes(String key, Map<String, String> attributeMap) {
        for (Map.Entry<String, String> e : attributeMap.entrySet()) {
            String attrKey = key + ' ' + e.getKey();
            Preconditions.checkState(!this.containsKey(attrKey), "duplicate attribute: %s", attrKey);
            this.put(attrKey, e.getValue());
        }
    }
}

