/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.stream.FixedStreamMessage;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;

public class TwoElementFixedStreamMessage<T>
extends FixedStreamMessage<T> {
    @Nullable
    private T obj1;
    @Nullable
    private T obj2;
    private boolean inOnNext;
    private boolean requested;

    public TwoElementFixedStreamMessage(T obj1, T obj2) {
        this.obj1 = obj1;
        this.obj2 = obj2;
    }

    @Override
    public long demand() {
        return this.requested ? 1L : 0L;
    }

    @Override
    final void cleanupObjects(@Nullable Throwable cause) {
        if (this.obj1 != null) {
            StreamMessageUtil.closeOrAbort(this.obj1, cause);
            this.obj1 = null;
        }
        if (this.obj2 != null) {
            StreamMessageUtil.closeOrAbort(this.obj2, cause);
            this.obj2 = null;
        }
    }

    @Override
    final List<T> drainAll(boolean withPooledObjects) {
        assert (this.obj1 != null);
        ImmutableList<T> objs = ImmutableList.of(StreamMessageUtil.touchOrCopyAndClose(this.obj1, withPooledObjects), StreamMessageUtil.touchOrCopyAndClose(this.obj2, withPooledObjects));
        this.obj2 = null;
        this.obj1 = null;
        return objs;
    }

    public void request(long n) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.request0(n);
        } else {
            executor.execute(() -> this.request0(n));
        }
    }

    private void request0(long n) {
        if (this.obj2 == null) {
            return;
        }
        if (n <= 0L) {
            this.onError(new IllegalArgumentException("n: " + n + " (expected: > 0, see Reactive Streams specification rule 3.9)"));
            return;
        }
        if (this.inOnNext) {
            this.requested = true;
            return;
        }
        if (n >= 2L) {
            T item;
            this.inOnNext = true;
            if (this.obj1 != null) {
                item = this.obj1;
                this.obj1 = null;
                this.onNext(item);
            }
            if (this.obj2 != null) {
                item = this.obj2;
                this.obj2 = null;
                this.onNext(item);
                this.onComplete();
            }
        } else {
            T item;
            if (this.obj1 != null) {
                item = this.obj1;
                this.obj1 = null;
                this.inOnNext = true;
                this.onNext(item);
                this.inOnNext = false;
                --n;
            }
            if ((n > 0L || this.requested) && this.obj2 != null) {
                item = this.obj2;
                this.obj2 = null;
                this.onNext(item);
                this.onComplete();
            }
        }
    }

    @Override
    public void cancel() {
        if (this.obj2 == null) {
            return;
        }
        super.cancel();
    }

    @Override
    public void abort() {
        if (this.obj2 == null) {
            return;
        }
        super.abort();
    }

    @Override
    public void abort(Throwable cause) {
        if (this.obj2 == null) {
            return;
        }
        super.abort(cause);
    }
}

