/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.Http1HeaderNaming;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.RequestTarget;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Version;
import com.linecorp.armeria.internal.common.ArmeriaHttp2Headers;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import com.linecorp.armeria.internal.shaded.caffeine.cache.LoadingCache;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.Joiner;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.ServerConfig;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.UnsupportedValueConverter;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.StringUtil;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;

public final class ArmeriaHttpUtil {
    private static final HashingStrategy<AsciiString> HTTP2_HEADER_NAME_HASHER = new HashingStrategy<AsciiString>(){

        public int hashCode(AsciiString o) {
            return o.hashCode();
        }

        public boolean equals(AsciiString a, AsciiString b) {
            return a.contentEqualsIgnoreCase((CharSequence)b);
        }
    };
    public static final Charset HTTP_DEFAULT_CONTENT_CHARSET = StandardCharsets.UTF_8;
    public static final AsciiString HEADER_NAME_PROXY_CONNECTION = AsciiString.cached((String)"proxy-connection");
    private static final CaseInsensitiveMap HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST = new CaseInsensitiveMap();
    private static final CaseInsensitiveMap HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST = new CaseInsensitiveMap();
    private static final CaseInsensitiveMap HTTP_TRAILER_DISALLOWED_LIST = new CaseInsensitiveMap();
    static final Set<AsciiString> ADDITIONAL_REQUEST_HEADER_DISALLOWED_LIST;
    private static final Set<AsciiString> REQUEST_PSEUDO_HEADERS;
    private static final Set<AsciiString> PSEUDO_HEADERS;
    public static final String SERVER_HEADER;
    private static final CaseInsensitiveMap REQUEST_HEADER_TRANSLATIONS;
    private static final Splitter COOKIE_SPLITTER;
    private static final String COOKIE_SEPARATOR = "; ";
    private static final Joiner COOKIE_JOINER;
    @Nullable
    private static final LoadingCache<AsciiString, String> HEADER_VALUE_CACHE;
    private static final Set<AsciiString> CACHED_HEADERS;

    private static LoadingCache<AsciiString, String> buildCache(String spec) {
        return Caffeine.from(spec).build(AsciiString::toString);
    }

    public static String concatPaths(String prefix, @Nullable String path) {
        Objects.requireNonNull(prefix, "prefix");
        Preconditions.checkArgument(!prefix.isEmpty() && prefix.charAt(0) == '/', "prefix: %s (expected: an absolute path starting with '/')", (Object)prefix);
        path = MoreObjects.firstNonNull(path, "");
        if (path.isEmpty()) {
            return prefix;
        }
        if (prefix.length() == 1) {
            if (path.charAt(0) == '/') {
                return path;
            }
            return ArmeriaHttpUtil.simpleConcat("/", path);
        }
        return ArmeriaHttpUtil.slowConcatPaths(prefix, path);
    }

    private static String slowConcatPaths(String prefix, String path) {
        if (prefix.charAt(prefix.length() - 1) == '/') {
            if (path.charAt(0) == '/') {
                try (TemporaryThreadLocals tmp = TemporaryThreadLocals.acquire();){
                    String string = tmp.stringBuilder().append(prefix).append(path, 1, path.length()).toString();
                    return string;
                }
            }
            return ArmeriaHttpUtil.simpleConcat(prefix, path);
        }
        if (path.charAt(0) == '/' || path.charAt(0) == '?') {
            return ArmeriaHttpUtil.simpleConcat(prefix, path);
        }
        try (TemporaryThreadLocals tmp = TemporaryThreadLocals.acquire();){
            String string = tmp.stringBuilder().append(prefix).append('/').append(path).toString();
            return string;
        }
    }

    private static String simpleConcat(String prefix, String path) {
        try (TemporaryThreadLocals tmp = TemporaryThreadLocals.acquire();){
            String string = tmp.stringBuilder().append(prefix).append(path).toString();
            return string;
        }
    }

    public static String decodePath(String path) {
        if (path.indexOf(37) < 0) {
            return path;
        }
        return ArmeriaHttpUtil.slowDecodePath(path, false);
    }

    public static String decodePathParam(String pathParam) {
        if (pathParam.indexOf(37) < 0) {
            return pathParam;
        }
        return ArmeriaHttpUtil.slowDecodePath(pathParam, true);
    }

    private static String slowDecodePath(String path, boolean decodeSlash) {
        int len = path.length();
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            byte[] buf = tempThreadLocals.byteArray(len);
            int dstLen = 0;
            for (int i = 0; i < len; ++i) {
                int ch = path.charAt(i);
                if (ch != 37) {
                    buf[dstLen++] = (byte)((ch & 0xFF80) == 0 ? ch : 255);
                    continue;
                }
                int hexEnd = i + 3;
                if (hexEnd > len) {
                    buf[dstLen++] = -1;
                    break;
                }
                int digit1 = StringUtil.decodeHexNibble((char)path.charAt(++i));
                int digit2 = StringUtil.decodeHexNibble((char)path.charAt(++i));
                if (digit1 < 0 || digit2 < 0) {
                    buf[dstLen++] = -1;
                    continue;
                }
                byte decoded = (byte)(digit1 << 4 | digit2);
                if (decodeSlash || decoded != 47) {
                    buf[dstLen++] = decoded;
                    continue;
                }
                buf[dstLen++] = 37;
                buf[dstLen++] = 50;
                buf[dstLen++] = (byte)path.charAt(i);
            }
            String string = new String(buf, 0, dstLen, StandardCharsets.UTF_8);
            return string;
        }
    }

    public static boolean isAbsoluteUri(@Nullable String maybeUri) {
        if (maybeUri == null) {
            return false;
        }
        int firstColonIdx = maybeUri.indexOf(58);
        if (firstColonIdx <= 0 || firstColonIdx + 3 >= maybeUri.length()) {
            return false;
        }
        int firstSlashIdx = maybeUri.indexOf(47);
        if (firstSlashIdx <= 0 || firstSlashIdx < firstColonIdx) {
            return false;
        }
        return maybeUri.charAt(firstColonIdx + 1) == '/' && maybeUri.charAt(firstColonIdx + 2) == '/';
    }

    public static boolean isInformational(@Nullable String statusText) {
        return statusText != null && !statusText.isEmpty() && statusText.charAt(0) == '1';
    }

    public static boolean isContentAlwaysEmptyWithValidation(HttpStatus status, HttpData content) {
        if (!status.isContentAlwaysEmpty()) {
            return false;
        }
        if (!content.isEmpty()) {
            throw new IllegalArgumentException("A " + status + " response must have empty content: " + content.length() + " byte(s)");
        }
        return true;
    }

    public static boolean isCorsPreflightRequest(RequestHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return headers.method() == HttpMethod.OPTIONS && headers.contains((CharSequence)HttpHeaderNames.ORIGIN) && headers.contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD);
    }

    static Set<AsciiString> disallowedResponseHeaderNames() {
        return REQUEST_PSEUDO_HEADERS;
    }

    public static void parseDirectives(String directives, BiConsumer<String, String> callback) {
        int len = directives.length();
        int i = 0;
        while (i < len) {
            String value;
            char ch;
            int nameStart = i;
            while (i < len && (ch = directives.charAt(i)) != ',' && ch != '=') {
                ++i;
            }
            String name = directives.substring(nameStart, i).trim();
            if (i == len || directives.charAt(i) == ',') {
                ++i;
                value = null;
            } else {
                int valueStart;
                ++i;
                while (i < len && ((ch = directives.charAt(i)) == ' ' || ch == '\t')) {
                    ++i;
                }
                if (i < len && directives.charAt(i) == '\"') {
                    valueStart = ++i;
                    while (i < len && directives.charAt(i) != '\"') {
                        ++i;
                    }
                    value = directives.substring(valueStart, i);
                    ++i;
                    while (i < len) {
                        if (directives.charAt(i) == ',') {
                            ++i;
                            break;
                        }
                        ++i;
                    }
                } else {
                    valueStart = i;
                    while (i < len && directives.charAt(i) != ',') {
                        ++i;
                    }
                    value = directives.substring(valueStart, i).trim();
                    ++i;
                }
            }
            if (name.isEmpty()) continue;
            callback.accept(Ascii.toLowerCase(name), Strings.emptyToNull(value));
        }
    }

    public static long parseDirectiveValueAsSeconds(@Nullable String value) {
        if (value == null) {
            return -1L;
        }
        try {
            long converted = Long.parseLong(value);
            return converted >= 0L ? converted : -1L;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static RequestHeaders toArmeriaRequestHeaders(ChannelHandlerContext ctx, Http2Headers headers, boolean endOfStream, String scheme, ServerConfig cfg, RequestTarget reqTarget) {
        assert (headers instanceof ArmeriaHttp2Headers);
        HttpHeadersBuilder builder = ((ArmeriaHttp2Headers)headers).delegate();
        builder.endOfStream(endOfStream);
        if (!builder.contains((CharSequence)HttpHeaderNames.SCHEME)) {
            builder.add((CharSequence)HttpHeaderNames.SCHEME, scheme);
        }
        if (builder.get((CharSequence)HttpHeaderNames.AUTHORITY) == null && builder.get((CharSequence)HttpHeaderNames.HOST) == null) {
            String defaultHostname = cfg.defaultVirtualHost().defaultHostname();
            int port = ((InetSocketAddress)ctx.channel().localAddress()).getPort();
            builder.add((CharSequence)HttpHeaderNames.AUTHORITY, defaultHostname + ':' + port);
        }
        builder.set((CharSequence)HttpHeaderNames.PATH, reqTarget.toString());
        List<String> cookies = builder.getAll((CharSequence)HttpHeaderNames.COOKIE);
        if (cookies.size() > 1) {
            builder.set((CharSequence)HttpHeaderNames.COOKIE, COOKIE_JOINER.join(cookies));
        }
        return RequestHeaders.of(builder.build());
    }

    public static HttpHeaders toArmeria(Http2Headers http2Headers, boolean request, boolean endOfStream) {
        assert (http2Headers instanceof ArmeriaHttp2Headers);
        HttpHeadersBuilder delegate = ((ArmeriaHttp2Headers)http2Headers).delegate();
        delegate.endOfStream(endOfStream);
        HttpHeaders headers = delegate.build();
        if (request) {
            if (headers.contains((CharSequence)HttpHeaderNames.METHOD)) {
                headers = RequestHeaders.of(headers);
            }
        } else if (headers.contains((CharSequence)HttpHeaderNames.STATUS)) {
            headers = ResponseHeaders.of(headers);
        }
        return headers;
    }

    public static RequestHeaders toArmeria(ChannelHandlerContext ctx, HttpRequest in, ServerConfig cfg, String scheme, RequestTarget reqTarget) throws URISyntaxException {
        io.netty.handler.codec.http.HttpHeaders inHeaders = in.headers();
        RequestHeadersBuilder out = RequestHeaders.builder();
        out.sizeHint(inHeaders.size());
        out.method(MoreObjects.firstNonNull(HttpMethod.tryParse(in.method().name()), HttpMethod.UNKNOWN)).scheme(scheme).path(reqTarget.toString());
        ArmeriaHttpUtil.toArmeria(inHeaders, out);
        if (!out.contains((CharSequence)HttpHeaderNames.HOST)) {
            String defaultHostname = cfg.defaultVirtualHost().defaultHostname();
            int port = ((InetSocketAddress)ctx.channel().localAddress()).getPort();
            out.add((CharSequence)HttpHeaderNames.HOST, defaultHostname + ':' + port);
        }
        return out.build();
    }

    public static ResponseHeaders toArmeria(HttpResponse in) {
        io.netty.handler.codec.http.HttpHeaders inHeaders = in.headers();
        ResponseHeadersBuilder out = ResponseHeaders.builder();
        out.sizeHint(inHeaders.size());
        out.status(HttpStatus.valueOf(in.status().code()));
        ArmeriaHttpUtil.toArmeria(inHeaders, out);
        return out.build();
    }

    public static HttpHeaders toArmeria(io.netty.handler.codec.http.HttpHeaders inHeaders) {
        if (inHeaders.isEmpty()) {
            return HttpHeaders.of();
        }
        HttpHeadersBuilder out = HttpHeaders.builder();
        out.sizeHint(inHeaders.size());
        ArmeriaHttpUtil.toArmeria(inHeaders, out);
        return out.build();
    }

    public static void toArmeria(io.netty.handler.codec.http.HttpHeaders inHeaders, HttpHeadersBuilder out) {
        Iterator iter2 = inHeaders.iteratorCharSequence();
        CaseInsensitiveMap connectionDisallowedList = ArmeriaHttpUtil.toLowercaseMap(inHeaders.valueCharSequenceIterator((CharSequence)HttpHeaderNames.CONNECTION), 8);
        StringJoiner cookieJoiner = null;
        while (iter2.hasNext()) {
            Map.Entry entry = (Map.Entry)iter2.next();
            AsciiString aName = HttpHeaderNames.of((CharSequence)entry.getKey()).toLowerCase();
            if (HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.contains(aName) || connectionDisallowedList.contains(aName)) continue;
            if (aName.equals((Object)HttpHeaderNames.TE)) {
                ArmeriaHttpUtil.toHttp2HeadersFilterTE(entry, out);
                continue;
            }
            CharSequence value = (CharSequence)entry.getValue();
            if (aName.equals((Object)HttpHeaderNames.COOKIE)) {
                if (cookieJoiner == null) {
                    cookieJoiner = new StringJoiner(COOKIE_SEPARATOR);
                }
                COOKIE_SPLITTER.split(value).forEach(cookieJoiner::add);
                continue;
            }
            out.add((CharSequence)aName, ArmeriaHttpUtil.convertHeaderValue(aName, value));
        }
        if (cookieJoiner != null && cookieJoiner.length() != 0) {
            out.add((CharSequence)HttpHeaderNames.COOKIE, cookieJoiner.toString());
        }
    }

    private static CaseInsensitiveMap toLowercaseMap(Iterator<? extends CharSequence> valuesIter, int arraySizeHint) {
        CaseInsensitiveMap result = new CaseInsensitiveMap(arraySizeHint);
        while (valuesIter.hasNext()) {
            AsciiString lowerCased = AsciiString.of((CharSequence)valuesIter.next()).toLowerCase();
            try {
                int index = lowerCased.forEachByte(ByteProcessor.FIND_COMMA);
                if (index != -1) {
                    int start = 0;
                    do {
                        result.add(lowerCased.subSequence(start, index, false).trim(), AsciiString.EMPTY_STRING);
                    } while ((start = index + 1) < lowerCased.length() && (index = lowerCased.forEachByte(start, lowerCased.length() - start, ByteProcessor.FIND_COMMA)) != -1);
                    result.add(lowerCased.subSequence(start, lowerCased.length(), false).trim(), AsciiString.EMPTY_STRING);
                    continue;
                }
                result.add(lowerCased.trim(), AsciiString.EMPTY_STRING);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    private static void toHttp2HeadersFilterTE(Map.Entry<CharSequence, CharSequence> entry, HttpHeadersBuilder out) {
        block2: {
            block1: {
                if (AsciiString.indexOf((CharSequence)entry.getValue(), (char)',', (int)0) != -1) break block1;
                if (!AsciiString.contentEqualsIgnoreCase((CharSequence)AsciiString.trim((CharSequence)entry.getValue()), (CharSequence)HttpHeaderValues.TRAILERS)) break block2;
                out.add((CharSequence)HttpHeaderNames.TE, HttpHeaderValues.TRAILERS.toString());
                break block2;
            }
            List teValues = StringUtil.unescapeCsvFields((CharSequence)entry.getValue());
            for (CharSequence teValue : teValues) {
                if (!AsciiString.contentEqualsIgnoreCase((CharSequence)AsciiString.trim((CharSequence)teValue), (CharSequence)HttpHeaderValues.TRAILERS)) continue;
                out.add((CharSequence)HttpHeaderNames.TE, HttpHeaderValues.TRAILERS.toString());
                break;
            }
        }
    }

    public static Http2Headers toNettyHttp2ServerHeaders(HttpHeadersBuilder inputHeaders) {
        Iterator<AsciiString> iterator = HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            inputHeaders.remove((CharSequence)entry.getKey());
        }
        for (AsciiString asciiString : ArmeriaHttpUtil.disallowedResponseHeaderNames()) {
            inputHeaders.remove((CharSequence)asciiString);
        }
        return new ArmeriaHttp2Headers(inputHeaders);
    }

    public static Http2Headers toNettyHttp2ServerTrailers(HttpHeaders inputHeaders) {
        HttpHeadersBuilder builder = inputHeaders.toBuilder();
        Iterator iterator = HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            builder.remove((CharSequence)entry.getKey());
        }
        for (AsciiString asciiString : PSEUDO_HEADERS) {
            builder.remove((CharSequence)asciiString);
        }
        iterator = HTTP_TRAILER_DISALLOWED_LIST.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            builder.remove((CharSequence)entry.getKey());
        }
        return new ArmeriaHttp2Headers(builder);
    }

    public static Http2Headers toNettyHttp2ClientHeaders(HttpHeaders inputHeaders) {
        int headerSizeHint = inputHeaders.size() + 3;
        DefaultHttp2Headers outputHeaders = new DefaultHttp2Headers(false, headerSizeHint);
        ArmeriaHttpUtil.toNettyHttp2Client(inputHeaders, (Http2Headers)outputHeaders, false);
        return outputHeaders;
    }

    public static Http2Headers toNettyHttp2ClientTrailers(HttpHeaders inputHeaders) {
        int headerSizeHint = inputHeaders.size();
        DefaultHttp2Headers outputHeaders = new DefaultHttp2Headers(false, headerSizeHint);
        ArmeriaHttpUtil.toNettyHttp2Client(inputHeaders, (Http2Headers)outputHeaders, true);
        return outputHeaders;
    }

    private static void toNettyHttp2Client(HttpHeaders inputHeaders, Http2Headers outputHeaders, boolean isTrailer) {
        for (Map.Entry<AsciiString, String> entry : inputHeaders) {
            AsciiString name = entry.getKey();
            String value = entry.getValue();
            if (HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.contains(name) || isTrailer && ArmeriaHttpUtil.isTrailerDisallowed(name)) continue;
            outputHeaders.add((Object)name, (Object)value);
        }
        if (!outputHeaders.contains((Object)HttpHeaderNames.COOKIE)) {
            return;
        }
        List cookies = outputHeaders.getAllAndRemove((Object)HttpHeaderNames.COOKIE);
        for (CharSequence c : cookies) {
            outputHeaders.add((Object)HttpHeaderNames.COOKIE, COOKIE_SPLITTER.split(c));
        }
    }

    public static void toNettyHttp1ServerHeaders(HttpHeaders inputHeaders, io.netty.handler.codec.http.HttpHeaders outputHeaders, Http1HeaderNaming http1HeaderNaming, boolean keepAlive) {
        ArmeriaHttpUtil.toNettyHttp1Server(inputHeaders, outputHeaders, http1HeaderNaming, false);
        HttpUtil.setKeepAlive((io.netty.handler.codec.http.HttpHeaders)outputHeaders, (HttpVersion)HttpVersion.HTTP_1_1, (boolean)keepAlive);
    }

    public static void toNettyHttp1ServerTrailers(HttpHeaders inputHeaders, io.netty.handler.codec.http.HttpHeaders outputHeaders, Http1HeaderNaming http1HeaderNaming) {
        ArmeriaHttpUtil.toNettyHttp1Server(inputHeaders, outputHeaders, http1HeaderNaming, true);
    }

    private static void toNettyHttp1Server(HttpHeaders inputHeaders, io.netty.handler.codec.http.HttpHeaders outputHeaders, Http1HeaderNaming http1HeaderNaming, boolean isTrailer) {
        for (Map.Entry<AsciiString, String> entry : inputHeaders) {
            AsciiString name = entry.getKey();
            String value = entry.getValue();
            if (HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.contains(name) || isTrailer && ArmeriaHttpUtil.isTrailerDisallowed(name)) continue;
            outputHeaders.add(http1HeaderNaming.convert(name), (Object)value);
        }
    }

    public static void toNettyHttp1ClientHeaders(HttpHeaders inputHeaders, io.netty.handler.codec.http.HttpHeaders outputHeaders, Http1HeaderNaming http1HeaderNaming) {
        ArmeriaHttpUtil.toNettyHttp1Client(inputHeaders, outputHeaders, http1HeaderNaming, false);
    }

    public static void toNettyHttp1ClientTrailers(HttpHeaders inputHeaders, io.netty.handler.codec.http.HttpHeaders outputHeaders, Http1HeaderNaming http1HeaderNaming) {
        ArmeriaHttpUtil.toNettyHttp1Client(inputHeaders, outputHeaders, http1HeaderNaming, true);
    }

    private static void toNettyHttp1Client(HttpHeaders inputHeaders, io.netty.handler.codec.http.HttpHeaders outputHeaders, Http1HeaderNaming http1HeaderNaming, boolean isTrailer) {
        StringJoiner cookieJoiner = null;
        for (Map.Entry<AsciiString, String> entry : inputHeaders) {
            AsciiString name = entry.getKey();
            String value = entry.getValue();
            AsciiString translatedName = (AsciiString)REQUEST_HEADER_TRANSLATIONS.get(name);
            if (translatedName != null && !inputHeaders.contains((CharSequence)translatedName)) {
                outputHeaders.add((CharSequence)translatedName, (Object)value);
                continue;
            }
            if (HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.contains(name) || isTrailer && ArmeriaHttpUtil.isTrailerDisallowed(name)) continue;
            if (HttpHeaderNames.COOKIE.equals((Object)name)) {
                if (cookieJoiner == null) {
                    cookieJoiner = new StringJoiner(COOKIE_SEPARATOR);
                }
                COOKIE_SPLITTER.split(value).forEach(cookieJoiner::add);
                continue;
            }
            outputHeaders.add(http1HeaderNaming.convert(name), (Object)value);
        }
        if (cookieJoiner != null && cookieJoiner.length() != 0) {
            outputHeaders.add((CharSequence)HttpHeaderNames.COOKIE, (Object)cookieJoiner.toString());
        }
    }

    public static ResponseHeaders setOrRemoveContentLength(ResponseHeaders headers, HttpData content, HttpHeaders trailers) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailers, "trailers");
        HttpStatus status = headers.status();
        if (ArmeriaHttpUtil.isContentAlwaysEmptyWithValidation(status, content)) {
            if (status != HttpStatus.NOT_MODIFIED && headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                ResponseHeadersBuilder builder = headers.toBuilder();
                builder.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                return builder.build();
            }
            return headers;
        }
        if (!trailers.isEmpty()) {
            if (headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                ResponseHeadersBuilder builder = headers.toBuilder();
                builder.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                return builder.build();
            }
            return headers;
        }
        if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) || !content.isEmpty()) {
            return headers.toBuilder().contentLength(content.length()).removeAndThen((CharSequence)HttpHeaderNames.TRANSFER_ENCODING).build();
        }
        return headers;
    }

    public static String convertHeaderValue(AsciiString name, CharSequence value) {
        if (!(value instanceof AsciiString)) {
            return value.toString();
        }
        if (HEADER_VALUE_CACHE != null && CACHED_HEADERS.contains(name)) {
            String converted = HEADER_VALUE_CACHE.get((AsciiString)value);
            assert (converted != null);
            return converted;
        }
        return value.toString();
    }

    public static boolean isTrailerDisallowed(AsciiString name) {
        return HTTP_TRAILER_DISALLOWED_LIST.contains(name);
    }

    public static String authorityHeader(String host, int port, int defaultPort) {
        if (port == defaultPort) {
            return host;
        }
        StringBuilder buf = new StringBuilder(host.length() + 6);
        buf.append(host);
        buf.append(':');
        buf.append(port);
        return buf.toString();
    }

    public static boolean isRequestTimeoutResponse(HttpResponse httpResponse) {
        return httpResponse.status().code() == HttpResponseStatus.REQUEST_TIMEOUT.code() && "close".equalsIgnoreCase(httpResponse.headers().get((CharSequence)HttpHeaderNames.CONNECTION));
    }

    public static <T> void toHttp1Headers(HttpHeaders armeriaHeaders, T output, TriConsumer<T, AsciiString, String> writer) {
        for (Map.Entry<AsciiString, String> e : armeriaHeaders) {
            AsciiString k = e.getKey();
            String v = e.getValue();
            if (k.charAt(0) != ':') {
                writer.accept(output, k, v);
                continue;
            }
            if (!HttpHeaderNames.AUTHORITY.equals((Object)k) || armeriaHeaders.contains((CharSequence)HttpHeaderNames.HOST)) continue;
            writer.accept(output, HttpHeaderNames.HOST, v);
        }
    }

    private ArmeriaHttpUtil() {
    }

    static {
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.CONNECTION, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.KEEP_ALIVE, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HEADER_NAME_PROXY_CONNECTION, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.TRANSFER_ENCODING, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.UPGRADE, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpConversionUtil.ExtensionHeaderNames.PATH.text(), AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.AUTHORITY, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.METHOD, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.PATH, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.SCHEME, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.STATUS, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.TRANSFER_ENCODING, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpConversionUtil.ExtensionHeaderNames.PATH.text(), AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.TRANSFER_ENCODING, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.CONTENT_LENGTH, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.CACHE_CONTROL, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.EXPECT, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.HOST, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.MAX_FORWARDS, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.PRAGMA, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.RANGE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.TE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.WWW_AUTHENTICATE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.AUTHORIZATION, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.PROXY_AUTHENTICATE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.PROXY_AUTHORIZATION, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.DATE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.LOCATION, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.RETRY_AFTER, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.VARY, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.WARNING, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.CONTENT_ENCODING, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.CONTENT_TYPE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.CONTENT_RANGE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.TRAILER, AsciiString.EMPTY_STRING);
        ADDITIONAL_REQUEST_HEADER_DISALLOWED_LIST = ImmutableSet.of(HttpHeaderNames.SCHEME, HttpHeaderNames.STATUS, HttpHeaderNames.METHOD);
        REQUEST_PSEUDO_HEADERS = ImmutableSet.of(HttpHeaderNames.METHOD, HttpHeaderNames.SCHEME, HttpHeaderNames.AUTHORITY, HttpHeaderNames.PATH, HttpHeaderNames.PROTOCOL);
        PSEUDO_HEADERS = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(REQUEST_PSEUDO_HEADERS)).add(HttpHeaderNames.STATUS)).build();
        SERVER_HEADER = "Armeria/" + Version.get("armeria", ArmeriaHttpUtil.class.getClassLoader()).artifactVersion();
        REQUEST_HEADER_TRANSLATIONS = new CaseInsensitiveMap();
        REQUEST_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.AUTHORITY.value(), HttpHeaderNames.HOST);
        COOKIE_SPLITTER = Splitter.on(';').trimResults().omitEmptyStrings();
        COOKIE_JOINER = Joiner.on(COOKIE_SEPARATOR);
        HEADER_VALUE_CACHE = Flags.headerValueCacheSpec() != null ? ArmeriaHttpUtil.buildCache(Flags.headerValueCacheSpec()) : null;
        CACHED_HEADERS = Flags.cachedHeaders().stream().map(AsciiString::of).collect(ImmutableSet.toImmutableSet());
    }

    private static final class CaseInsensitiveMap
    extends DefaultHeaders<AsciiString, AsciiString, CaseInsensitiveMap> {
        CaseInsensitiveMap() {
            super(HTTP2_HEADER_NAME_HASHER, (ValueConverter)UnsupportedValueConverter.instance());
        }

        CaseInsensitiveMap(int size) {
            super(HTTP2_HEADER_NAME_HASHER, (ValueConverter)UnsupportedValueConverter.instance(), DefaultHeaders.NameValidator.NOT_NULL, size);
        }
    }

    @FunctionalInterface
    public static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

