/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.AggregationSupport;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.NoopSubscriber;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.CompositeException;
import com.linecorp.armeria.common.util.EventLoopCheckingFuture;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.stream.AbortingSubscriber;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.SubscriberUtil;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherBasedStreamMessage<T>
extends AggregationSupport
implements StreamMessage<T> {
    private static final Logger logger = LoggerFactory.getLogger(PublisherBasedStreamMessage.class);
    private static final AtomicReferenceFieldUpdater<PublisherBasedStreamMessage, AbortableSubscriber> subscriberUpdater = AtomicReferenceFieldUpdater.newUpdater(PublisherBasedStreamMessage.class, AbortableSubscriber.class, "subscriber");
    private final Publisher<? extends T> publisher;
    private final CompletableFuture<Void> completionFuture = new EventLoopCheckingFuture<Void>();
    @Nullable
    private volatile AbortableSubscriber subscriber;
    private volatile boolean publishedAny;
    private volatile long demand;

    public PublisherBasedStreamMessage(Publisher<? extends T> publisher) {
        this.publisher = Objects.requireNonNull(publisher, "publisher");
    }

    protected final Publisher<? extends T> delegate() {
        return this.publisher;
    }

    @Override
    public final boolean isOpen() {
        return !this.completionFuture.isDone();
    }

    @Override
    public final boolean isEmpty() {
        return !this.isOpen() && !this.publishedAny;
    }

    @Override
    public final long demand() {
        return this.demand;
    }

    @Override
    public final void subscribe(Subscriber<? super T> subscriber, EventExecutor executor) {
        this.subscribe0(subscriber, executor, false, false);
    }

    @Override
    public final void subscribe(Subscriber<? super T> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(options, "options");
        boolean withPooledObjects = InternalStreamMessageUtil.containsWithPooledObjects(options);
        boolean notifyCancellation = InternalStreamMessageUtil.containsNotifyCancellation(options);
        this.subscribe0(subscriber, executor, withPooledObjects, notifyCancellation);
    }

    private void subscribe0(Subscriber<? super T> subscriber, EventExecutor executor, boolean withPooledObjects, boolean notifyCancellation) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        if (!this.subscribe1(subscriber, executor, withPooledObjects, notifyCancellation)) {
            AbortableSubscriber oldSubscriber = this.subscriber;
            assert (oldSubscriber != null);
            SubscriberUtil.failLateSubscriber(executor, subscriber, oldSubscriber.subscriber);
        }
    }

    private boolean subscribe1(Subscriber<? super T> subscriber, EventExecutor executor, boolean withPooledObjects, boolean notifyCancellation) {
        AbortableSubscriber s = new AbortableSubscriber(this, subscriber, executor, withPooledObjects, notifyCancellation);
        if (!subscriberUpdater.compareAndSet(this, null, s)) {
            return false;
        }
        if (this.publisher instanceof StreamMessage) {
            ((StreamMessage)this.publisher).subscribe(s, executor);
        } else {
            this.publisher.subscribe((Subscriber)s);
        }
        return true;
    }

    @Override
    public final void abort() {
        this.abort0(AbortedStreamException.get());
    }

    @Override
    public final void abort(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.abort0(cause);
    }

    private void abort0(Throwable cause) {
        AbortableSubscriber subscriber = this.subscriber;
        if (subscriber != null) {
            subscriber.abort(cause);
            return;
        }
        AbortableSubscriber abortable = new AbortableSubscriber(this, AbortingSubscriber.get(cause), (EventExecutor)ImmediateEventExecutor.INSTANCE, false, false);
        if (!subscriberUpdater.compareAndSet(this, null, abortable)) {
            this.subscriber.abort(cause);
            return;
        }
        abortable.abort(cause);
        this.publisher.subscribe((Subscriber)abortable);
    }

    @Override
    public CompletableFuture<List<T>> collect(EventExecutor executor, SubscriptionOption ... options) {
        if (this.publisher instanceof StreamMessage) {
            return ((StreamMessage)this.publisher).collect(executor, options);
        }
        return StreamMessage.super.collect(executor, options);
    }

    @Override
    public final CompletableFuture<Void> whenComplete() {
        return this.completionFuture;
    }

    static final class AbortableSubscriber
    implements Subscriber<Object>,
    Subscription {
        private final PublisherBasedStreamMessage<?> parent;
        private final EventExecutor executor;
        private final boolean withPooledObjects;
        private final boolean notifyCancellation;
        private Subscriber<Object> subscriber;
        @Nullable
        private volatile Subscription subscription;
        @Nullable
        private volatile Throwable abortCause;

        AbortableSubscriber(PublisherBasedStreamMessage<?> parent, Subscriber<?> subscriber, EventExecutor executor, boolean withPooledObjects, boolean notifyCancellation) {
            this.parent = parent;
            this.subscriber = subscriber;
            this.executor = executor;
            this.withPooledObjects = withPooledObjects;
            this.notifyCancellation = notifyCancellation;
        }

        public void request(long n) {
            Subscription subscription = this.subscription;
            assert (subscription != null);
            if (this.executor.inEventLoop()) {
                this.increaseDemand(n);
                subscription.request(n);
            } else {
                this.executor.execute(() -> {
                    this.increaseDemand(n);
                    subscription.request(n);
                });
            }
        }

        private void increaseDemand(long n) {
            ((PublisherBasedStreamMessage)this.parent).demand = LongMath.saturatedAdd(((PublisherBasedStreamMessage)this.parent).demand, n);
        }

        public void cancel() {
            assert (this.subscription != null);
            this.cancelOrAbort(this.abortCause == null);
        }

        void abort(Throwable cause) {
            if (this.abortCause == null) {
                this.abortCause = cause;
            }
            if (this.subscription != null) {
                this.cancelOrAbort(false);
            }
        }

        private void cancelOrAbort(boolean cancel) {
            if (this.executor.inEventLoop()) {
                this.cancelOrAbort0(cancel);
            } else {
                this.executor.execute(() -> this.cancelOrAbort0(cancel));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelOrAbort0(boolean cancel) {
            Throwable cause;
            CompletableFuture<Void> completionFuture = this.parent.whenComplete();
            if (completionFuture.isDone()) {
                return;
            }
            Subscriber<Object> subscriber = this.subscriber;
            if (!(subscriber instanceof AbortingSubscriber)) {
                this.subscriber = NoopSubscriber.get();
            }
            Throwable throwable = cause = cancel ? CancelledSubscriptionException.get() : this.abortCause;
            assert (cause != null);
            try {
                if (!cancel || this.notifyCancellation) {
                    subscriber.onError(cause);
                }
                completionFuture.completeExceptionally(cause);
            }
            catch (Throwable t) {
                CompositeException composite = new CompositeException(t, cause);
                completionFuture.completeExceptionally(composite);
                Exceptions.throwIfFatal(t);
                logger.warn("Subscriber.onError() should not raise an exception. subscriber: {}", subscriber, (Object)composite);
            }
            finally {
                this.subscription.cancel();
            }
        }

        public void onSubscribe(Subscription subscription) {
            Objects.requireNonNull(subscription, "subscription");
            if (this.executor.inEventLoop()) {
                this.onSubscribe0(subscription);
            } else {
                this.executor.execute(() -> this.onSubscribe0(subscription));
            }
        }

        private void onSubscribe0(Subscription subscription) {
            try {
                this.subscription = subscription;
                this.subscriber.onSubscribe((Subscription)this);
                if (this.abortCause != null) {
                    this.cancelOrAbort0(false);
                }
            }
            catch (Throwable t) {
                this.abort(t);
                Exceptions.throwIfFatal(t);
                logger.warn("Subscriber.onSubscribe() should not raise an exception. subscriber: {}", this.subscriber, (Object)t);
            }
        }

        public void onNext(Object obj) {
            Objects.requireNonNull(obj, "obj");
            ((PublisherBasedStreamMessage)this.parent).publishedAny = true;
            if (this.executor.inEventLoop()) {
                this.onNext0(obj);
            } else {
                this.executor.execute(() -> this.onNext0(obj));
            }
        }

        private void onNext0(Object obj) {
            if (((PublisherBasedStreamMessage)this.parent).demand != Long.MAX_VALUE) {
                ((PublisherBasedStreamMessage)this.parent).demand--;
            }
            try {
                if (!this.withPooledObjects) {
                    obj = PooledObjects.copyAndClose(obj);
                }
                this.subscriber.onNext(obj);
            }
            catch (Throwable t) {
                this.abort(t);
                Exceptions.throwIfFatal(t);
                logger.warn("Subscriber.onNext({}) should not raise an exception. subscriber: {}", new Object[]{obj, this.subscriber, t});
            }
        }

        public void onError(Throwable cause) {
            Objects.requireNonNull(cause, "cause");
            if (this.executor.inEventLoop()) {
                this.onError0(cause);
            } else {
                this.executor.execute(() -> this.onError0(cause));
            }
        }

        private void onError0(Throwable cause) {
            try {
                this.subscriber.onError(cause);
                this.parent.whenComplete().completeExceptionally(cause);
            }
            catch (Throwable t) {
                CompositeException composite = new CompositeException(t, cause);
                this.parent.whenComplete().completeExceptionally(composite);
                Exceptions.throwIfFatal(t);
                logger.warn("Subscriber.onError() should not raise an exception. subscriber: {}", this.subscriber, (Object)composite);
            }
        }

        public void onComplete() {
            if (this.executor.inEventLoop()) {
                this.onComplete0();
            } else {
                this.executor.execute(this::onComplete0);
            }
        }

        private void onComplete0() {
            try {
                this.subscriber.onComplete();
                this.parent.whenComplete().complete(null);
            }
            catch (Throwable t) {
                this.parent.whenComplete().completeExceptionally(t);
                Exceptions.throwIfFatal(t);
                logger.warn("Subscriber.onComplete() should not raise an exception. subscriber: {}", this.subscriber, (Object)t);
            }
        }
    }
}

