/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.HttpMessage;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.HttpMessageAggregator;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class AggregationSupport {
    private static final AtomicReferenceFieldUpdater<AggregationSupport, CompletableFuture> aggregationUpdater = AtomicReferenceFieldUpdater.newUpdater(AggregationSupport.class, CompletableFuture.class, "aggregation");
    private static final CompletableFuture<Object> NO_CACHE = new CompletableFuture();
    @Nullable
    private volatile CompletableFuture<Object> aggregation;

    protected AggregationSupport() {
    }

    protected <U extends AggregatedHttpMessage> CompletableFuture<U> aggregate(AggregationOptions options) {
        Objects.requireNonNull(options, "options");
        if (!(this instanceof HttpMessage)) {
            throw new UnsupportedOperationException("aggregate() is only supported for " + HttpMessage.class);
        }
        HttpMessage httpMessage = (HttpMessage)((Object)this);
        RequestHeaders headers = httpMessage instanceof HttpRequest ? ((HttpRequest)httpMessage).headers() : null;
        ByteBufAllocator alloc = options.alloc();
        SubscriptionOption[] subscriptionOptions = alloc != null ? InternalStreamMessageUtil.POOLED_OBJECTS : InternalStreamMessageUtil.EMPTY_OPTIONS;
        CompletableFuture<Object> aggregation = this.aggregation;
        if (aggregation != null) {
            return AggregationSupport.handleAggregation(options, aggregation);
        }
        if (!options.cacheResult()) {
            if (!aggregationUpdater.compareAndSet(this, null, NO_CACHE)) {
                CompletableFuture<Object> aggregation0 = this.aggregation;
                assert (aggregation0 != null);
                return AggregationSupport.handleAggregation(options, aggregation0);
            }
            EventExecutor executor = options.executor();
            if (executor == null) {
                executor = httpMessage.defaultSubscriberExecutor();
            }
            return httpMessage.collect(executor, subscriptionOptions).thenApply(objects -> AggregationSupport.aggregate(objects, headers, alloc));
        }
        CompletableFuture aggregationFuture = new CompletableFuture();
        if (!aggregationUpdater.compareAndSet(this, null, aggregationFuture)) {
            CompletableFuture<Object> aggregation0 = this.aggregation;
            assert (aggregation0 != null);
            return AggregationSupport.handleAggregation(options, aggregation0);
        }
        EventExecutor executor = options.executor();
        if (executor == null) {
            executor = httpMessage.defaultSubscriberExecutor();
        }
        ((CompletableFuture)httpMessage.collect(executor, subscriptionOptions).thenApply(objects -> AggregationSupport.aggregate(objects, headers, alloc))).handle((res, cause) -> {
            if (cause != null) {
                cause = Exceptions.peel(cause);
                aggregationFuture.completeExceptionally((Throwable)cause);
            } else {
                aggregationFuture.complete((AggregatedHttpMessage)res);
            }
            return null;
        });
        return aggregationFuture;
    }

    private static <U extends AggregatedHttpMessage> U aggregate(List<HttpObject> objects, @Nullable RequestHeaders headers, @Nullable ByteBufAllocator allocator) {
        if (headers != null) {
            return (U)HttpMessageAggregator.aggregateRequest(headers, objects, allocator);
        }
        return (U)HttpMessageAggregator.aggregateResponse(objects, allocator);
    }

    private static <U extends AggregatedHttpMessage> CompletableFuture<U> handleAggregation(AggregationOptions options, CompletableFuture<?> aggregation) {
        if (!options.preferCached()) {
            throw new IllegalStateException("the stream was aggregated previously. options: " + options);
        }
        if (aggregation == NO_CACHE) {
            throw new IllegalStateException("the stream was aggregated previously without cache. options: " + options);
        }
        return aggregation;
    }
}

