/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ExceptionSampler;
import com.linecorp.armeria.common.FlagsProvider;
import com.linecorp.armeria.common.FlagsUtil;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestContextStorageProvider;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.InetAddressPredicates;
import com.linecorp.armeria.common.util.Sampler;
import com.linecorp.armeria.common.util.TransportType;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.server.TransientServiceOption;
import java.net.InetAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SystemPropertyFlagsProvider
implements FlagsProvider {
    static final SystemPropertyFlagsProvider INSTANCE = new SystemPropertyFlagsProvider();
    private static final Logger logger = LoggerFactory.getLogger(SystemPropertyFlagsProvider.class);
    private static final String PREFIX = "com.linecorp.armeria.";
    private static final Splitter CSV_SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();

    private SystemPropertyFlagsProvider() {
    }

    @Override
    public int priority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String name() {
        return "sysprops";
    }

    @Override
    public Sampler<Class<? extends Throwable>> verboseExceptionSampler() {
        String spec = SystemPropertyFlagsProvider.getNormalized("verboseExceptions");
        if (spec == null) {
            return null;
        }
        try {
            Sampler.of(spec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid sampler spec: " + spec, e);
        }
        return new ExceptionSampler(spec);
    }

    @Override
    public Boolean verboseSocketExceptions() {
        return SystemPropertyFlagsProvider.getBoolean("verboseSocketExceptions");
    }

    @Override
    public Boolean verboseResponses() {
        return SystemPropertyFlagsProvider.getBoolean("verboseResponses");
    }

    @Override
    public RequestContextStorageProvider requestContextStorageProvider() {
        String providerFqcn = System.getProperty("com.linecorp.armeria.requestContextStorageProvider");
        if (providerFqcn == null) {
            return null;
        }
        List<RequestContextStorageProvider> providers = FlagsUtil.getRequestContextStorageProviders();
        if (providers.isEmpty()) {
            throw new IllegalArgumentException(providerFqcn + " is specified, but no " + RequestContextStorageProvider.class.getSimpleName() + " is found");
        }
        List matchedCandidates = providers.stream().filter(provider -> provider.getClass().getName().equals(providerFqcn)).collect(ImmutableList.toImmutableList());
        if (matchedCandidates.isEmpty()) {
            throw new IllegalArgumentException(providerFqcn + " does not match any " + RequestContextStorageProvider.class.getSimpleName() + ". providers: " + providers);
        }
        if (matchedCandidates.size() > 1) {
            throw new IllegalArgumentException(providerFqcn + " matches more than one " + RequestContextStorageProvider.class.getSimpleName() + ". providers: " + providers);
        }
        return (RequestContextStorageProvider)matchedCandidates.get(0);
    }

    @Override
    public Boolean warnNettyVersions() {
        return SystemPropertyFlagsProvider.getBoolean("warnNettyVersions");
    }

    @Override
    public TransportType transportType() {
        String strTransportType = SystemPropertyFlagsProvider.getNormalized("transportType");
        if (strTransportType == null) {
            return null;
        }
        switch (strTransportType) {
            case "nio": {
                return TransportType.NIO;
            }
            case "epoll": {
                return TransportType.EPOLL;
            }
            case "io_uring": {
                return TransportType.IO_URING;
            }
        }
        throw new IllegalArgumentException(String.format("%s isn't TransportType", strTransportType));
    }

    @Override
    public Boolean useOpenSsl() {
        return SystemPropertyFlagsProvider.getBoolean("useOpenSsl");
    }

    @Override
    public Boolean dumpOpenSslInfo() {
        return SystemPropertyFlagsProvider.getBoolean("dumpOpenSslInfo");
    }

    @Override
    public Integer maxNumConnections() {
        return SystemPropertyFlagsProvider.getInt("maxNumConnections");
    }

    @Override
    public Integer numCommonWorkers() {
        return SystemPropertyFlagsProvider.getInt("numCommonWorkers");
    }

    @Override
    public Integer numCommonBlockingTaskThreads() {
        return SystemPropertyFlagsProvider.getInt("numCommonBlockingTaskThreads");
    }

    @Override
    public Long defaultMaxRequestLength() {
        return SystemPropertyFlagsProvider.getLong("defaultMaxRequestLength");
    }

    @Override
    public Long defaultMaxResponseLength() {
        return SystemPropertyFlagsProvider.getLong("defaultMaxResponseLength");
    }

    @Override
    public Long defaultRequestTimeoutMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultRequestTimeoutMillis");
    }

    @Override
    public Long defaultResponseTimeoutMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultResponseTimeoutMillis");
    }

    @Override
    public Long defaultConnectTimeoutMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultConnectTimeoutMillis");
    }

    @Override
    public Long defaultWriteTimeoutMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultWriteTimeoutMillis");
    }

    @Override
    public Long defaultServerIdleTimeoutMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultServerIdleTimeoutMillis");
    }

    @Override
    public Long defaultClientIdleTimeoutMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultClientIdleTimeoutMillis");
    }

    @Override
    public Integer defaultHttp1MaxInitialLineLength() {
        return SystemPropertyFlagsProvider.getInt("defaultHttp1MaxInitialLineLength");
    }

    @Override
    public Integer defaultHttp1MaxHeaderSize() {
        return SystemPropertyFlagsProvider.getInt("defaultHttp1MaxHeaderSize");
    }

    @Override
    public Integer defaultHttp1MaxChunkSize() {
        return SystemPropertyFlagsProvider.getInt("defaultHttp1MaxChunkSize");
    }

    @Override
    public Boolean defaultUseHttp2Preface() {
        return SystemPropertyFlagsProvider.getBoolean("defaultUseHttp2Preface");
    }

    @Override
    public Boolean defaultUseHttp1Pipelining() {
        return SystemPropertyFlagsProvider.getBoolean("defaultUseHttp1Pipelining");
    }

    @Override
    public Long defaultPingIntervalMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultPingIntervalMillis");
    }

    @Override
    public Integer defaultMaxServerNumRequestsPerConnection() {
        return SystemPropertyFlagsProvider.getInt("defaultMaxServerNumRequestsPerConnection");
    }

    @Override
    public Integer defaultMaxClientNumRequestsPerConnection() {
        return SystemPropertyFlagsProvider.getInt("defaultMaxClientNumRequestsPerConnection");
    }

    @Override
    public Long defaultMaxServerConnectionAgeMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultMaxServerConnectionAgeMillis");
    }

    @Override
    public Long defaultMaxClientConnectionAgeMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultMaxClientConnectionAgeMillis");
    }

    @Override
    public Long defaultServerConnectionDrainDurationMicros() {
        return SystemPropertyFlagsProvider.getLong("defaultServerConnectionDrainDurationMicros");
    }

    @Override
    public Integer defaultHttp2InitialConnectionWindowSize() {
        return SystemPropertyFlagsProvider.getInt("defaultHttp2InitialConnectionWindowSize");
    }

    @Override
    public Integer defaultHttp2InitialStreamWindowSize() {
        return SystemPropertyFlagsProvider.getInt("defaultHttp2InitialStreamWindowSize");
    }

    @Override
    public Integer defaultHttp2MaxFrameSize() {
        return SystemPropertyFlagsProvider.getInt("defaultHttp2MaxFrameSize");
    }

    @Override
    public Long defaultHttp2MaxStreamsPerConnection() {
        return SystemPropertyFlagsProvider.getLong("defaultHttp2MaxStreamsPerConnection");
    }

    @Override
    public Long defaultHttp2MaxHeaderListSize() {
        return SystemPropertyFlagsProvider.getLong("defaultHttp2MaxHeaderListSize");
    }

    @Override
    public String defaultBackoffSpec() {
        return SystemPropertyFlagsProvider.getNormalized("defaultBackoffSpec");
    }

    @Override
    public Integer defaultMaxTotalAttempts() {
        return SystemPropertyFlagsProvider.getInt("defaultMaxTotalAttempts");
    }

    @Override
    public String routeCacheSpec() {
        return SystemPropertyFlagsProvider.getNormalized("routeCacheSpec");
    }

    @Override
    public String routeDecoratorCacheSpec() {
        return SystemPropertyFlagsProvider.getNormalized("routeDecoratorCacheSpec");
    }

    @Override
    public String parsedPathCacheSpec() {
        return SystemPropertyFlagsProvider.getNormalized("parsedPathCacheSpec");
    }

    @Override
    public String headerValueCacheSpec() {
        return SystemPropertyFlagsProvider.getNormalized("headerValueCacheSpec");
    }

    @Override
    public List<String> cachedHeaders() {
        String val = SystemPropertyFlagsProvider.getNormalized("cachedHeaders");
        if (val == null) {
            return null;
        }
        return CSV_SPLITTER.splitToList(val);
    }

    @Override
    public String fileServiceCacheSpec() {
        return SystemPropertyFlagsProvider.getNormalized("fileServiceCacheSpec");
    }

    @Override
    public String dnsCacheSpec() {
        return SystemPropertyFlagsProvider.getNormalized("dnsCacheSpec");
    }

    @Override
    public Predicate<InetAddress> preferredIpV4Addresses() {
        String val = SystemPropertyFlagsProvider.getNormalized("preferredIpV4Addresses");
        if (val == null) {
            return null;
        }
        List preferredIpV4Addresses = CSV_SPLITTER.splitToList(val).stream().map(cidr -> {
            try {
                return InetAddressPredicates.ofCidr(cidr);
            }
            catch (Exception e) {
                logger.warn("Failed to parse a preferred IPv4: {}", cidr);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        switch (preferredIpV4Addresses.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Predicate)preferredIpV4Addresses.get(0);
            }
        }
        return inetAddress -> {
            for (Predicate preferredIpV4Addr : preferredIpV4Addresses) {
                if (!preferredIpV4Addr.test(inetAddress)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public Boolean useJdkDnsResolver() {
        return SystemPropertyFlagsProvider.getBoolean("useJdkDnsResolver");
    }

    @Override
    public Boolean reportBlockedEventLoop() {
        return SystemPropertyFlagsProvider.getBoolean("reportBlockedEventLoop");
    }

    @Override
    public Boolean reportMaskedRoutes() {
        return SystemPropertyFlagsProvider.getBoolean("reportMaskedRoutes");
    }

    @Override
    public Boolean validateHeaders() {
        return SystemPropertyFlagsProvider.getBoolean("validateHeaders");
    }

    @Override
    public Boolean tlsAllowUnsafeCiphers() {
        return SystemPropertyFlagsProvider.getBoolean("tlsAllowUnsafeCiphers");
    }

    @Override
    public Set<TransientServiceOption> transientServiceOptions() {
        String val = SystemPropertyFlagsProvider.getNormalized("transientServiceOptions");
        if (val == null) {
            return null;
        }
        return Sets.immutableEnumSet(Streams.stream(CSV_SPLITTER.split(val)).map(feature -> TransientServiceOption.valueOf(Ascii.toUpperCase(feature))).collect(ImmutableSet.toImmutableSet()));
    }

    @Override
    public Boolean useDefaultSocketOptions() {
        return SystemPropertyFlagsProvider.getBoolean("useDefaultSocketOptions");
    }

    @Override
    public Boolean useLegacyRouteDecoratorOrdering() {
        return SystemPropertyFlagsProvider.getBoolean("useLegacyRouteDecoratorOrdering");
    }

    @Override
    public Boolean allowDoubleDotsInQueryString() {
        return SystemPropertyFlagsProvider.getBoolean("allowDoubleDotsInQueryString");
    }

    @Override
    public Path defaultMultipartUploadsLocation() {
        return SystemPropertyFlagsProvider.getAndParse("defaultMultipartUploadsLocation", x$0 -> Paths.get(x$0, new String[0]));
    }

    @Override
    public Sampler<? super RequestContext> requestContextLeakDetectionSampler() {
        String spec = SystemPropertyFlagsProvider.getNormalized("requestContextLeakDetectionSampler");
        if (spec == null) {
            return null;
        }
        try {
            return Sampler.of(spec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid sampler spec: " + spec, e);
        }
    }

    @Override
    public Long defaultUnhandledExceptionsReportIntervalMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultUnhandledExceptionsReportIntervalMillis");
    }

    @Nullable
    private static Long getLong(String name) {
        return SystemPropertyFlagsProvider.getAndParse(name, Long::parseLong);
    }

    @Nullable
    private static Integer getInt(String name) {
        return SystemPropertyFlagsProvider.getAndParse(name, Integer::parseInt);
    }

    @Nullable
    private static Boolean getBoolean(String name) {
        return SystemPropertyFlagsProvider.getAndParse(name, SystemPropertyFlagsProvider::strictlyParseBoolean);
    }

    private static Boolean strictlyParseBoolean(String val) {
        if (!val.equals(Boolean.TRUE.toString()) && !val.equals(Boolean.FALSE.toString())) {
            throw new IllegalArgumentException(String.format("%s not in \"true\" or \"false\"", val));
        }
        return Boolean.valueOf(val);
    }

    @Nullable
    private static <T> T getAndParse(String name, Function<String, T> parser) {
        String val = SystemPropertyFlagsProvider.getNormalized(name);
        if (val == null) {
            return null;
        }
        return parser.apply(val);
    }

    @Nullable
    private static String getNormalized(String name) {
        String fullName = PREFIX + name;
        String value = System.getProperty(fullName);
        if (value != null) {
            value = Ascii.toLowerCase(value);
        }
        return value;
    }
}

