/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.RequestTargetForm;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.DefaultRequestTarget;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import java.util.Objects;

public interface RequestTarget {
    @Nullable
    public static RequestTarget forServer(String reqTarget) {
        Objects.requireNonNull(reqTarget, "reqTarget");
        return DefaultRequestTarget.forServer(reqTarget, Flags.allowDoubleDotsInQueryString());
    }

    @Nullable
    public static RequestTarget forClient(String reqTarget) {
        return RequestTarget.forClient(reqTarget, null);
    }

    @Nullable
    public static RequestTarget forClient(String reqTarget, @Nullable String prefix) {
        return DefaultRequestTarget.forClient(reqTarget, prefix);
    }

    public RequestTargetForm form();

    @Nullable
    public String scheme();

    @Nullable
    public String authority();

    public String path();

    @Nullable
    public String query();

    default public String pathAndQuery() {
        if (this.query() == null) {
            return this.path();
        }
        try (TemporaryThreadLocals tmp = TemporaryThreadLocals.acquire();){
            String string = tmp.stringBuilder().append(this.path()).append('?').append(this.query()).toString();
            return string;
        }
    }

    @Nullable
    public String fragment();

    public String toString();
}

