/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.ContentDisposition;
import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaderGetters;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.common.HttpHeadersUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public interface RequestHeadersBuilder
extends HttpHeadersBuilder,
RequestHeaderGetters {
    @Override
    public RequestHeaders build();

    public RequestHeadersBuilder method(HttpMethod var1);

    public RequestHeadersBuilder path(String var1);

    public RequestHeadersBuilder scheme(String var1);

    default public RequestHeadersBuilder scheme(SessionProtocol sessionProtocol) {
        Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        this.scheme(HttpHeadersUtil.getScheme(sessionProtocol));
        return this;
    }

    public RequestHeadersBuilder authority(String var1);

    default public RequestHeadersBuilder authority(Endpoint endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        return this.authority(endpoint.authority());
    }

    public RequestHeadersBuilder acceptLanguages(Iterable<Locale.LanguageRange> var1);

    default public RequestHeadersBuilder acceptLanguages(Locale.LanguageRange ... acceptedLanguages) {
        return this.acceptLanguages(ImmutableList.copyOf(Objects.requireNonNull(acceptedLanguages, "acceptedLanguages")));
    }

    public RequestHeadersBuilder cookie(Cookie var1);

    public RequestHeadersBuilder cookies(Iterable<? extends Cookie> var1);

    public RequestHeadersBuilder cookies(Cookie ... var1);

    public RequestHeadersBuilder accept(MediaType ... var1);

    public RequestHeadersBuilder accept(Iterable<MediaType> var1);

    @Override
    public RequestHeadersBuilder sizeHint(int var1);

    @Override
    public RequestHeadersBuilder endOfStream(boolean var1);

    @Override
    public RequestHeadersBuilder contentLength(long var1);

    @Override
    public RequestHeadersBuilder contentType(MediaType var1);

    @Override
    public RequestHeadersBuilder contentDisposition(ContentDisposition var1);

    @Override
    public RequestHeadersBuilder add(CharSequence var1, String var2);

    @Override
    public RequestHeadersBuilder add(CharSequence var1, Iterable<String> var2);

    @Override
    public RequestHeadersBuilder add(CharSequence var1, String ... var2);

    @Override
    public RequestHeadersBuilder add(Iterable<? extends Map.Entry<? extends CharSequence, String>> var1);

    @Override
    default public RequestHeadersBuilder add(Map<? extends CharSequence, String> entries) {
        return (RequestHeadersBuilder)HttpHeadersBuilder.super.add(entries);
    }

    @Override
    public RequestHeadersBuilder addObject(CharSequence var1, Object var2);

    @Override
    public RequestHeadersBuilder addObject(CharSequence var1, Iterable<?> var2);

    @Override
    public RequestHeadersBuilder addObject(CharSequence var1, Object ... var2);

    @Override
    public RequestHeadersBuilder addObject(Iterable<? extends Map.Entry<? extends CharSequence, ?>> var1);

    @Override
    public RequestHeadersBuilder addInt(CharSequence var1, int var2);

    @Override
    public RequestHeadersBuilder addLong(CharSequence var1, long var2);

    @Override
    public RequestHeadersBuilder addFloat(CharSequence var1, float var2);

    @Override
    public RequestHeadersBuilder addDouble(CharSequence var1, double var2);

    @Override
    public RequestHeadersBuilder addTimeMillis(CharSequence var1, long var2);

    @Override
    public RequestHeadersBuilder set(CharSequence var1, String var2);

    @Override
    public RequestHeadersBuilder set(CharSequence var1, Iterable<String> var2);

    @Override
    public RequestHeadersBuilder set(CharSequence var1, String ... var2);

    @Override
    public RequestHeadersBuilder set(Iterable<? extends Map.Entry<? extends CharSequence, String>> var1);

    @Override
    default public RequestHeadersBuilder set(Map<? extends CharSequence, String> entries) {
        return (RequestHeadersBuilder)HttpHeadersBuilder.super.set(entries);
    }

    @Override
    public RequestHeadersBuilder setIfAbsent(Iterable<? extends Map.Entry<? extends CharSequence, String>> var1);

    @Override
    public RequestHeadersBuilder setObject(CharSequence var1, Object var2);

    @Override
    public RequestHeadersBuilder setObject(CharSequence var1, Iterable<?> var2);

    @Override
    public RequestHeadersBuilder setObject(CharSequence var1, Object ... var2);

    @Override
    public RequestHeadersBuilder setObject(Iterable<? extends Map.Entry<? extends CharSequence, ?>> var1);

    @Override
    public RequestHeadersBuilder setInt(CharSequence var1, int var2);

    @Override
    public RequestHeadersBuilder setLong(CharSequence var1, long var2);

    @Override
    public RequestHeadersBuilder setFloat(CharSequence var1, float var2);

    @Override
    public RequestHeadersBuilder setDouble(CharSequence var1, double var2);

    @Override
    public RequestHeadersBuilder setTimeMillis(CharSequence var1, long var2);

    @Override
    public RequestHeadersBuilder removeAndThen(CharSequence var1);

    @Override
    public RequestHeadersBuilder clear();
}

