/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.google.errorprone.annotations.MustBeClosed;
import com.linecorp.armeria.common.ContextAwareBlockingTaskExecutor;
import com.linecorp.armeria.common.ContextAwareEventLoop;
import com.linecorp.armeria.common.ContextAwareExecutor;
import com.linecorp.armeria.common.ContextAwareExecutorService;
import com.linecorp.armeria.common.ContextAwareLogger;
import com.linecorp.armeria.common.ContextAwareScheduledExecutorService;
import com.linecorp.armeria.common.ContextHolder;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.PropagatingContextAwareBlockingTaskExecutor;
import com.linecorp.armeria.common.PropagatingContextAwareExecutor;
import com.linecorp.armeria.common.PropagatingContextAwareExecutorService;
import com.linecorp.armeria.common.PropagatingContextAwareScheduledExecutorService;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.TimeoutException;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.common.util.Unwrappable;
import com.linecorp.armeria.internal.common.JavaVersionSpecific;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;

public interface RequestContext
extends Unwrappable {
    public static <T extends RequestContext> T current() {
        T ctx = RequestContext.currentOrNull();
        if (ctx == null) {
            throw new IllegalStateException(RequestContext.class.getSimpleName() + " unavailable");
        }
        return ctx;
    }

    @Nullable
    public static <T extends RequestContext> T currentOrNull() {
        return RequestContextUtil.get();
    }

    public static Executor makeContextPropagating(Executor executor) {
        return PropagatingContextAwareExecutor.of(executor);
    }

    public static ExecutorService makeContextPropagating(ExecutorService executor) {
        return PropagatingContextAwareExecutorService.of(executor);
    }

    public static ScheduledExecutorService makeContextPropagating(ScheduledExecutorService executor) {
        return PropagatingContextAwareScheduledExecutorService.of(executor);
    }

    public static BlockingTaskExecutor makeContextPropagating(BlockingTaskExecutor executor) {
        return PropagatingContextAwareBlockingTaskExecutor.of(executor);
    }

    @Nullable
    public static <T> T mapCurrent(Function<? super RequestContext, T> mapper, @Nullable @Nullable Supplier<@Nullable T> defaultValueSupplier) {
        T ctx = RequestContext.currentOrNull();
        if (ctx != null) {
            return mapper.apply((RequestContext)ctx);
        }
        if (defaultValueSupplier != null) {
            return defaultValueSupplier.get();
        }
        return null;
    }

    @Nullable
    public ServiceRequestContext root();

    @Nullable
    public <V> V attr(AttributeKey<V> var1);

    @Nullable
    public <V> V ownAttr(AttributeKey<V> var1);

    default public boolean hasAttr(AttributeKey<?> key) {
        return this.attr(key) != null;
    }

    default public boolean hasOwnAttr(AttributeKey<?> key) {
        return this.ownAttr(key) != null;
    }

    public Iterator<Map.Entry<AttributeKey<?>, Object>> attrs();

    public Iterator<Map.Entry<AttributeKey<?>, Object>> ownAttrs();

    @Nullable
    public <V> V setAttr(AttributeKey<V> var1, @Nullable V var2);

    @Nullable
    public HttpRequest request();

    @Nullable
    public RpcRequest rpcRequest();

    public void updateRequest(HttpRequest var1);

    public void updateRpcRequest(RpcRequest var1);

    public SessionProtocol sessionProtocol();

    @Nullable
    public <A extends SocketAddress> A remoteAddress();

    @Nullable
    public <A extends SocketAddress> A localAddress();

    @Nullable
    public SSLSession sslSession();

    public RequestId id();

    public HttpMethod method();

    public String path();

    public String decodedPath();

    @Nullable
    public String query();

    public URI uri();

    public RequestLogAccess log();

    public RequestLogBuilder logBuilder();

    public MeterRegistry meterRegistry();

    public void cancel(Throwable var1);

    public void cancel();

    public void timeoutNow();

    @Nullable
    public Throwable cancellationCause();

    default public boolean isCancelled() {
        return this.cancellationCause() != null;
    }

    default public boolean isTimedOut() {
        return this.cancellationCause() instanceof TimeoutException;
    }

    public ContextAwareEventLoop eventLoop();

    default public ByteBufAllocator alloc() {
        throw new UnsupportedOperationException("No ByteBufAllocator available for this RequestContext.");
    }

    public ExchangeType exchangeType();

    public CompletableFuture<Void> initiateConnectionShutdown();

    @MustBeClosed
    public SafeCloseable push();

    @Override
    default public RequestContext unwrap() {
        return (RequestContext)Unwrappable.super.unwrap();
    }

    @Override
    default public RequestContext unwrapAll() {
        return (RequestContext)Unwrappable.super.unwrapAll();
    }

    default public void run(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable");
        try (SafeCloseable ignored = this.push();){
            runnable.run();
        }
    }

    default public <T> T run(Callable<T> callable) throws Exception {
        Objects.requireNonNull(callable, "callable");
        try (SafeCloseable ignored = this.push();){
            T t = callable.call();
            return t;
        }
    }

    @MustBeClosed
    default public SafeCloseable replace() {
        Object oldCtx = RequestContextUtil.getAndSet(this);
        return () -> RequestContextUtil.pop(this, oldCtx);
    }

    default public ContextAwareExecutor makeContextAware(Executor executor) {
        Objects.requireNonNull(executor, "executor");
        return ContextAwareExecutor.of(this, executor);
    }

    default public ContextAwareExecutorService makeContextAware(ExecutorService executor) {
        return ContextAwareExecutorService.of(this, executor);
    }

    default public ContextAwareScheduledExecutorService makeContextAware(ScheduledExecutorService executor) {
        return ContextAwareScheduledExecutorService.of(this, executor);
    }

    default public ContextAwareBlockingTaskExecutor makeContextAware(BlockingTaskExecutor executor) {
        return ContextAwareBlockingTaskExecutor.of(this, executor);
    }

    default public <T> Callable<T> makeContextAware(Callable<T> callable) {
        Objects.requireNonNull(callable, "callable");
        return () -> {
            try (SafeCloseable ignored = this.push();){
                Object v = callable.call();
                return v;
            }
        };
    }

    default public Runnable makeContextAware(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable");
        return () -> {
            try (SafeCloseable ignored = this.push();){
                runnable.run();
            }
        };
    }

    default public <T, R> Function<T, R> makeContextAware(Function<T, R> function) {
        Objects.requireNonNull(function, "function");
        return t -> {
            try (SafeCloseable ignored = this.push();){
                Object r = function.apply(t);
                return r;
            }
        };
    }

    default public <T, U, V> BiFunction<T, U, V> makeContextAware(BiFunction<T, U, V> function) {
        Objects.requireNonNull(function, "function");
        return (t, u) -> {
            try (SafeCloseable ignored = this.push();){
                Object r = function.apply(t, u);
                return r;
            }
        };
    }

    default public <T> Consumer<T> makeContextAware(Consumer<T> action) {
        Objects.requireNonNull(action, "action");
        return t -> {
            try (SafeCloseable ignored = this.push();){
                action.accept(t);
            }
        };
    }

    default public <T, U> BiConsumer<T, U> makeContextAware(BiConsumer<T, U> action) {
        Objects.requireNonNull(action, "action");
        return (t, u) -> {
            try (SafeCloseable ignored = this.push();){
                action.accept(t, u);
            }
        };
    }

    default public <T> CompletionStage<T> makeContextAware(CompletionStage<T> stage) {
        Objects.requireNonNull(stage, "stage");
        if (stage instanceof ContextHolder) {
            RequestContext context = ((ContextHolder)((Object)stage)).context();
            if (this == context) {
                return stage;
            }
            if (this.root() != context.root()) {
                throw new IllegalArgumentException("cannot create a context aware future using " + stage);
            }
        }
        CompletableFuture future = JavaVersionSpecific.get().newContextAwareFuture(this);
        stage.handle((result, cause) -> {
            try (SafeCloseable ignored = this.push();){
                if (cause != null) {
                    future.completeExceptionally((Throwable)cause);
                } else {
                    future.complete(result);
                }
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
            return null;
        });
        return future;
    }

    default public <T> CompletableFuture<T> makeContextAware(CompletableFuture<T> future) {
        Objects.requireNonNull(future, "future");
        return this.makeContextAware((CompletionStage<T>)future).toCompletableFuture();
    }

    default public Logger makeContextAware(Logger logger) {
        return ContextAwareLogger.of(this, logger);
    }
}

