/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ExceptionSampler;
import com.linecorp.armeria.common.FlagsProvider;
import com.linecorp.armeria.common.FlagsUtil;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestContextStorage;
import com.linecorp.armeria.common.RequestContextStorageProvider;
import com.linecorp.armeria.common.util.Sampler;
import com.linecorp.armeria.common.util.TransportType;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.TransientServiceOption;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.io.File;
import java.net.InetAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

final class DefaultFlagsProvider
implements FlagsProvider {
    static final DefaultFlagsProvider INSTANCE = new DefaultFlagsProvider();
    static final String VERBOSE_EXCEPTION_SAMPLER_SPEC = "rate-limit=10";
    static final Sampler<Class<? extends Throwable>> VERBOSE_EXCEPTION_SAMPLER = new ExceptionSampler("rate-limit=10");
    static final int MAX_NUM_CONNECTIONS = Integer.MAX_VALUE;
    static final int NUM_COMMON_BLOCKING_TASK_THREADS = 200;
    static final long DEFAULT_MAX_REQUEST_LENGTH = 0xA00000L;
    static final long DEFAULT_MAX_RESPONSE_LENGTH = 0xA00000L;
    static final long DEFAULT_SERVER_IDLE_TIMEOUT_MILLIS = 15000L;
    static final long DEFAULT_CLIENT_IDLE_TIMEOUT_MILLIS = 10000L;
    static final long DEFAULT_CONNECT_TIMEOUT_MILLIS = 3200L;
    static final long DEFAULT_WRITE_TIMEOUT_MILLIS = 1000L;
    static final long DEFAULT_RESPONSE_TIMEOUT_MILLIS = 15000L;
    static final long DEFAULT_REQUEST_TIMEOUT_MILLIS = 10000L;
    static final int DEFAULT_HTTP1_MAX_INITIAL_LINE_LENGTH = 4096;
    static final int DEFAULT_HTTP1_MAX_HEADER_SIZE = 8192;
    static final int DEFAULT_HTTP1_MAX_CHUNK_SIZE = 8192;
    static final long DEFAULT_PING_INTERVAL_MILLIS = 0L;
    static final int DEFAULT_MAX_SERVER_NUM_REQUESTS_PER_CONNECTION = 0;
    static final int DEFAULT_MAX_CLIENT_NUM_REQUESTS_PER_CONNECTION = 0;
    static final long DEFAULT_MAX_SERVER_CONNECTION_AGE_MILLIS = 0L;
    static final long DEFAULT_MAX_CLIENT_CONNECTION_AGE_MILLIS = 0L;
    static final long DEFAULT_SERVER_CONNECTION_DRAIN_DURATION_MICROS = 1000000L;
    static final int DEFAULT_HTTP2_INITIAL_CONNECTION_WINDOW_SIZE = 0x100000;
    static final int DEFAULT_HTTP2_INITIAL_STREAM_WINDOW_SIZE = 0x100000;
    static final int DEFAULT_HTTP2_MAX_FRAME_SIZE = 16384;
    static final long DEFAULT_HTTP2_MAX_STREAMS_PER_CONNECTION = Integer.MAX_VALUE;
    static final long DEFAULT_HTTP2_MAX_HEADER_LIST_SIZE = 8192L;
    static final String DEFAULT_BACKOFF_SPEC = "exponential=200:10000,jitter=0.2";
    static final int DEFAULT_MAX_TOTAL_ATTEMPTS = 10;
    static final String ROUTE_CACHE_SPEC = "maximumSize=4096";
    static final String ROUTE_DECORATOR_CACHE_SPEC = "maximumSize=4096";
    static final String PARSED_PATH_CACHE_SPEC = "maximumSize=4096";
    static final String HEADER_VALUE_CACHE_SPEC = "maximumSize=4096";
    static final String CACHED_HEADERS = ":authority,:scheme,:method,accept-encoding,content-type";
    static final String FILE_SERVICE_CACHE_SPEC = "maximumSize=1024";
    static final String DNS_CACHE_SPEC = "maximumSize=4096";
    static final long DEFAULT_UNHANDLED_EXCEPTIONS_REPORT_INTERVAL_MILLIS = 10000L;

    private DefaultFlagsProvider() {
    }

    @Override
    public int priority() {
        return Integer.MIN_VALUE;
    }

    @Override
    public String name() {
        return "default";
    }

    @Override
    public Sampler<Class<? extends Throwable>> verboseExceptionSampler() {
        return VERBOSE_EXCEPTION_SAMPLER;
    }

    @Override
    public Boolean verboseSocketExceptions() {
        return false;
    }

    @Override
    public Boolean verboseResponses() {
        return false;
    }

    @Override
    public RequestContextStorageProvider requestContextStorageProvider() {
        List<RequestContextStorageProvider> providers = FlagsUtil.getRequestContextStorageProviders();
        if (providers.isEmpty()) {
            return new RequestContextStorageProvider(){

                @Override
                public RequestContextStorage newStorage() {
                    return RequestContextStorage.threadLocal();
                }

                public String toString() {
                    return "thread-local";
                }
            };
        }
        return providers.get(0);
    }

    @Override
    public Boolean warnNettyVersions() {
        return true;
    }

    @Override
    public TransportType transportType() {
        return TransportType.EPOLL.isAvailable() ? TransportType.EPOLL : TransportType.NIO;
    }

    @Override
    public Boolean useOpenSsl() {
        return true;
    }

    @Override
    public Boolean dumpOpenSslInfo() {
        return false;
    }

    @Override
    public Integer maxNumConnections() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Integer numCommonWorkers() {
        int defaultNumCpuCores = Runtime.getRuntime().availableProcessors();
        return defaultNumCpuCores * 2;
    }

    @Override
    public Integer numCommonBlockingTaskThreads() {
        return 200;
    }

    @Override
    public Long defaultMaxRequestLength() {
        return 0xA00000L;
    }

    @Override
    public Long defaultMaxResponseLength() {
        return 0xA00000L;
    }

    @Override
    public Long defaultRequestTimeoutMillis() {
        return 10000L;
    }

    @Override
    public Long defaultResponseTimeoutMillis() {
        return 15000L;
    }

    @Override
    public Long defaultConnectTimeoutMillis() {
        return 3200L;
    }

    @Override
    public Long defaultWriteTimeoutMillis() {
        return 1000L;
    }

    @Override
    public Long defaultServerIdleTimeoutMillis() {
        return 15000L;
    }

    @Override
    public Long defaultClientIdleTimeoutMillis() {
        return 10000L;
    }

    @Override
    public Integer defaultHttp1MaxInitialLineLength() {
        return 4096;
    }

    @Override
    public Integer defaultHttp1MaxHeaderSize() {
        return 8192;
    }

    @Override
    public Integer defaultHttp1MaxChunkSize() {
        return 8192;
    }

    @Override
    public Boolean defaultUseHttp2Preface() {
        return true;
    }

    @Override
    public Boolean defaultUseHttp1Pipelining() {
        return false;
    }

    @Override
    public Long defaultPingIntervalMillis() {
        return 0L;
    }

    @Override
    public Integer defaultMaxServerNumRequestsPerConnection() {
        return 0;
    }

    @Override
    public Integer defaultMaxClientNumRequestsPerConnection() {
        return 0;
    }

    @Override
    public Long defaultMaxServerConnectionAgeMillis() {
        return 0L;
    }

    @Override
    public Long defaultMaxClientConnectionAgeMillis() {
        return 0L;
    }

    @Override
    public Long defaultServerConnectionDrainDurationMicros() {
        return 1000000L;
    }

    @Override
    public Integer defaultHttp2InitialConnectionWindowSize() {
        return 0x100000;
    }

    @Override
    public Integer defaultHttp2InitialStreamWindowSize() {
        return 0x100000;
    }

    @Override
    public Integer defaultHttp2MaxFrameSize() {
        return 16384;
    }

    @Override
    public Long defaultHttp2MaxStreamsPerConnection() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Long defaultHttp2MaxHeaderListSize() {
        return 8192L;
    }

    @Override
    public String defaultBackoffSpec() {
        return DEFAULT_BACKOFF_SPEC;
    }

    @Override
    public Integer defaultMaxTotalAttempts() {
        return 10;
    }

    @Override
    public String routeCacheSpec() {
        return "maximumSize=4096";
    }

    @Override
    public String routeDecoratorCacheSpec() {
        return "maximumSize=4096";
    }

    @Override
    public String parsedPathCacheSpec() {
        return "maximumSize=4096";
    }

    @Override
    public String headerValueCacheSpec() {
        return "maximumSize=4096";
    }

    @Override
    public List<String> cachedHeaders() {
        return Splitter.on(',').trimResults().omitEmptyStrings().splitToList(CACHED_HEADERS);
    }

    @Override
    public String fileServiceCacheSpec() {
        return FILE_SERVICE_CACHE_SPEC;
    }

    @Override
    public String dnsCacheSpec() {
        return "maximumSize=4096";
    }

    @Override
    public Predicate<InetAddress> preferredIpV4Addresses() {
        return new Predicate<InetAddress>(){

            @Override
            public boolean test(InetAddress ignored) {
                return true;
            }

            public String toString() {
                return "*";
            }
        };
    }

    @Override
    public Boolean useJdkDnsResolver() {
        return false;
    }

    @Override
    public Boolean reportBlockedEventLoop() {
        return true;
    }

    @Override
    public Boolean reportMaskedRoutes() {
        return true;
    }

    @Override
    public Boolean validateHeaders() {
        return true;
    }

    @Override
    public Boolean tlsAllowUnsafeCiphers() {
        return false;
    }

    @Override
    public Set<TransientServiceOption> transientServiceOptions() {
        return ImmutableSet.of();
    }

    @Override
    public Boolean useDefaultSocketOptions() {
        return true;
    }

    @Override
    public Boolean useLegacyRouteDecoratorOrdering() {
        return false;
    }

    @Override
    public Boolean allowDoubleDotsInQueryString() {
        return false;
    }

    @Override
    public Path defaultMultipartUploadsLocation() {
        return Paths.get(System.getProperty("java.io.tmpdir") + File.separatorChar + "armeria" + File.separatorChar + "multipart-uploads", new String[0]);
    }

    @Override
    public Sampler<? super RequestContext> requestContextLeakDetectionSampler() {
        return Sampler.never();
    }

    @Override
    public MeterRegistry meterRegistry() {
        return Metrics.globalRegistry;
    }

    @Override
    public Long defaultUnhandledExceptionsReportIntervalMillis() {
        return 10000L;
    }
}

