/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.DependencyInjector;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultDependencyInjector
implements DependencyInjector {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDependencyInjector.class);
    private final Map<Class<?>, Object> singletons = new HashMap();
    private boolean isShutdown;

    DefaultDependencyInjector(Iterable<Object> singletons) {
        Objects.requireNonNull(singletons, "singletons");
        for (Object singleton : singletons) {
            Objects.requireNonNull(singleton, "singleton");
            this.singletons.put(singleton.getClass(), singleton);
        }
    }

    @Override
    public synchronized <T> T getInstance(Class<T> type) {
        if (this.isShutdown) {
            throw new IllegalStateException("Already shut down");
        }
        Object instance = this.singletons.get(type);
        if (instance != null) {
            return (T)instance;
        }
        return null;
    }

    @Override
    public synchronized void close() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        for (Object instance : this.singletons.values()) {
            if (!(instance instanceof AutoCloseable)) continue;
            DefaultDependencyInjector.close((AutoCloseable)instance);
        }
        this.singletons.clear();
    }

    private static void close(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            logger.warn("Unexpected exception while closing {}", (Object)closeable, (Object)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("singletons", this.singletons).toString();
    }
}

