/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.linecorp.armeria.common.AbstractHttpMessageBuilder;
import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpRequestSetters;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.QueryParamsBuilder;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.reactivestreams.Publisher;

public abstract class AbstractHttpRequestBuilder
extends AbstractHttpMessageBuilder
implements HttpRequestSetters {
    private final RequestHeadersBuilder requestHeadersBuilder = RequestHeaders.builder();
    @Nullable
    private QueryParamsBuilder queryParams;
    @Nullable
    private Map<String, String> pathParams;
    @Nullable
    private String path;
    private boolean disablePathParams;

    @Override
    public AbstractHttpRequestBuilder get(String path) {
        return this.method(HttpMethod.GET).path(path);
    }

    @Override
    public AbstractHttpRequestBuilder post(String path) {
        return this.method(HttpMethod.POST).path(path);
    }

    @Override
    public AbstractHttpRequestBuilder put(String path) {
        return this.method(HttpMethod.PUT).path(path);
    }

    @Override
    public AbstractHttpRequestBuilder delete(String path) {
        return this.method(HttpMethod.DELETE).path(path);
    }

    @Override
    public AbstractHttpRequestBuilder patch(String path) {
        return this.method(HttpMethod.PATCH).path(path);
    }

    @Override
    public AbstractHttpRequestBuilder options(String path) {
        return this.method(HttpMethod.OPTIONS).path(path);
    }

    @Override
    public AbstractHttpRequestBuilder head(String path) {
        return this.method(HttpMethod.HEAD).path(path);
    }

    @Override
    public AbstractHttpRequestBuilder trace(String path) {
        return this.method(HttpMethod.TRACE).path(path);
    }

    @Override
    public AbstractHttpRequestBuilder method(HttpMethod method) {
        this.requestHeadersBuilder.method(Objects.requireNonNull(method, "method"));
        return this;
    }

    @Override
    public AbstractHttpRequestBuilder path(String path) {
        Objects.requireNonNull(path, "path");
        this.path = path;
        return this;
    }

    @Override
    public AbstractHttpRequestBuilder content(String content) {
        return (AbstractHttpRequestBuilder)super.content(content);
    }

    @Override
    public AbstractHttpRequestBuilder content(MediaType contentType, CharSequence content) {
        return (AbstractHttpRequestBuilder)super.content(contentType, content);
    }

    @Override
    public AbstractHttpRequestBuilder content(MediaType contentType, String content) {
        return (AbstractHttpRequestBuilder)super.content(contentType, content);
    }

    @Override
    @FormatMethod
    public AbstractHttpRequestBuilder content(@FormatString String format, Object ... content) {
        return (AbstractHttpRequestBuilder)super.content(format, content);
    }

    @Override
    @FormatMethod
    public AbstractHttpRequestBuilder content(MediaType contentType, @FormatString String format, Object ... content) {
        return (AbstractHttpRequestBuilder)super.content(contentType, format, content);
    }

    @Override
    public AbstractHttpRequestBuilder content(MediaType contentType, byte[] content) {
        return (AbstractHttpRequestBuilder)super.content(contentType, content);
    }

    @Override
    public AbstractHttpRequestBuilder content(MediaType contentType, HttpData content) {
        return (AbstractHttpRequestBuilder)super.content(contentType, content);
    }

    @Override
    public AbstractHttpRequestBuilder content(MediaType contentType, Publisher<? extends HttpData> content) {
        return (AbstractHttpRequestBuilder)super.content(contentType, (Publisher)content);
    }

    @Override
    public AbstractHttpRequestBuilder contentJson(Object content) {
        return (AbstractHttpRequestBuilder)super.contentJson(content);
    }

    @Override
    public AbstractHttpRequestBuilder header(CharSequence name, Object value) {
        return (AbstractHttpRequestBuilder)super.header(name, value);
    }

    @Override
    public AbstractHttpRequestBuilder headers(Iterable<? extends Map.Entry<? extends CharSequence, String>> headers) {
        return (AbstractHttpRequestBuilder)super.headers((Iterable)headers);
    }

    @Override
    public AbstractHttpRequestBuilder trailers(Iterable<? extends Map.Entry<? extends CharSequence, String>> trailers) {
        return (AbstractHttpRequestBuilder)super.trailers((Iterable)trailers);
    }

    @Override
    public AbstractHttpRequestBuilder pathParam(String name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        Preconditions.checkArgument(!name.isEmpty(), "name is empty.");
        if (this.pathParams == null) {
            this.pathParams = new HashMap<String, String>();
        }
        this.pathParams.put(name, value.toString());
        return this;
    }

    @Override
    public AbstractHttpRequestBuilder pathParams(Map<String, ?> pathParams) {
        Objects.requireNonNull(pathParams, "pathParams");
        if (pathParams.isEmpty()) {
            return this;
        }
        Preconditions.checkArgument(!pathParams.containsKey(""), "pathParams contains an entry with an empty name: %s", pathParams);
        if (this.pathParams == null) {
            this.pathParams = new HashMap<String, String>();
        }
        pathParams.forEach((key, value) -> this.pathParams.put((String)key, value.toString()));
        return this;
    }

    @Override
    public AbstractHttpRequestBuilder disablePathParams() {
        this.disablePathParams = true;
        return this;
    }

    @Override
    public AbstractHttpRequestBuilder queryParam(String name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        if (this.queryParams == null) {
            this.queryParams = QueryParams.builder();
        }
        this.queryParams.addObject(name, value);
        return this;
    }

    @Override
    public AbstractHttpRequestBuilder queryParams(Iterable<? extends Map.Entry<? extends String, String>> queryParams) {
        Objects.requireNonNull(queryParams, "queryParams");
        if (this.queryParams == null) {
            this.queryParams = QueryParams.builder();
        }
        this.queryParams.add(queryParams);
        return this;
    }

    @Override
    public AbstractHttpRequestBuilder cookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "cookie");
        this.requestHeadersBuilder.cookie(cookie);
        return this;
    }

    @Override
    public AbstractHttpRequestBuilder cookies(Iterable<? extends Cookie> cookies) {
        Objects.requireNonNull(cookies, "cookies");
        this.requestHeadersBuilder.cookies(cookies);
        return this;
    }

    protected final HttpRequest buildRequest() {
        RequestHeaders requestHeaders = this.requestHeaders();
        Publisher<? extends HttpData> publisher = this.publisher();
        HttpHeadersBuilder httpTrailersBuilder = this.httpTrailers();
        if (publisher != null) {
            if (httpTrailersBuilder == null) {
                return HttpRequest.of(requestHeaders, publisher);
            }
            return HttpRequest.of(requestHeaders, StreamMessage.concat(publisher, StreamMessage.of(httpTrailersBuilder.build())));
        }
        HttpData content = MoreObjects.firstNonNull(this.content(), HttpData.empty());
        HttpHeaders httpTrailers = httpTrailersBuilder != null ? httpTrailersBuilder.build() : HttpHeaders.of();
        return HttpRequest.of(requestHeaders, content, httpTrailers);
    }

    @Override
    final HttpHeadersBuilder headersBuilder() {
        return this.requestHeadersBuilder;
    }

    private RequestHeaders requestHeaders() {
        this.requestHeadersBuilder.path(this.buildPath());
        HttpData content = this.content();
        if (content == null || content.isEmpty()) {
            if (this.publisher() == null) {
                this.requestHeadersBuilder.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            }
        } else {
            this.requestHeadersBuilder.contentLength(content.length());
        }
        return this.requestHeadersBuilder.build();
    }

    private String buildPath() {
        Preconditions.checkState(this.path != null, "path must be set.");
        if (!this.disablePathParams) {
            int pathLen = this.path.length();
            int i = 0;
            boolean hasPathParams = false;
            boolean hasQueryInPath = false;
            block15: while (i < pathLen) {
                switch (this.path.charAt(i)) {
                    case ':': {
                        if (i + 1 < pathLen && this.path.charAt(i + 1) == '/') {
                            if (i + 2 < pathLen && this.path.charAt(i + 2) == '/') {
                                int pathStart = this.path.indexOf(47, i + 3);
                                if (pathStart < 0) {
                                    i = pathLen;
                                    break block15;
                                }
                                i = pathStart + 1;
                                continue block15;
                            }
                            i += 2;
                            continue block15;
                        }
                        hasPathParams = true;
                        break block15;
                    }
                    case '{': {
                        if (i + 1 < pathLen && this.path.charAt(i + 1) == '}') {
                            i += 2;
                            continue block15;
                        }
                        hasPathParams = true;
                        break block15;
                    }
                    case '?': {
                        hasQueryInPath = true;
                        break block15;
                    }
                    default: {
                        ++i;
                        continue block15;
                    }
                }
            }
            if (hasPathParams) {
                try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
                    StringBuilder buf = tempThreadLocals.stringBuilder();
                    buf.append(this.path, 0, i);
                    block16: while (i < pathLen) {
                        char ch = this.path.charAt(i);
                        switch (ch) {
                            case '{': {
                                String name;
                                int j;
                                for (j = i + 1; j < pathLen && this.path.charAt(j) != '}'; ++j) {
                                }
                                if (j >= pathLen) {
                                    buf.append(this.path, i, pathLen);
                                    break block16;
                                }
                                if (j > i + 1) {
                                    name = this.path.substring(i + 1, j);
                                    Preconditions.checkState(this.pathParams != null && this.pathParams.containsKey(name), "param '%s' does not have a value.", name);
                                    buf.append(this.pathParams.get(name));
                                } else {
                                    ++j;
                                    buf.append('{').append('}');
                                }
                                i = ++j;
                                continue block16;
                            }
                            case ':': {
                                String name;
                                int j;
                                for (j = i + 1; j < pathLen && this.path.charAt(j) != '/' && this.path.charAt(j) != '?'; ++j) {
                                }
                                if (j > i + 1) {
                                    name = this.path.substring(i + 1, j);
                                    Preconditions.checkState(this.pathParams != null && this.pathParams.containsKey(name), "param '%s' does not have a value.", name);
                                    buf.append(this.pathParams.get(name));
                                } else {
                                    buf.append(':');
                                }
                                i = j;
                                continue block16;
                            }
                            case '?': {
                                hasQueryInPath = true;
                                buf.append(this.path, i, pathLen);
                                break block16;
                            }
                            default: {
                                buf.append(ch);
                                ++i;
                                continue block16;
                            }
                        }
                    }
                    if (hasQueryInPath) {
                        if (this.queryParams != null) {
                            buf.append('&');
                            this.queryParams.appendQueryString(buf);
                        }
                    } else if (this.queryParams != null) {
                        buf.append('?');
                        this.queryParams.appendQueryString(buf);
                    }
                    String string = buf.toString();
                    return string;
                }
            }
            if (this.queryParams != null) {
                return AbstractHttpRequestBuilder.buildPathWithoutPathParams(this.path, this.queryParams, hasQueryInPath);
            }
        } else if (this.queryParams != null) {
            return AbstractHttpRequestBuilder.buildPathWithoutPathParams(this.path, this.queryParams, this.path.indexOf(63) >= 0);
        }
        return this.path;
    }

    private static String buildPathWithoutPathParams(String path, QueryParamsBuilder queryParams, boolean hasQueryInPath) {
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            buf.append(path).append(hasQueryInPath ? (char)'&' : '?');
            queryParams.appendQueryString(buf);
            String string = buf.toString();
            return string;
        }
    }
}

