/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.endpoint.FileWatcherRunnable;
import com.linecorp.armeria.client.endpoint.RestartableThread;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

final class FileWatcherRegistry
implements AutoCloseable {
    private final Map<FileSystem, FileSystemWatchContext> fileSystemWatchServiceMap = new HashMap<FileSystem, FileSystemWatchContext>();
    private final ReentrantLock lock = new ReentrantLock();

    FileWatcherRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileWatchRegisterKey register(Path filePath, Runnable callback) {
        this.lock();
        try {
            FileWatchRegisterKey watchRegisterKey = new FileWatchRegisterKey(filePath);
            FileSystemWatchContext watchServiceContext = this.fileSystemWatchServiceMap.computeIfAbsent(filePath.getFileSystem(), fileSystem -> {
                try {
                    return new FileSystemWatchContext("armeria-file-watcher-" + fileSystem.getClass().getName(), fileSystem.newWatchService());
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("failed to create a new watch service for the path: " + watchRegisterKey.filePath(), e);
                }
            });
            watchServiceContext.register(watchRegisterKey, callback);
            FileWatchRegisterKey fileWatchRegisterKey = watchRegisterKey;
            return fileWatchRegisterKey;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(FileWatchRegisterKey watchRegisterKey) {
        this.lock();
        try {
            FileSystem fileSystem = watchRegisterKey.filePath().getFileSystem();
            FileSystemWatchContext watchServiceContext = this.fileSystemWatchServiceMap.get(fileSystem);
            if (watchServiceContext == null) {
                return;
            }
            watchServiceContext.unregister(watchRegisterKey);
            if (!watchServiceContext.isRunning()) {
                this.fileSystemWatchServiceMap.remove(fileSystem);
            }
        }
        finally {
            this.unlock();
        }
    }

    boolean isRunning() {
        return this.fileSystemWatchServiceMap.values().stream().anyMatch(FileSystemWatchContext::isRunning);
    }

    @Override
    public void close() throws Exception {
        this.lock();
        try {
            this.fileSystemWatchServiceMap.values().forEach(context -> {
                try {
                    context.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            this.fileSystemWatchServiceMap.clear();
        }
        finally {
            this.unlock();
        }
    }

    private void lock() {
        this.lock.lock();
    }

    private void unlock() {
        this.lock.unlock();
    }

    static final class FileWatchRegisterKey {
        private final Path filePath;

        private FileWatchRegisterKey(Path filePath) {
            this.filePath = filePath;
        }

        Path filePath() {
            return this.filePath;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("filePath", this.filePath).toString();
        }
    }

    static class FileSystemWatchContext {
        private final RestartableThread restartableThread;
        private final WatchService watchService;
        private final Map<FileWatchRegisterKey, FileWatcherRunnable.FileWatchEvent> currWatchEventMap = new ConcurrentHashMap<FileWatchRegisterKey, FileWatcherRunnable.FileWatchEvent>();

        FileSystemWatchContext(String name, WatchService watchService) {
            this.restartableThread = new RestartableThread(name, () -> new FileWatcherRunnable(watchService, this));
            this.watchService = watchService;
        }

        private void register(FileWatchRegisterKey watchRegisterKey, Runnable callback) {
            WatchKey watchKey;
            Path dirPath = watchRegisterKey.filePath().getParent();
            Preconditions.checkArgument(dirPath != null, "no parent directory for input path: %s", (Object)watchRegisterKey.filePath());
            try {
                watchKey = dirPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to watch a file " + watchRegisterKey.filePath(), e);
            }
            this.currWatchEventMap.put(watchRegisterKey, new FileWatcherRunnable.FileWatchEvent(watchKey, callback, dirPath));
            this.restartableThread.start();
        }

        private void unregister(FileWatchRegisterKey watchRegisterKey) {
            if (!this.currWatchEventMap.containsKey(watchRegisterKey)) {
                return;
            }
            FileWatcherRunnable.FileWatchEvent fileWatchEvent = this.currWatchEventMap.remove(watchRegisterKey);
            boolean existsDirWatcher = this.currWatchEventMap.values().stream().anyMatch(value -> value.dirPath().equals(fileWatchEvent.dirPath()));
            if (!existsDirWatcher) {
                fileWatchEvent.cancel();
            }
            if (this.currWatchEventMap.isEmpty()) {
                this.restartableThread.stop();
            }
        }

        boolean isRunning() {
            return this.restartableThread.isRunning();
        }

        Collection<FileWatcherRunnable.FileWatchEvent> watchEvents() {
            return this.currWatchEventMap.values();
        }

        void close() throws IOException {
            this.currWatchEventMap.clear();
            this.restartableThread.stop();
            this.watchService.close();
        }
    }
}

