/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelector;
import com.linecorp.armeria.client.endpoint.RoundRobinStrategy;
import com.linecorp.armeria.client.endpoint.StickyEndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.WeightRampingUpStrategy;
import com.linecorp.armeria.client.endpoint.WeightRampingUpStrategyBuilder;
import com.linecorp.armeria.client.endpoint.WeightedRoundRobinStrategy;
import java.util.function.ToLongFunction;

@FunctionalInterface
public interface EndpointSelectionStrategy {
    public static EndpointSelectionStrategy weightedRoundRobin() {
        return WeightedRoundRobinStrategy.INSTANCE;
    }

    public static EndpointSelectionStrategy roundRobin() {
        return RoundRobinStrategy.INSTANCE;
    }

    public static EndpointSelectionStrategy rampingUp() {
        return WeightRampingUpStrategy.INSTANCE;
    }

    public static WeightRampingUpStrategyBuilder builderForRampingUp() {
        return new WeightRampingUpStrategyBuilder();
    }

    public static EndpointSelectionStrategy sticky(ToLongFunction<? super ClientRequestContext> requestContextHasher) {
        return new StickyEndpointSelectionStrategy(requestContextHasher);
    }

    public EndpointSelector newSelector(EndpointGroup var1);
}

