/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.ResponseTimeoutException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseCompleteException;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.stream.AbstractStreamWriter;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.StreamWriter;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.client.ClientRequestContextExtension;
import com.linecorp.armeria.internal.client.DecodedHttpResponse;
import com.linecorp.armeria.internal.client.HttpSession;
import com.linecorp.armeria.internal.common.CancellationScheduler;
import com.linecorp.armeria.internal.common.InboundTrafficController;
import com.linecorp.armeria.internal.common.KeepAliveHandler;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.EventExecutor;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HttpResponseDecoder {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseDecoder.class);
    private final IntObjectMap<HttpResponseWrapper> responses = new IntObjectHashMap();
    private final Channel channel;
    private final InboundTrafficController inboundTrafficController;
    @Nullable
    private HttpSession httpSession;
    private int unfinishedResponses;
    private boolean closing;

    HttpResponseDecoder(Channel channel, InboundTrafficController inboundTrafficController) {
        this.channel = channel;
        this.inboundTrafficController = inboundTrafficController;
    }

    final Channel channel() {
        return this.channel;
    }

    final InboundTrafficController inboundTrafficController() {
        return this.inboundTrafficController;
    }

    HttpResponseWrapper addResponse(int id, DecodedHttpResponse res, @Nullable ClientRequestContext ctx, EventLoop eventLoop, long responseTimeoutMillis, long maxContentLength) {
        HttpResponseWrapper newRes = new HttpResponseWrapper(res, ctx, responseTimeoutMillis, maxContentLength);
        HttpResponseWrapper oldRes = (HttpResponseWrapper)this.responses.put(id, (Object)newRes);
        KeepAliveHandler keepAliveHandler = this.keepAliveHandler();
        if (keepAliveHandler != null) {
            keepAliveHandler.increaseNumRequests();
        }
        assert (oldRes == null) : "addResponse(" + id + ", " + res + ", " + responseTimeoutMillis + "): " + oldRes;
        return newRes;
    }

    @Nullable
    final HttpResponseWrapper getResponse(int id) {
        return (HttpResponseWrapper)this.responses.get(id);
    }

    @Nullable
    final HttpResponseWrapper removeResponse(int id) {
        if (this.closing) {
            return null;
        }
        HttpResponseWrapper removed = (HttpResponseWrapper)this.responses.remove(id);
        if (removed != null) {
            --this.unfinishedResponses;
            assert (this.unfinishedResponses >= 0) : this.unfinishedResponses;
        }
        return removed;
    }

    final boolean hasUnfinishedResponses() {
        return this.unfinishedResponses != 0;
    }

    final boolean reserveUnfinishedResponse(int maxUnfinishedResponses) {
        if (this.unfinishedResponses >= maxUnfinishedResponses) {
            return false;
        }
        ++this.unfinishedResponses;
        return true;
    }

    final void decrementUnfinishedResponses() {
        --this.unfinishedResponses;
    }

    final void failUnfinishedResponses(Throwable cause) {
        if (this.closing) {
            return;
        }
        this.closing = true;
        Iterator iterator = this.responses.values().iterator();
        while (iterator.hasNext()) {
            HttpResponseWrapper res = (HttpResponseWrapper)iterator.next();
            iterator.remove();
            --this.unfinishedResponses;
            res.close(cause);
        }
    }

    HttpSession session() {
        if (this.httpSession != null) {
            return this.httpSession;
        }
        this.httpSession = HttpSession.get(this.channel);
        return this.httpSession;
    }

    @Nullable
    abstract KeepAliveHandler keepAliveHandler();

    final boolean needsToDisconnectNow() {
        return !this.session().isAcquirable() && !this.hasUnfinishedResponses();
    }

    static final class HttpResponseWrapper
    implements StreamWriter<HttpObject> {
        private final DecodedHttpResponse delegate;
        @Nullable
        private final ClientRequestContext ctx;
        private final long maxContentLength;
        private final long responseTimeoutMillis;
        private boolean loggedResponseFirstBytesTransferred;
        private State state = State.WAIT_NON_INFORMATIONAL;
        @Nullable
        private ResponseHeaders headers;

        HttpResponseWrapper(DecodedHttpResponse delegate, @Nullable ClientRequestContext ctx, long responseTimeoutMillis, long maxContentLength) {
            this.delegate = delegate;
            this.ctx = ctx;
            this.maxContentLength = maxContentLength;
            this.responseTimeoutMillis = responseTimeoutMillis;
        }

        long maxContentLength() {
            return this.maxContentLength;
        }

        long writtenBytes() {
            return this.delegate.writtenBytes();
        }

        ResponseHeaders headers() {
            assert (this.headers != null);
            return this.headers;
        }

        void logResponseFirstBytesTransferred() {
            if (!this.loggedResponseFirstBytesTransferred) {
                if (this.ctx != null) {
                    this.ctx.logBuilder().responseFirstBytesTransferred();
                }
                this.loggedResponseFirstBytesTransferred = true;
            }
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long demand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> whenComplete() {
            return this.delegate.whenComplete();
        }

        @Override
        public void subscribe(Subscriber<? super HttpObject> subscriber, EventExecutor executor, SubscriptionOption ... options) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void abort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void abort(Throwable cause) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryWrite(HttpObject o) {
            boolean wrote = false;
            switch (this.state) {
                case WAIT_NON_INFORMATIONAL: {
                    wrote = this.handleWaitNonInformational(o);
                    break;
                }
                case WAIT_DATA_OR_TRAILERS: {
                    wrote = this.handleWaitDataOrTrailers(o);
                    break;
                }
                case DONE: {
                    PooledObjects.close(o);
                }
            }
            return wrote;
        }

        @Override
        public boolean tryWrite(Supplier<? extends HttpObject> o) {
            return ((AbstractStreamWriter)this.delegate).tryWrite(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handleWaitNonInformational(HttpObject o) {
            ResponseHeaders headers;
            HttpStatus status;
            if (this.ctx != null) {
                this.ctx.logBuilder().startResponse();
            }
            assert (o instanceof HttpHeaders && !(o instanceof RequestHeaders)) : o;
            if (o instanceof ResponseHeaders && !(status = (headers = (ResponseHeaders)o).status()).isInformational()) {
                this.headers = headers;
                this.state = State.WAIT_DATA_OR_TRAILERS;
                if (this.ctx != null) {
                    this.ctx.logBuilder().defer(RequestLogProperty.RESPONSE_HEADERS);
                    try {
                        boolean bl = this.delegate.tryWrite(headers);
                        return bl;
                    }
                    finally {
                        this.ctx.logBuilder().responseHeaders(headers);
                    }
                }
            }
            return this.delegate.tryWrite(o);
        }

        private boolean handleWaitDataOrTrailers(HttpObject o) {
            if (o instanceof HttpHeaders) {
                this.state = State.DONE;
                if (this.ctx != null) {
                    this.ctx.logBuilder().defer(RequestLogProperty.RESPONSE_TRAILERS);
                    try {
                        boolean bl = this.delegate.tryWrite(o);
                        return bl;
                    }
                    finally {
                        this.ctx.logBuilder().responseTrailers((HttpHeaders)o);
                    }
                }
            } else {
                HttpData data = (HttpData)o;
                data.touch(this.ctx);
                if (this.ctx != null) {
                    this.ctx.logBuilder().increaseResponseLength(data);
                }
            }
            return this.delegate.tryWrite(o);
        }

        @Override
        public CompletableFuture<Void> whenConsumed() {
            return this.delegate.whenConsumed();
        }

        void onSubscriptionCancelled(@Nullable Throwable cause) {
            this.close(cause, true);
        }

        @Override
        public void close() {
            this.close(null, false);
        }

        @Override
        public void close(Throwable cause) {
            this.close(cause, false);
        }

        private void close(@Nullable Throwable cause, boolean cancel) {
            this.state = State.DONE;
            this.cancelTimeoutOrLog(cause, cancel);
            if (this.ctx != null) {
                if (cause == null) {
                    this.ctx.request().abort(ResponseCompleteException.get());
                } else {
                    this.ctx.request().abort(cause);
                }
            }
        }

        private void closeAction(@Nullable Throwable cause) {
            if (cause != null) {
                this.delegate.close(cause);
                if (this.ctx != null) {
                    this.ctx.logBuilder().endResponse(cause);
                }
            } else {
                this.delegate.close();
                if (this.ctx != null) {
                    this.ctx.logBuilder().endResponse();
                }
            }
        }

        private void cancelAction(@Nullable Throwable cause) {
            if (cause != null && !(cause instanceof CancelledSubscriptionException)) {
                if (this.ctx != null) {
                    this.ctx.logBuilder().endResponse(cause);
                }
            } else if (this.ctx != null) {
                this.ctx.logBuilder().endResponse();
            }
        }

        private void cancelTimeoutOrLog(@Nullable Throwable cause, boolean cancel) {
            String authority;
            ClientRequestContextExtension ctxExtension;
            CancellationScheduler responseCancellationScheduler = null;
            if (this.ctx != null && (ctxExtension = this.ctx.as(ClientRequestContextExtension.class)) != null) {
                responseCancellationScheduler = ctxExtension.responseCancellationScheduler();
            }
            if (responseCancellationScheduler == null || !responseCancellationScheduler.isFinished()) {
                if (responseCancellationScheduler != null) {
                    responseCancellationScheduler.clearTimeout(false);
                }
                if (cancel) {
                    this.cancelAction(cause);
                } else {
                    this.closeAction(cause);
                }
                return;
            }
            if (this.delegate.isOpen()) {
                this.closeAction(cause);
            }
            if (cause instanceof ResponseTimeoutException) {
                return;
            }
            if (cause == null || !logger.isWarnEnabled() || Exceptions.isExpected(cause)) {
                return;
            }
            StringBuilder logMsg = new StringBuilder("Unexpected exception while closing a request");
            if (this.ctx != null && (authority = this.ctx.request().authority()) != null) {
                logMsg.append(" to ").append(authority);
            }
            logger.warn(logMsg.append(':').toString(), cause);
        }

        void initTimeout() {
            if (this.ctx == null) {
                return;
            }
            ClientRequestContextExtension ctxExtension = this.ctx.as(ClientRequestContextExtension.class);
            if (ctxExtension != null) {
                CancellationScheduler responseCancellationScheduler = ctxExtension.responseCancellationScheduler();
                responseCancellationScheduler.init((EventExecutor)this.ctx.eventLoop(), this.newCancellationTask(), TimeUnit.MILLISECONDS.toNanos(this.responseTimeoutMillis), false);
            }
        }

        private CancellationScheduler.CancellationTask newCancellationTask() {
            return new CancellationScheduler.CancellationTask(){

                @Override
                public boolean canSchedule() {
                    return delegate.isOpen() && state != State.DONE;
                }

                @Override
                public void run(Throwable cause) {
                    assert (ctx != null);
                    delegate.close(cause);
                    ctx.request().abort(cause);
                    ctx.logBuilder().endResponse(cause);
                }
            };
        }

        public String toString() {
            return this.delegate.toString();
        }

        static enum State {
            WAIT_NON_INFORMATIONAL,
            WAIT_DATA_OR_TRAILERS,
            DONE;

        }
    }
}

