/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpChannelPool;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.endpoint.EmptyEndpointGroupException;
import com.linecorp.armeria.client.proxy.HAProxyConfig;
import com.linecorp.armeria.client.proxy.ProxyConfig;
import com.linecorp.armeria.client.proxy.ProxyType;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.ClientConnectionTimings;
import com.linecorp.armeria.common.logging.ClientConnectionTimingsBuilder;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.client.ClientPendingThrowableUtil;
import com.linecorp.armeria.internal.client.DecodedHttpResponse;
import com.linecorp.armeria.internal.client.HttpSession;
import com.linecorp.armeria.internal.client.PooledChannel;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiConsumer;

final class HttpClientDelegate
implements HttpClient {
    private final HttpClientFactory factory;
    private final AddressResolverGroup<InetSocketAddress> addressResolverGroup;

    HttpClientDelegate(HttpClientFactory factory, AddressResolverGroup<InetSocketAddress> addressResolverGroup) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.addressResolverGroup = Objects.requireNonNull(addressResolverGroup, "addressResolverGroup");
    }

    @Override
    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        ProxyConfig proxyConfig;
        Throwable throwable = ClientPendingThrowableUtil.pendingThrowable(ctx);
        if (throwable != null) {
            return HttpClientDelegate.earlyFailedResponse(throwable, ctx, req);
        }
        if (req != ctx.request()) {
            return HttpClientDelegate.earlyFailedResponse(new IllegalStateException("ctx.request() does not match the actual request; did you forget to call ctx.updateRequest() in your decorator?"), ctx, req);
        }
        Endpoint endpoint = ctx.endpoint();
        if (endpoint == null) {
            return HttpClientDelegate.earlyFailedResponse(EmptyEndpointGroupException.get(ctx.endpointGroup()), ctx, req);
        }
        SessionProtocol protocol = ctx.sessionProtocol();
        try {
            proxyConfig = this.getProxyConfig(protocol, endpoint);
        }
        catch (Throwable t) {
            UnprocessedRequestException wrapped = UnprocessedRequestException.of(t);
            HttpClientDelegate.handleEarlyRequestException(ctx, req, wrapped);
            return HttpResponse.ofFailure(wrapped);
        }
        Endpoint endpointWithPort = endpoint.withDefaultPort(ctx.sessionProtocol().defaultPort());
        EventLoop eventLoop = ctx.eventLoop().withoutContext();
        DecodedHttpResponse res = new DecodedHttpResponse(eventLoop);
        ClientConnectionTimingsBuilder timingsBuilder = ClientConnectionTimings.builder();
        if (endpointWithPort.hasIpAddr() || proxyConfig.proxyType().isForwardProxy()) {
            this.acquireConnectionAndExecute(ctx, endpointWithPort, req, res, timingsBuilder, proxyConfig);
        } else {
            this.resolveAddress(endpointWithPort, ctx, (resolved, cause) -> {
                timingsBuilder.dnsResolutionEnd();
                if (cause == null) {
                    assert (resolved != null);
                    this.acquireConnectionAndExecute(ctx, (Endpoint)resolved, req, res, timingsBuilder, proxyConfig);
                } else {
                    ctx.logBuilder().session(null, ctx.sessionProtocol(), timingsBuilder.build());
                    UnprocessedRequestException wrappedCause = UnprocessedRequestException.of(cause);
                    HttpClientDelegate.handleEarlyRequestException(ctx, req, wrappedCause);
                    res.close(wrappedCause);
                }
            });
        }
        return res;
    }

    private void resolveAddress(Endpoint endpoint, ClientRequestContext ctx, BiConsumer<@Nullable Endpoint, @Nullable Throwable> onComplete) {
        assert (!endpoint.hasIpAddr() && endpoint.hasPort());
        Future resolveFuture = this.addressResolverGroup.getResolver((EventExecutor)ctx.eventLoop().withoutContext()).resolve((SocketAddress)InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port()));
        if (resolveFuture.isSuccess()) {
            InetAddress address = ((InetSocketAddress)resolveFuture.getNow()).getAddress();
            onComplete.accept(endpoint.withInetAddress(address), null);
        } else {
            resolveFuture.addListener(future -> {
                if (future.isSuccess()) {
                    InetAddress address = ((InetSocketAddress)resolveFuture.getNow()).getAddress();
                    onComplete.accept(endpoint.withInetAddress(address), null);
                } else {
                    onComplete.accept(null, resolveFuture.cause());
                }
            });
        }
    }

    private void acquireConnectionAndExecute(ClientRequestContext ctx, Endpoint endpoint, HttpRequest req, DecodedHttpResponse res, ClientConnectionTimingsBuilder timingsBuilder, ProxyConfig proxyConfig) {
        if (ctx.eventLoop().inEventLoop()) {
            this.acquireConnectionAndExecute0(ctx, endpoint, req, res, timingsBuilder, proxyConfig);
        } else {
            ctx.eventLoop().execute(() -> this.acquireConnectionAndExecute0(ctx, endpoint, req, res, timingsBuilder, proxyConfig));
        }
    }

    private void acquireConnectionAndExecute0(ClientRequestContext ctx, Endpoint endpoint, HttpRequest req, DecodedHttpResponse res, ClientConnectionTimingsBuilder timingsBuilder, ProxyConfig proxyConfig) {
        String ipAddr = endpoint.ipAddr();
        SessionProtocol protocol = ctx.sessionProtocol();
        HttpChannelPool.PoolKey key = new HttpChannelPool.PoolKey(endpoint.host(), ipAddr, endpoint.port(), proxyConfig);
        HttpChannelPool pool = this.factory.pool(ctx.eventLoop().withoutContext());
        PooledChannel pooledChannel = pool.acquireNow(protocol, key);
        if (pooledChannel != null) {
            HttpClientDelegate.logSession(ctx, pooledChannel, null);
            HttpClientDelegate.doExecute(pooledChannel, ctx, req, res);
        } else {
            pool.acquireLater(protocol, key, timingsBuilder).handle((newPooledChannel, cause) -> {
                HttpClientDelegate.logSession(ctx, newPooledChannel, timingsBuilder.build());
                if (cause == null) {
                    HttpClientDelegate.doExecute(newPooledChannel, ctx, req, res);
                } else {
                    UnprocessedRequestException wrapped = UnprocessedRequestException.of(cause);
                    HttpClientDelegate.handleEarlyRequestException(ctx, req, wrapped);
                    res.close(wrapped);
                }
                return null;
            });
        }
    }

    private ProxyConfig getProxyConfig(SessionProtocol protocol, Endpoint endpoint) {
        ProxyConfig proxyConfig = this.factory.proxyConfigSelector().select(protocol, endpoint);
        Objects.requireNonNull(proxyConfig, "proxyConfig");
        if (proxyConfig.proxyType() == ProxyType.HAPROXY && ((HAProxyConfig)proxyConfig).sourceAddress() == null) {
            InetSocketAddress proxyAddress = proxyConfig.proxyAddress();
            assert (proxyAddress != null);
            ServiceRequestContext serviceCtx = ServiceRequestContext.currentOrNull();
            if (serviceCtx != null) {
                ProxiedAddresses proxiedAddresses = serviceCtx.proxiedAddresses();
                return ProxyConfig.haproxy(proxyAddress, proxiedAddresses.sourceAddress());
            }
        }
        return proxyConfig;
    }

    private static void logSession(ClientRequestContext ctx, @Nullable PooledChannel pooledChannel, @Nullable ClientConnectionTimings connectionTimings) {
        if (pooledChannel != null) {
            Channel channel = pooledChannel.get();
            SessionProtocol actualProtocol = pooledChannel.protocol();
            ctx.logBuilder().session(channel, actualProtocol, connectionTimings);
        } else {
            ctx.logBuilder().session(null, ctx.sessionProtocol(), connectionTimings);
        }
    }

    private static HttpResponse earlyFailedResponse(Throwable t, ClientRequestContext ctx, HttpRequest req) {
        UnprocessedRequestException cause = UnprocessedRequestException.of(t);
        HttpClientDelegate.handleEarlyRequestException(ctx, req, cause);
        return HttpResponse.ofFailure(cause);
    }

    private static void handleEarlyRequestException(ClientRequestContext ctx, HttpRequest req, Throwable cause) {
        try (SafeCloseable ignored = RequestContextUtil.pop();){
            req.abort(cause);
            RequestLogBuilder logBuilder = ctx.logBuilder();
            logBuilder.endRequest(cause);
            logBuilder.endResponse(cause);
        }
    }

    private static void doExecute(PooledChannel pooledChannel, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        Channel channel = pooledChannel.get();
        HttpSession session = HttpSession.get(channel);
        res.init(session.inboundTrafficController());
        session.invoke(pooledChannel, ctx, req, res);
    }
}

