/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ConnectionPoolListener;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HAProxyHandler;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.HttpClientPipelineConfigurator;
import com.linecorp.armeria.client.HttpSessionHandler;
import com.linecorp.armeria.client.RefusedStreamException;
import com.linecorp.armeria.client.SessionProtocolNegotiationCache;
import com.linecorp.armeria.client.SessionProtocolNegotiationException;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.proxy.ConnectProxyConfig;
import com.linecorp.armeria.client.proxy.HAProxyConfig;
import com.linecorp.armeria.client.proxy.ProxyConfig;
import com.linecorp.armeria.client.proxy.ProxyConfigSelector;
import com.linecorp.armeria.client.proxy.ProxyType;
import com.linecorp.armeria.client.proxy.Socks4ProxyConfig;
import com.linecorp.armeria.client.proxy.Socks5ProxyConfig;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.ClientConnectionTimingsBuilder;
import com.linecorp.armeria.common.util.AsyncCloseable;
import com.linecorp.armeria.common.util.AsyncCloseableSupport;
import com.linecorp.armeria.internal.client.HttpSession;
import com.linecorp.armeria.internal.client.PooledChannel;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyConnectException;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.AttributeMap;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.scheduler.NonBlocking;

final class HttpChannelPool
implements AsyncCloseable {
    private static final Logger logger = LoggerFactory.getLogger(HttpChannelPool.class);
    private static final Channel[] EMPTY_CHANNELS = new Channel[0];
    private final HttpClientFactory clientFactory;
    private final EventLoop eventLoop;
    private final AsyncCloseableSupport closeable = AsyncCloseableSupport.of(this::closeAsync);
    private final Map<PoolKey, Deque<PooledChannel>>[] pool;
    private final Map<PoolKey, ChannelAcquisitionFuture>[] pendingAcquisitions;
    private final Map<Channel, Boolean> allChannels;
    private final ConnectionPoolListener listener;
    private final Bootstrap[] bootstraps;
    private final int connectTimeoutMillis;
    private final SslContext sslCtxHttp1Or2;
    private final SslContext sslCtxHttp1Only;

    HttpChannelPool(final HttpClientFactory clientFactory, EventLoop eventLoop, SslContext sslCtxHttp1Or2, SslContext sslCtxHttp1Only, ConnectionPoolListener listener) {
        this.clientFactory = clientFactory;
        this.eventLoop = eventLoop;
        this.pool = HttpChannelPool.newEnumMap(Map.class, unused -> new HashMap(), SessionProtocol.H1, SessionProtocol.H1C, SessionProtocol.H2, SessionProtocol.H2C);
        this.pendingAcquisitions = HttpChannelPool.newEnumMap(Map.class, unused -> new HashMap(), SessionProtocol.HTTP, SessionProtocol.HTTPS, SessionProtocol.H1, SessionProtocol.H1C, SessionProtocol.H2, SessionProtocol.H2C);
        this.allChannels = new IdentityHashMap<Channel, Boolean>();
        this.listener = listener;
        this.sslCtxHttp1Only = sslCtxHttp1Only;
        this.sslCtxHttp1Or2 = sslCtxHttp1Or2;
        Bootstrap baseBootstrap = clientFactory.newBootstrap();
        baseBootstrap.group((EventLoopGroup)eventLoop);
        this.bootstraps = HttpChannelPool.newEnumMap(Bootstrap.class, desiredProtocol -> {
            final SslContext sslCtx = this.determineSslContext((SessionProtocol)((Object)desiredProtocol));
            Bootstrap bootstrap = baseBootstrap.clone();
            bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpClientPipelineConfigurator(clientFactory, desiredProtocol, sslCtx)});
                }
            });
            return bootstrap;
        }, SessionProtocol.HTTP, SessionProtocol.HTTPS, SessionProtocol.H1, SessionProtocol.H1C, SessionProtocol.H2, SessionProtocol.H2C);
        this.connectTimeoutMillis = (Integer)baseBootstrap.config().options().get(ChannelOption.CONNECT_TIMEOUT_MILLIS);
    }

    private SslContext determineSslContext(SessionProtocol desiredProtocol) {
        return desiredProtocol == SessionProtocol.H1 || desiredProtocol == SessionProtocol.H1C ? this.sslCtxHttp1Only : this.sslCtxHttp1Or2;
    }

    private void configureProxy(Channel ch, ProxyConfig proxyConfig, SessionProtocol desiredProtocol) {
        Socks4ProxyHandler proxyHandler;
        if (proxyConfig.proxyType() == ProxyType.DIRECT) {
            return;
        }
        InetSocketAddress proxyAddress = proxyConfig.proxyAddress();
        assert (proxyAddress != null);
        switch (proxyConfig.proxyType()) {
            case SOCKS4: {
                Socks4ProxyConfig socks4ProxyConfig = (Socks4ProxyConfig)proxyConfig;
                proxyHandler = new Socks4ProxyHandler((SocketAddress)proxyAddress, socks4ProxyConfig.username());
                break;
            }
            case SOCKS5: {
                Socks5ProxyConfig socks5ProxyConfig = (Socks5ProxyConfig)proxyConfig;
                proxyHandler = new Socks5ProxyHandler((SocketAddress)proxyAddress, socks5ProxyConfig.username(), socks5ProxyConfig.password());
                break;
            }
            case CONNECT: {
                ConnectProxyConfig connectProxyConfig = (ConnectProxyConfig)proxyConfig;
                String username = connectProxyConfig.username();
                String password = connectProxyConfig.password();
                if (username == null || password == null) {
                    proxyHandler = new HttpProxyHandler((SocketAddress)proxyAddress);
                    break;
                }
                proxyHandler = new HttpProxyHandler((SocketAddress)proxyAddress, username, password);
                break;
            }
            case HAPROXY: {
                ch.pipeline().addFirst(new ChannelHandler[]{new HAProxyHandler((HAProxyConfig)proxyConfig)});
                return;
            }
            default: {
                throw new Error();
            }
        }
        proxyHandler.setConnectTimeoutMillis((long)this.connectTimeoutMillis);
        ch.pipeline().addFirst(new ChannelHandler[]{proxyHandler});
        if (proxyConfig instanceof ConnectProxyConfig && ((ConnectProxyConfig)proxyConfig).useTls()) {
            SslContext sslCtx = this.determineSslContext(desiredProtocol);
            ch.pipeline().addFirst(new ChannelHandler[]{sslCtx.newHandler(ch.alloc())});
        }
    }

    private static <T> T[] newEnumMap(Class<?> elementType, Function<SessionProtocol, T> factory, SessionProtocol ... allowedProtocols) {
        Object[] maps = (Object[])Array.newInstance(elementType, SessionProtocol.values().length);
        for (SessionProtocol p : allowedProtocols) {
            maps[p.ordinal()] = factory.apply(p);
        }
        return maps;
    }

    private Bootstrap getBootstrap(SessionProtocol desiredProtocol) {
        return this.bootstraps[desiredProtocol.ordinal()];
    }

    @Nullable
    private Deque<PooledChannel> getPool(SessionProtocol protocol, PoolKey key) {
        return this.pool[protocol.ordinal()].get(key);
    }

    private Deque<PooledChannel> getOrCreatePool(SessionProtocol protocol, PoolKey key) {
        return this.pool[protocol.ordinal()].computeIfAbsent(key, k -> new ArrayDeque());
    }

    @Nullable
    private ChannelAcquisitionFuture getPendingAcquisition(SessionProtocol desiredProtocol, PoolKey key) {
        return this.pendingAcquisitions[desiredProtocol.ordinal()].get(key);
    }

    private void setPendingAcquisition(SessionProtocol desiredProtocol, PoolKey key, ChannelAcquisitionFuture future) {
        this.pendingAcquisitions[desiredProtocol.ordinal()].put(key, future);
    }

    private void removePendingAcquisition(SessionProtocol desiredProtocol, PoolKey key) {
        this.pendingAcquisitions[desiredProtocol.ordinal()].remove(key);
    }

    @Nullable
    PooledChannel acquireNow(SessionProtocol desiredProtocol, PoolKey key) {
        PooledChannel ch;
        switch (desiredProtocol) {
            case HTTP: {
                ch = this.acquireNowExact(key, SessionProtocol.H2C);
                if (ch != null) break;
                ch = this.acquireNowExact(key, SessionProtocol.H1C);
                break;
            }
            case HTTPS: {
                ch = this.acquireNowExact(key, SessionProtocol.H2);
                if (ch != null) break;
                ch = this.acquireNowExact(key, SessionProtocol.H1);
                break;
            }
            default: {
                ch = this.acquireNowExact(key, desiredProtocol);
            }
        }
        return ch;
    }

    @Nullable
    private PooledChannel acquireNowExact(PoolKey key, SessionProtocol protocol) {
        Deque<PooledChannel> queue = this.getPool(protocol, key);
        if (queue == null) {
            return null;
        }
        for (int i = queue.size(); i > 0; --i) {
            PooledChannel pooledChannel = queue.peekLast();
            assert (pooledChannel != null);
            if (!HttpChannelPool.isHealthy(pooledChannel)) {
                queue.removeLast();
                continue;
            }
            HttpSession session = HttpSession.get(pooledChannel.get());
            if (!session.incrementNumUnfinishedResponses()) {
                queue.removeLast();
                queue.addFirst(pooledChannel);
                continue;
            }
            if (!protocol.isMultiplex()) {
                queue.removeLast();
            }
            return pooledChannel;
        }
        return null;
    }

    private static boolean isHealthy(PooledChannel pooledChannel) {
        Channel ch = pooledChannel.get();
        return ch.isActive() && HttpSession.get(ch).isAcquirable();
    }

    @Nullable
    private static SessionProtocol getProtocolIfHealthy(Channel ch) {
        if (!ch.isActive()) {
            return null;
        }
        return HttpSession.get(ch).protocol();
    }

    CompletableFuture<PooledChannel> acquireLater(SessionProtocol desiredProtocol, PoolKey key, ClientConnectionTimingsBuilder timingsBuilder) {
        ChannelAcquisitionFuture promise = new ChannelAcquisitionFuture();
        if (!this.usePendingAcquisition(desiredProtocol, key, promise, timingsBuilder)) {
            this.connect(desiredProtocol, key, promise, timingsBuilder);
        }
        return promise;
    }

    private boolean usePendingAcquisition(SessionProtocol desiredProtocol, PoolKey key, ChannelAcquisitionFuture promise, ClientConnectionTimingsBuilder timingsBuilder) {
        if (desiredProtocol == SessionProtocol.H1 || desiredProtocol == SessionProtocol.H1C) {
            return false;
        }
        ChannelAcquisitionFuture pendingAcquisition = this.getPendingAcquisition(desiredProtocol, key);
        if (pendingAcquisition == null) {
            return false;
        }
        timingsBuilder.pendingAcquisitionStart();
        pendingAcquisition.piggyback(desiredProtocol, key, promise, timingsBuilder);
        return true;
    }

    private void connect(SessionProtocol desiredProtocol, PoolKey key, ChannelAcquisitionFuture promise, ClientConnectionTimingsBuilder timingsBuilder) {
        InetSocketAddress remoteAddress;
        this.setPendingAcquisition(desiredProtocol, key, promise);
        timingsBuilder.socketConnectStart();
        try {
            remoteAddress = key.toRemoteAddress();
        }
        catch (UnknownHostException e) {
            this.notifyConnect(desiredProtocol, key, (Future<Channel>)this.eventLoop.newFailedFuture((Throwable)e), promise, timingsBuilder);
            return;
        }
        if (SessionProtocolNegotiationCache.isUnsupported(remoteAddress, desiredProtocol)) {
            this.notifyConnect(desiredProtocol, key, (Future<Channel>)this.eventLoop.newFailedFuture((Throwable)new SessionProtocolNegotiationException(desiredProtocol, "previously failed negotiation")), promise, timingsBuilder);
            return;
        }
        Promise sessionPromise = this.eventLoop.newPromise();
        this.connect(remoteAddress, desiredProtocol, key, (Promise<Channel>)sessionPromise);
        if (sessionPromise.isDone()) {
            this.notifyConnect(desiredProtocol, key, (Future<Channel>)sessionPromise, promise, timingsBuilder);
        } else {
            sessionPromise.addListener(future -> this.notifyConnect(desiredProtocol, key, (Future<Channel>)future, promise, timingsBuilder));
        }
    }

    void connect(SocketAddress remoteAddress, SessionProtocol desiredProtocol, PoolKey poolKey, Promise<Channel> sessionPromise) {
        Bootstrap bootstrap = this.getBootstrap(desiredProtocol);
        bootstrap.register().addListener(registerFuture -> {
            if (!registerFuture.isSuccess()) {
                sessionPromise.tryFailure(registerFuture.cause());
                return;
            }
            try {
                Channel channel = registerFuture.channel();
                this.configureProxy(channel, poolKey.proxyConfig, desiredProtocol);
                this.clientFactory.channelPipelineCustomizer().accept((ChannelPipeline)channel.pipeline());
                channel.connect(remoteAddress).addListener(connectFuture -> {
                    if (connectFuture.isSuccess()) {
                        this.initSession(desiredProtocol, poolKey, (ChannelFuture)connectFuture, sessionPromise);
                    } else {
                        this.maybeHandleProxyFailure(desiredProtocol, poolKey, connectFuture.cause());
                        sessionPromise.tryFailure(connectFuture.cause());
                    }
                });
            }
            catch (Throwable cause) {
                this.maybeHandleProxyFailure(desiredProtocol, poolKey, cause);
                sessionPromise.tryFailure(cause);
            }
        });
    }

    int numConnections() {
        return this.allChannels.size();
    }

    void maybeHandleProxyFailure(SessionProtocol protocol, PoolKey poolKey, Throwable cause) {
        try {
            ProxyConfig proxyConfig = poolKey.proxyConfig;
            if (proxyConfig.proxyType() != ProxyType.DIRECT) {
                InetSocketAddress proxyAddress = proxyConfig.proxyAddress();
                assert (proxyAddress != null);
                ProxyConfigSelector proxyConfigSelector = this.clientFactory.proxyConfigSelector();
                proxyConfigSelector.connectFailed(protocol, Endpoint.unsafeCreate(poolKey.host, poolKey.port), proxyAddress, UnprocessedRequestException.of(cause));
            }
        }
        catch (Throwable t) {
            logger.warn("Exception while invoking {}.connectFailed() for {}", new Object[]{ProxyConfigSelector.class.getSimpleName(), poolKey, t});
        }
    }

    private void initSession(SessionProtocol desiredProtocol, PoolKey poolKey, ChannelFuture connectFuture, Promise<Channel> sessionPromise) {
        assert (connectFuture.isSuccess());
        Channel ch = connectFuture.channel();
        EventLoop eventLoop = ch.eventLoop();
        assert (eventLoop.inEventLoop());
        io.netty.util.concurrent.ScheduledFuture timeoutFuture = eventLoop.schedule(() -> {
            if (sessionPromise.tryFailure((Throwable)new SessionProtocolNegotiationException(desiredProtocol, "connection established, but session creation timed out: " + ch))) {
                ch.close();
            }
        }, (long)this.connectTimeoutMillis, TimeUnit.MILLISECONDS);
        ch.pipeline().addLast(new ChannelHandler[]{new HttpSessionHandler(this, ch, sessionPromise, (ScheduledFuture<?>)timeoutFuture, desiredProtocol, poolKey, this.clientFactory)});
    }

    private void notifyConnect(SessionProtocol desiredProtocol, PoolKey key, Future<Channel> future, ChannelAcquisitionFuture promise, ClientConnectionTimingsBuilder timingsBuilder) {
        block13: {
            assert (future.isDone());
            this.removePendingAcquisition(desiredProtocol, key);
            timingsBuilder.socketConnectEnd();
            try {
                if (future.isSuccess()) {
                    SessionProtocol protocol;
                    Channel channel;
                    block12: {
                        channel = (Channel)future.getNow();
                        protocol = HttpChannelPool.getProtocolIfHealthy(channel);
                        if (protocol == null || this.closeable.isClosing()) {
                            channel.close();
                            promise.completeExceptionally(UnprocessedRequestException.of(new ClosedSessionException("acquired an unhealthy connection")));
                            return;
                        }
                        this.allChannels.put(channel, Boolean.TRUE);
                        try {
                            this.listener.connectionOpen(protocol, (InetSocketAddress)channel.remoteAddress(), (InetSocketAddress)channel.localAddress(), (AttributeMap)channel);
                        }
                        catch (Exception e) {
                            if (!logger.isWarnEnabled()) break block12;
                            logger.warn("{} Exception handling {}.connectionOpen()", new Object[]{channel, this.listener.getClass().getName(), e});
                        }
                    }
                    HttpSession session = HttpSession.get(channel);
                    if (session.incrementNumUnfinishedResponses()) {
                        if (protocol.isMultiplex()) {
                            Http2PooledChannel pooledChannel = new Http2PooledChannel(channel, protocol);
                            this.addToPool(protocol, key, pooledChannel);
                            promise.complete(pooledChannel);
                        } else {
                            promise.complete(new Http1PooledChannel(channel, protocol, key));
                        }
                    } else {
                        channel.close();
                        promise.completeExceptionally(UnprocessedRequestException.of(RefusedStreamException.get()));
                    }
                    channel.closeFuture().addListener(f -> {
                        block4: {
                            this.allChannels.remove(channel);
                            Deque<PooledChannel> queue = this.getPool(protocol, key);
                            if (queue != null) {
                                PooledChannel pooledChannel;
                                while ((pooledChannel = queue.peekFirst()) != null && !HttpChannelPool.isHealthy(pooledChannel)) {
                                    queue.removeFirst();
                                }
                            }
                            try {
                                this.listener.connectionClosed(protocol, (InetSocketAddress)channel.remoteAddress(), (InetSocketAddress)channel.localAddress(), (AttributeMap)channel);
                            }
                            catch (Exception e) {
                                if (!logger.isWarnEnabled()) break block4;
                                logger.warn("{} Exception handling {}.connectionClosed()", new Object[]{channel, this.listener.getClass().getName(), e});
                            }
                        }
                    });
                    break block13;
                }
                Throwable throwable = future.cause();
                if (throwable instanceof ProxyConnectException) {
                    this.maybeHandleProxyFailure(desiredProtocol, key, throwable);
                }
                promise.completeExceptionally(UnprocessedRequestException.of(throwable));
            }
            catch (Exception e) {
                promise.completeExceptionally(UnprocessedRequestException.of(e));
            }
        }
    }

    private void addToPool(SessionProtocol actualProtocol, PoolKey key, PooledChannel pooledChannel) {
        assert (this.eventLoop.inEventLoop()) : Thread.currentThread().getName();
        this.getOrCreatePool(actualProtocol, key).addLast(pooledChannel);
    }

    @Override
    public CompletableFuture<?> closeAsync() {
        return this.closeable.closeAsync();
    }

    private void closeAsync(final CompletableFuture<?> future) {
        if (!this.eventLoop.inEventLoop()) {
            this.eventLoop.execute(() -> this.closeAsync(future));
            return;
        }
        Channel[] allChannels = this.allChannels.keySet().toArray(EMPTY_CHANNELS);
        final int numAllChannels = allChannels.length;
        if (numAllChannels == 0) {
            future.complete(null);
            return;
        }
        ChannelFutureListener listener = new ChannelFutureListener(){
            private int numRemainingChannels;
            {
                this.numRemainingChannels = numAllChannels;
            }

            public void operationComplete(ChannelFuture unused) throws Exception {
                if (--this.numRemainingChannels <= 0) {
                    future.complete(null);
                }
            }
        };
        for (Channel ch : allChannels) {
            ch.close().addListener((GenericFutureListener)listener);
        }
    }

    @Override
    public void close() {
        if (Thread.currentThread() instanceof NonBlocking) {
            this.closeable.closeAsync();
        } else {
            this.closeable.close();
        }
    }

    static final class PoolKey {
        final String host;
        @Nullable
        final String ipAddr;
        final int port;
        final int hashCode;
        final ProxyConfig proxyConfig;

        PoolKey(String host, @Nullable String ipAddr, int port, ProxyConfig proxyConfig) {
            this.host = host;
            this.ipAddr = ipAddr;
            this.port = port;
            this.proxyConfig = proxyConfig;
            this.hashCode = Objects.hash(host, ipAddr, port, proxyConfig);
        }

        private InetSocketAddress toRemoteAddress() throws UnknownHostException {
            if (this.ipAddr != null) {
                InetAddress inetAddr = InetAddress.getByAddress(this.host, NetUtil.createByteArrayFromIpAddressString((String)this.ipAddr));
                return new InetSocketAddress(inetAddr, this.port);
            }
            assert (this.proxyConfig.proxyType().isForwardProxy());
            return InetSocketAddress.createUnresolved(this.host, this.port);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PoolKey)) {
                return false;
            }
            PoolKey that = (PoolKey)o;
            return Objects.equals(this.ipAddr, that.ipAddr) && this.port == that.port && this.host.equals(that.host) && this.proxyConfig.equals(that.proxyConfig);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("host", this.host).add("ipAddr", this.ipAddr).add("port", this.port).add("proxyConfig", this.proxyConfig).toString();
        }
    }

    private final class ChannelAcquisitionFuture
    extends CompletableFuture<PooledChannel> {
        @Nullable
        private Object pendingPiggybackHandlers;

        private ChannelAcquisitionFuture() {
        }

        void piggyback(SessionProtocol desiredProtocol, PoolKey key, ChannelAcquisitionFuture childPromise, ClientConnectionTimingsBuilder timingsBuilder) {
            if (!this.isDone()) {
                Consumer<PooledChannel> handler = pch -> this.handlePiggyback(desiredProtocol, key, childPromise, timingsBuilder, (PooledChannel)pch);
                if (this.pendingPiggybackHandlers == null) {
                    this.pendingPiggybackHandlers = handler;
                    return;
                }
                if (!(this.pendingPiggybackHandlers instanceof List)) {
                    Consumer firstHandler = (Consumer)this.pendingPiggybackHandlers;
                    ArrayList<Consumer<PooledChannel>> list = new ArrayList<Consumer<PooledChannel>>();
                    list.add(firstHandler);
                    list.add(handler);
                    this.pendingPiggybackHandlers = list;
                    return;
                }
                List list = (List)this.pendingPiggybackHandlers;
                list.add(handler);
                return;
            }
            this.handlePiggyback(desiredProtocol, key, childPromise, timingsBuilder, this.isCompletedExceptionally() ? null : (PooledChannel)this.getNow(null));
        }

        private void handlePiggyback(SessionProtocol desiredProtocol, PoolKey key, ChannelAcquisitionFuture childPromise, ClientConnectionTimingsBuilder timingsBuilder, @Nullable PooledChannel pch) {
            PiggybackedChannelAcquisitionResult result;
            if (pch != null) {
                SessionProtocol actualProtocol = pch.protocol();
                if (actualProtocol.isMultiplex()) {
                    HttpSession session = HttpSession.get(pch.get());
                    result = session.incrementNumUnfinishedResponses() ? PiggybackedChannelAcquisitionResult.SUCCESS : (HttpChannelPool.this.usePendingAcquisition(actualProtocol, key, childPromise, timingsBuilder) ? PiggybackedChannelAcquisitionResult.PIGGYBACKED_AGAIN : PiggybackedChannelAcquisitionResult.NEW_CONNECTION);
                } else {
                    PooledChannel ch = HttpChannelPool.this.acquireNow(actualProtocol, key);
                    if (ch != null) {
                        pch = ch;
                        result = PiggybackedChannelAcquisitionResult.SUCCESS;
                    } else {
                        result = PiggybackedChannelAcquisitionResult.NEW_CONNECTION;
                    }
                }
            } else {
                result = PiggybackedChannelAcquisitionResult.NEW_CONNECTION;
            }
            switch (result) {
                case SUCCESS: {
                    timingsBuilder.pendingAcquisitionEnd();
                    childPromise.complete(pch);
                    break;
                }
                case NEW_CONNECTION: {
                    timingsBuilder.pendingAcquisitionEnd();
                    HttpChannelPool.this.connect(desiredProtocol, key, childPromise, timingsBuilder);
                    break;
                }
            }
        }

        @Override
        public boolean complete(PooledChannel value) {
            assert (value != null);
            if (!super.complete(value)) {
                return false;
            }
            this.handlePendingPiggybacks(value);
            return true;
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            if (!super.completeExceptionally(ex)) {
                return false;
            }
            this.handlePendingPiggybacks(null);
            return true;
        }

        private void handlePendingPiggybacks(@Nullable PooledChannel value) {
            Object pendingPiggybackHandlers = this.pendingPiggybackHandlers;
            if (pendingPiggybackHandlers == null) {
                return;
            }
            this.pendingPiggybackHandlers = null;
            if (!(pendingPiggybackHandlers instanceof List)) {
                Consumer handler = (Consumer)pendingPiggybackHandlers;
                handler.accept(value);
                return;
            }
            List list = (List)pendingPiggybackHandlers;
            for (Consumer handler : list) {
                handler.accept(value);
            }
        }
    }

    static final class Http2PooledChannel
    extends PooledChannel {
        Http2PooledChannel(Channel channel, SessionProtocol protocol) {
            super(channel, protocol);
        }

        @Override
        public void release() {
        }
    }

    final class Http1PooledChannel
    extends PooledChannel {
        private final PoolKey key;

        Http1PooledChannel(Channel channel, SessionProtocol protocol, PoolKey key) {
            super(channel, protocol);
            this.key = key;
        }

        @Override
        public void release() {
            if (!HttpChannelPool.this.eventLoop.inEventLoop()) {
                HttpChannelPool.this.eventLoop.execute(this::doRelease);
            } else {
                this.doRelease();
            }
        }

        private void doRelease() {
            if (HttpChannelPool.isHealthy(this)) {
                HttpChannelPool.this.addToPool(this.protocol(), this.key, this);
            }
        }
    }

    private static enum PiggybackedChannelAcquisitionResult {
        SUCCESS,
        NEW_CONNECTION,
        PIGGYBACKED_AGAIN;

    }
}

