/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientHttp1ObjectEncoder;
import com.linecorp.armeria.client.Http1ResponseDecoder;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.client.HttpSession;
import com.linecorp.armeria.internal.client.UserAgentUtil;
import com.linecorp.armeria.internal.common.Http1KeepAliveHandler;
import io.micrometer.core.instrument.Timer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import java.util.Objects;

final class Http1ClientKeepAliveHandler
extends Http1KeepAliveHandler {
    private static final RequestHeaders HTTP1_PING_REQUEST = RequestHeaders.builder(HttpMethod.OPTIONS, "*").set((CharSequence)HttpHeaderNames.USER_AGENT, UserAgentUtil.USER_AGENT.toString()).build();
    private final HttpSession httpSession;
    private final Http1ResponseDecoder decoder;
    @Nullable
    private ClientHttp1ObjectEncoder encoder;

    Http1ClientKeepAliveHandler(Channel channel, Http1ResponseDecoder decoder, Timer keepAliveTimer, long idleTimeoutMillis, long pingIntervalMillis, long maxConnectionAgeMillis, int maxNumRequestsPerConnection) {
        super(channel, "client", keepAliveTimer, idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis, maxNumRequestsPerConnection);
        this.httpSession = HttpSession.get(Objects.requireNonNull(channel, "channel"));
        this.decoder = Objects.requireNonNull(decoder, "decoder");
    }

    void setEncoder(ClientHttp1ObjectEncoder encoder) {
        this.encoder = Objects.requireNonNull(encoder, "encoder");
    }

    @Override
    protected ChannelFuture writePing(ChannelHandlerContext ctx) {
        int id = this.httpSession.incrementAndGetNumRequestsSent();
        assert (this.encoder != null);
        this.decoder.setPingReqId(id);
        ChannelFuture future = this.encoder.writeHeaders(id, 0, HTTP1_PING_REQUEST, true, ctx.newPromise());
        ctx.flush();
        return future;
    }

    @Override
    protected boolean pingResetsPreviousPing() {
        return false;
    }

    @Override
    protected boolean hasRequestsInProgress(ChannelHandlerContext ctx) {
        return this.httpSession.hasUnfinishedResponses();
    }

    boolean isPing(int id) {
        return this.decoder.isPingReqId(id);
    }
}

