/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import java.util.Objects;
import java.util.function.BiPredicate;

public abstract class AbstractRuleBuilder {
    private final BiPredicate<ClientRequestContext, RequestHeaders> requestHeadersFilter;
    @Nullable
    private BiPredicate<ClientRequestContext, ResponseHeaders> responseHeadersFilter;
    @Nullable
    private BiPredicate<ClientRequestContext, HttpHeaders> responseTrailersFilter;
    @Nullable
    private BiPredicate<ClientRequestContext, Throwable> exceptionFilter;
    @Nullable
    private BiPredicate<ClientRequestContext, HttpHeaders> grpcTrailersFilter;

    protected AbstractRuleBuilder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        this.requestHeadersFilter = requestHeadersFilter;
    }

    public AbstractRuleBuilder onResponseHeaders(BiPredicate<? super ClientRequestContext, ? super ResponseHeaders> responseHeadersFilter) {
        this.responseHeadersFilter = AbstractRuleBuilder.combinePredicates(this.responseHeadersFilter, responseHeadersFilter, "responseHeadersFilter");
        return this;
    }

    public AbstractRuleBuilder onResponseTrailers(BiPredicate<? super ClientRequestContext, ? super HttpHeaders> responseTrailersFilter) {
        this.responseTrailersFilter = AbstractRuleBuilder.combinePredicates(this.responseTrailersFilter, responseTrailersFilter, "responseTrailersFilter");
        return this;
    }

    public AbstractRuleBuilder onGrpcTrailers(BiPredicate<? super ClientRequestContext, ? super HttpHeaders> grpcTrailersFilter) {
        this.grpcTrailersFilter = AbstractRuleBuilder.combinePredicates(this.grpcTrailersFilter, grpcTrailersFilter, "grpcTrailersFilter");
        return this;
    }

    public AbstractRuleBuilder onStatusClass(HttpStatusClass ... statusClasses) {
        return this.onStatusClass(ImmutableSet.copyOf(Objects.requireNonNull(statusClasses, "statusClasses")));
    }

    public AbstractRuleBuilder onStatusClass(Iterable<HttpStatusClass> statusClasses) {
        Objects.requireNonNull(statusClasses, "statusClasses");
        Preconditions.checkArgument(!Iterables.isEmpty(statusClasses), "statusClasses can't be empty.");
        ImmutableSet<HttpStatusClass> statusClasses0 = Sets.immutableEnumSet(statusClasses);
        this.onResponseHeaders((ctx, headers) -> statusClasses0.contains((Object)headers.status().codeClass()));
        return this;
    }

    public AbstractRuleBuilder onServerErrorStatus() {
        return this.onStatusClass(HttpStatusClass.SERVER_ERROR);
    }

    public AbstractRuleBuilder onStatus(HttpStatus ... statuses) {
        return this.onStatus(ImmutableSet.copyOf(Objects.requireNonNull(statuses, "statuses")));
    }

    public AbstractRuleBuilder onStatus(Iterable<HttpStatus> statuses) {
        Objects.requireNonNull(statuses, "statuses");
        Preconditions.checkArgument(!Iterables.isEmpty(statuses), "statuses can't be empty.");
        ImmutableSet<HttpStatus> statuses0 = ImmutableSet.copyOf(statuses);
        this.onResponseHeaders((ctx, headers) -> statuses0.contains(headers.status()));
        return this;
    }

    public AbstractRuleBuilder onStatus(BiPredicate<? super ClientRequestContext, ? super HttpStatus> statusFilter) {
        Objects.requireNonNull(statusFilter, "statusFilter");
        this.onResponseHeaders((ctx, headers) -> statusFilter.test((ClientRequestContext)ctx, headers.status()));
        return this;
    }

    public AbstractRuleBuilder onException(Class<? extends Throwable> exception) {
        Objects.requireNonNull(exception, "exception");
        return this.onException((? super ClientRequestContext unused, ? super Throwable ex) -> exception.isInstance(ex));
    }

    public AbstractRuleBuilder onException(BiPredicate<? super ClientRequestContext, ? super Throwable> exceptionFilter) {
        this.exceptionFilter = AbstractRuleBuilder.combinePredicates(this.exceptionFilter, exceptionFilter, "exceptionFilter");
        return this;
    }

    public AbstractRuleBuilder onException() {
        return this.onException((? super ClientRequestContext unused1, ? super Throwable unused2) -> true);
    }

    private static <T> BiPredicate<ClientRequestContext, T> combinePredicates(@Nullable BiPredicate<ClientRequestContext, T> firstPredicate, BiPredicate<? super ClientRequestContext, ? super T> secondPredicate, String paramName) {
        Objects.requireNonNull(secondPredicate, paramName);
        if (firstPredicate != null) {
            return firstPredicate.or(secondPredicate);
        }
        BiPredicate<? super ClientRequestContext, ? super T> cast = secondPredicate;
        return cast;
    }

    public AbstractRuleBuilder onUnprocessed() {
        return this.onException(UnprocessedRequestException.class);
    }

    protected final BiPredicate<ClientRequestContext, RequestHeaders> requestHeadersFilter() {
        return this.requestHeadersFilter;
    }

    @Nullable
    protected final BiPredicate<ClientRequestContext, ResponseHeaders> responseHeadersFilter() {
        return this.responseHeadersFilter;
    }

    @Nullable
    protected final BiPredicate<ClientRequestContext, HttpHeaders> responseTrailersFilter() {
        return this.responseTrailersFilter;
    }

    @Nullable
    protected final BiPredicate<ClientRequestContext, Throwable> exceptionFilter() {
        return this.exceptionFilter;
    }

    @Nullable
    protected final BiPredicate<ClientRequestContext, HttpHeaders> grpcTrailersFilter() {
        return this.grpcTrailersFilter;
    }

    protected final boolean requiresResponseTrailers() {
        return this.responseTrailersFilter != null || this.grpcTrailersFilter != null;
    }
}

