/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.kubernetes;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.ClusterModuleKubernetesConfig;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.EventType;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.NamespacedPodListInformer;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.UidEnvSupplier;
import org.apache.skywalking.oap.server.core.cluster.ClusterCoordinator;
import org.apache.skywalking.oap.server.core.cluster.ClusterHealthStatus;
import org.apache.skywalking.oap.server.core.cluster.OAPNodeChecker;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceQueryException;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCoordinator
extends ClusterCoordinator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubernetesCoordinator.class);
    private final ModuleDefineHolder manager;
    private final String uid;
    private volatile int port = -1;
    private HealthCheckMetrics healthChecker;
    private ClusterModuleKubernetesConfig config;
    private final Map<String, RemoteInstance> remoteInstanceMap;
    private volatile List<String> latestInstances;

    public KubernetesCoordinator(ModuleDefineHolder manager, ClusterModuleKubernetesConfig config) {
        this.uid = new UidEnvSupplier(config.getUidEnvName()).get();
        this.manager = manager;
        this.config = config;
        this.remoteInstanceMap = new ConcurrentHashMap<String, RemoteInstance>(20);
        this.latestInstances = new ArrayList<String>(20);
    }

    public List<RemoteInstance> queryRemoteNodes() {
        try {
            List pods = NamespacedPodListInformer.INFORMER.listPods().orElseGet(this::selfPod);
            if (log.isDebugEnabled()) {
                List uidList = pods.stream().map(item -> item.getMetadata().getUid()).collect(Collectors.toList());
                log.debug("[kubernetes cluster pods uid list]:{}", uidList);
            }
            if (this.port == -1) {
                this.port = ((ConfigService)this.manager.find("core").provider().getService(ConfigService.class)).getGRPCPort();
            }
            List<RemoteInstance> remoteInstances = pods.stream().filter(pod -> StringUtil.isNotBlank((String)pod.getStatus().getPodIP())).map(pod -> new RemoteInstance(new Address(pod.getStatus().getPodIP(), this.port, pod.getMetadata().getUid().equals(this.uid)))).collect(Collectors.toList());
            this.healthChecker.health();
            this.latestInstances = remoteInstances.stream().map(it -> it.getAddress().toString()).collect(Collectors.toList());
            if (log.isDebugEnabled()) {
                remoteInstances.forEach(instance -> log.debug("kubernetes cluster instance: {}", instance));
            }
            return remoteInstances;
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new ServiceQueryException(e.getMessage());
        }
    }

    public void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        try {
            this.port = remoteInstance.getAddress().getPort();
            this.healthChecker.health();
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new ServiceRegisterException(e.getMessage());
        }
    }

    private void initHealthChecker() {
        if (this.healthChecker == null) {
            MetricsCreator metricCreator = (MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class);
            this.healthChecker = metricCreator.createHealthCheckerGauge("cluster_k8s", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        }
    }

    private List<Pod> selfPod() {
        Pod v1Pod = new Pod();
        v1Pod.setMetadata(new ObjectMeta());
        v1Pod.setStatus(new PodStatus());
        v1Pod.getMetadata().setUid(this.uid);
        v1Pod.getStatus().setPodIP("127.0.0.1");
        return Collections.singletonList(v1Pod);
    }

    public void start() {
        this.initHealthChecker();
        NamespacedPodListInformer.INFORMER.init(this.config, new K8sResourceEventHandler());
    }

    private void updateRemoteInstances(Pod pod, EventType event) {
        try {
            this.initHealthChecker();
            if (StringUtil.isNotBlank((String)pod.getStatus().getPodIP())) {
                if (this.port == -1) {
                    this.port = ((ConfigService)this.manager.find("core").provider().getService(ConfigService.class)).getGRPCPort();
                }
                RemoteInstance remoteInstance = new RemoteInstance(new Address(pod.getStatus().getPodIP(), this.port, pod.getMetadata().getUid().equals(this.uid)));
                switch (event) {
                    case ADDED: 
                    case MODIFIED: {
                        if (!"Running".equalsIgnoreCase(pod.getStatus().getPhase())) break;
                        this.remoteInstanceMap.put(remoteInstance.getAddress().toString(), remoteInstance);
                        break;
                    }
                    case DELETED: {
                        this.remoteInstanceMap.remove(remoteInstance.getAddress().toString());
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.updateRemoteInstances();
            }
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            log.error("Failed to notify RemoteInstances update.", e);
        }
    }

    private void updateRemoteInstances() {
        ArrayList<String> updatedInstances = new ArrayList<String>(this.remoteInstanceMap.keySet());
        if (this.latestInstances.size() != updatedInstances.size() || !this.latestInstances.containsAll(updatedInstances)) {
            ArrayList<RemoteInstance> remoteInstances = new ArrayList<RemoteInstance>(this.remoteInstanceMap.values());
            this.latestInstances = updatedInstances;
            this.checkHealth(remoteInstances);
            this.notifyWatchers(remoteInstances);
        }
    }

    private void checkHealth(List<RemoteInstance> remoteInstances) {
        ClusterHealthStatus healthStatus = OAPNodeChecker.isHealth(remoteInstances);
        if (healthStatus.isHealth()) {
            this.healthChecker.health();
        } else {
            this.healthChecker.unHealth(healthStatus.getReason());
        }
    }

    class K8sResourceEventHandler
    implements ResourceEventHandler<Pod> {
        K8sResourceEventHandler() {
        }

        public void onAdd(Pod obj) {
            KubernetesCoordinator.this.updateRemoteInstances(obj, EventType.ADDED);
        }

        public void onUpdate(Pod oldObj, Pod newObj) {
            KubernetesCoordinator.this.updateRemoteInstances(newObj, EventType.MODIFIED);
        }

        public void onDelete(Pod obj, boolean deletedFinalStateUnknown) {
            KubernetesCoordinator.this.updateRemoteInstances(obj, EventType.DELETED);
        }
    }
}

