/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.browser.provider;

import com.linecorp.armeria.common.HttpMethod;
import io.grpc.BindableService;
import java.util.Collections;
import org.apache.skywalking.oap.server.core.oal.rt.OALDefine;
import org.apache.skywalking.oap.server.core.oal.rt.OALEngineLoaderService;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.core.server.HTTPHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.receiver.browser.module.BrowserModule;
import org.apache.skywalking.oap.server.receiver.browser.provider.BrowserOALDefine;
import org.apache.skywalking.oap.server.receiver.browser.provider.BrowserServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.browser.provider.handler.grpc.BrowserPerfServiceHandler;
import org.apache.skywalking.oap.server.receiver.browser.provider.handler.grpc.BrowserPerfServiceHandlerCompat;
import org.apache.skywalking.oap.server.receiver.browser.provider.handler.rest.BrowserPerfServiceHTTPHandler;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.ErrorLogParserListenerManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.listener.ErrorLogRecordListener;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.listener.MultiScopesErrorLogAnalysisListener;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.PerfDataParserListenerManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener.MultiScopesPerfDataAnalysisListener;

public class BrowserModuleProvider
extends ModuleProvider {
    private BrowserServiceModuleConfig moduleConfig;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return BrowserModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<BrowserServiceModuleConfig>(){

            public Class type() {
                return BrowserServiceModuleConfig.class;
            }

            public void onInitialized(BrowserServiceModuleConfig initialized) {
                BrowserModuleProvider.this.moduleConfig = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        ((OALEngineLoaderService)this.getManager().find("core").provider().getService(OALEngineLoaderService.class)).load((OALDefine)BrowserOALDefine.INSTANCE);
        GRPCHandlerRegister grpcHandlerRegister = (GRPCHandlerRegister)this.getManager().find("receiver-sharing-server").provider().getService(GRPCHandlerRegister.class);
        BrowserPerfServiceHandler browserPerfServiceHandler = new BrowserPerfServiceHandler(this.getManager(), this.moduleConfig, this.perfDataListenerManager(), this.errorLogListenerManager());
        grpcHandlerRegister.addHandler((BindableService)browserPerfServiceHandler);
        grpcHandlerRegister.addHandler((BindableService)new BrowserPerfServiceHandlerCompat(browserPerfServiceHandler));
        HTTPHandlerRegister httpHandlerRegister = (HTTPHandlerRegister)this.getManager().find("receiver-sharing-server").provider().getService(HTTPHandlerRegister.class);
        ErrorLogParserListenerManager errorLogParserListenerManager = this.errorLogListenerManager();
        httpHandlerRegister.addHandler((Object)new BrowserPerfServiceHTTPHandler(this.getManager(), this.moduleConfig, errorLogParserListenerManager, this.perfDataListenerManager()), Collections.singletonList(HttpMethod.POST));
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"telemetry", "core", "receiver-sharing-server", "configuration"};
    }

    private PerfDataParserListenerManager perfDataListenerManager() {
        PerfDataParserListenerManager listenerManager = new PerfDataParserListenerManager();
        listenerManager.add(new MultiScopesPerfDataAnalysisListener.Factory(this.getManager(), this.moduleConfig));
        return listenerManager;
    }

    private ErrorLogParserListenerManager errorLogListenerManager() {
        ErrorLogParserListenerManager listenerManager = new ErrorLogParserListenerManager();
        listenerManager.add(new MultiScopesErrorLogAnalysisListener.Factory(this.getManager(), this.moduleConfig));
        listenerManager.add(new ErrorLogRecordListener.Factory(this.getManager(), this.moduleConfig));
        return listenerManager;
    }
}

