/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;

public class StringFormatGroup {
    private final List<PatternRule> rules;

    public StringFormatGroup() {
        this.rules = new ArrayList<PatternRule>();
    }

    public StringFormatGroup(int size) {
        this.rules = new ArrayList<PatternRule>(size);
    }

    public void addRule(String name, String ruleRegex) {
        for (PatternRule rule : this.rules) {
            if (!rule.name.equals(name)) continue;
            return;
        }
        PatternRule rule = new PatternRule(name, ruleRegex);
        this.rules.add(rule);
    }

    public FormatResult format(String string) {
        for (PatternRule rule : this.rules) {
            if (!rule.getPattern().matcher(string).matches()) continue;
            return new FormatResult(true, rule.getName(), string);
        }
        return new FormatResult(false, string, string);
    }

    public void sortRules(Comparator<? super PatternRule> comparator) {
        this.rules.sort(comparator);
    }

    @Generated
    public String toString() {
        return "StringFormatGroup(rules=" + this.rules + ")";
    }

    public static class PatternRule {
        private final String name;
        private final Pattern pattern;

        private PatternRule(String name, String ruleRegex) {
            this.name = name;
            this.pattern = Pattern.compile(ruleRegex);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Pattern getPattern() {
            return this.pattern;
        }

        @Generated
        public String toString() {
            return "StringFormatGroup.PatternRule(name=" + this.getName() + ", pattern=" + this.getPattern() + ")";
        }
    }

    public static class FormatResult {
        private final boolean match;
        private final String name;
        private final String replacedName;

        @Generated
        public boolean isMatch() {
            return this.match;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getReplacedName() {
            return this.replacedName;
        }

        @Generated
        public FormatResult(boolean match, String name, String replacedName) {
            this.match = match;
            this.name = name;
            this.replacedName = replacedName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FormatResult)) {
                return false;
            }
            FormatResult other = (FormatResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isMatch() != other.isMatch()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$replacedName = this.getReplacedName();
            String other$replacedName = other.getReplacedName();
            return !(this$replacedName == null ? other$replacedName != null : !this$replacedName.equals(other$replacedName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FormatResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMatch() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $replacedName = this.getReplacedName();
            result = result * 59 + ($replacedName == null ? 43 : $replacedName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StringFormatGroup.FormatResult(match=" + this.isMatch() + ", name=" + this.getName() + ", replacedName=" + this.getReplacedName() + ")";
        }
    }
}

