/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.otel;

import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.receiver.otel.Handler;
import org.apache.skywalking.oap.server.receiver.otel.OtelMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.otel.OtelMetricReceiverModule;
import org.apache.skywalking.oap.server.receiver.otel.otlp.OpenTelemetryLogHandler;
import org.apache.skywalking.oap.server.receiver.otel.otlp.OpenTelemetryMetricHandler;
import org.apache.skywalking.oap.server.receiver.otel.otlp.OpenTelemetryMetricRequestProcessor;

public class OtelMetricReceiverProvider
extends ModuleProvider {
    public static final String NAME = "default";
    private List<Handler> handlers;
    private OtelMetricReceiverConfig config;
    private OpenTelemetryMetricRequestProcessor metricRequestProcessor;

    public String name() {
        return NAME;
    }

    public Class<? extends ModuleDefine> module() {
        return OtelMetricReceiverModule.class;
    }

    public ModuleProvider.ConfigCreator<OtelMetricReceiverConfig> newConfigCreator() {
        return new ModuleProvider.ConfigCreator<OtelMetricReceiverConfig>(){

            public Class<OtelMetricReceiverConfig> type() {
                return OtelMetricReceiverConfig.class;
            }

            public void onInitialized(OtelMetricReceiverConfig initialized) {
                OtelMetricReceiverProvider.this.config = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        OpenTelemetryLogHandler openTelemetryLogHandler;
        this.metricRequestProcessor = new OpenTelemetryMetricRequestProcessor(this.getManager(), this.config);
        this.registerServiceImplementation(OpenTelemetryMetricRequestProcessor.class, this.metricRequestProcessor);
        List<String> enabledHandlers = this.config.getEnabledHandlers();
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        OpenTelemetryMetricHandler openTelemetryMetricHandler = new OpenTelemetryMetricHandler(this.getManager(), this.metricRequestProcessor);
        if (enabledHandlers.contains(openTelemetryMetricHandler.type())) {
            handlers.add(openTelemetryMetricHandler);
        }
        if (enabledHandlers.contains((openTelemetryLogHandler = new OpenTelemetryLogHandler(this.getManager())).type())) {
            handlers.add(openTelemetryLogHandler);
        }
        this.handlers = handlers;
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        this.metricRequestProcessor.start();
        for (Handler h : this.handlers) {
            h.active();
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"receiver-sharing-server"};
    }
}

