/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.server.http;

import com.google.common.collect.Sets;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.encoding.DecodingService;
import com.linecorp.armeria.server.healthcheck.HealthCheckService;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.server.logging.LoggingService;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.library.server.Server;
import org.apache.skywalking.oap.server.library.server.http.HTTPServerConfig;
import org.apache.skywalking.oap.server.library.server.ssl.PrivateKeyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPServer
implements Server {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HTTPServer.class);
    private final HTTPServerConfig config;
    private ServerBuilder sb;
    private final Set<HttpMethod> allowedMethods = Sets.newHashSet((Object[])new HttpMethod[]{HttpMethod.HEAD});

    public HTTPServer(HTTPServerConfig config) {
        this.config = config;
    }

    @Override
    public void initialize() {
        String contextPath;
        block16: {
            contextPath = StringUtils.stripEnd((String)this.config.getContextPath(), (String)"/");
            this.sb = com.linecorp.armeria.server.Server.builder().serviceUnder(contextPath + "/docs", (HttpService)DocService.builder().build()).service("/internal/l7check", (HttpService)HealthCheckService.of((HealthChecker[])new HealthChecker[0])).workerGroup(this.config.getMaxThreads()).http1MaxHeaderSize(this.config.getMaxRequestHeaderSize()).idleTimeout(Duration.ofMillis(this.config.getIdleTimeOut())).decorator(Route.ofCatchAll(), (delegate, ctx, req) -> {
                if (!this.allowedMethods.contains(ctx.method())) {
                    return HttpResponse.of((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED);
                }
                return delegate.serve(ctx, req);
            }).decorator(DecodingService.newDecorator()).decorator(LoggingService.newDecorator());
            if (this.config.isEnableTLS()) {
                this.sb.https(new InetSocketAddress(this.config.getHost(), this.config.getPort()));
                try (FileInputStream cert = new FileInputStream(this.config.getTlsCertChainPath());
                     InputStream key = PrivateKeyUtil.loadDecryptionKey(this.config.getTlsKeyPath());){
                    this.sb.tls((InputStream)cert, key);
                    break block16;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            this.sb.http(new InetSocketAddress(this.config.getHost(), this.config.getPort()));
        }
        if (this.config.getAcceptQueueSize() > 0) {
            this.sb.maxNumConnections(this.config.getAcceptQueueSize());
        }
        if (this.config.isAcceptProxyRequest()) {
            this.sb.absoluteUriTransformer(this::transformAbsoluteURI);
        }
        log.info("Server root context path: {}", (Object)contextPath);
    }

    public void addHandler(Object handler, List<HttpMethod> httpMethods) {
        Objects.requireNonNull(this.allowedMethods, "allowedMethods");
        log.info("Bind handler {} into http server {}:{}", new Object[]{handler.getClass().getSimpleName(), this.config.getHost(), this.config.getPort()});
        this.sb.annotatedService().pathPrefix(this.config.getContextPath()).build(handler);
        this.allowedMethods.addAll(httpMethods);
    }

    @Override
    public void start() {
        this.sb.build().start().join();
    }

    private String transformAbsoluteURI(String uri) {
        if (uri.startsWith("https://")) {
            return uri.substring(uri.indexOf("/", 8));
        }
        if (uri.startsWith("http://")) {
            return uri.substring(uri.indexOf("/", 7));
        }
        return uri;
    }
}

