/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileThreadSnapshotRecord;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBProfileThreadSnapshotQueryDAO
extends AbstractBanyanDBDAO
implements IProfileThreadSnapshotQueryDAO {
    private static final Set<String> TAGS_BASIC = ImmutableSet.of((Object)"task_id", (Object)"segment_id", (Object)"dump_time", (Object)"sequence");
    private static final Set<String> TAGS_ALL = ImmutableSet.of((Object)"task_id", (Object)"segment_id", (Object)"dump_time", (Object)"sequence", (Object)"stack_binary");
    private static final Set<String> TAGS_TRACE = ImmutableSet.of((Object)"trace_id", (Object)"is_error", (Object)"service_id", (Object)"service_instance_id", (Object)"endpoint_id", (Object)"latency", (Object[])new String[]{"start_time"});
    private static final Set<String> TAGS_TRACE_ALL = ImmutableSet.of((Object)"trace_id", (Object)"is_error", (Object)"service_id", (Object)"service_instance_id", (Object)"endpoint_id", (Object)"latency", (Object[])new String[]{"start_time", "data_binary"});
    private final int querySegmentMaxSize;
    protected final ProfileThreadSnapshotRecord.Builder builder = new ProfileThreadSnapshotRecord.Builder();

    public BanyanDBProfileThreadSnapshotQueryDAO(BanyanDBStorageClient client, int profileTaskQueryMaxSize) {
        super(client);
        this.querySegmentMaxSize = profileTaskQueryMaxSize;
    }

    public List<String> queryProfiledSegmentIdList(final String taskId) throws IOException {
        StreamQueryResponse resp = this.query("profile_task_segment_snapshot", TAGS_BASIC, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            public void apply(StreamQuery query) {
                query.and(this.eq("task_id", taskId)).and(this.eq("sequence", 0L));
                query.setOrderBy(this.desc("dump_time"));
                query.setLimit(BanyanDBProfileThreadSnapshotQueryDAO.this.querySegmentMaxSize);
            }
        });
        if (resp.getElements().isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<String> segmentIds = new LinkedList<String>();
        for (RowEntity rowEntity : resp.getElements()) {
            segmentIds.add((String)rowEntity.getTagValue("segment_id"));
        }
        return segmentIds;
    }

    public int queryMinSequence(String segmentId, long start, long end) throws IOException {
        return this.querySequenceWithAgg(AggType.MIN, segmentId, start, end);
    }

    public int queryMaxSequence(String segmentId, long start, long end) throws IOException {
        return this.querySequenceWithAgg(AggType.MAX, segmentId, start, end);
    }

    public List<ProfileThreadSnapshotRecord> queryRecords(final String segmentId, final int minSequence, final int maxSequence) throws IOException {
        StreamQueryResponse resp = this.query("profile_task_segment_snapshot", TAGS_ALL, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            public void apply(StreamQuery query) {
                query.and(this.eq("segment_id", segmentId)).and(this.lte("sequence", maxSequence)).and(this.gte("sequence", minSequence));
            }
        });
        ArrayList<ProfileThreadSnapshotRecord> result = new ArrayList<ProfileThreadSnapshotRecord>(maxSequence - minSequence);
        for (RowEntity rowEntity : resp.getElements()) {
            ProfileThreadSnapshotRecord record = this.builder.storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToStream("profile_task_segment_snapshot", rowEntity));
            result.add(record);
        }
        return result;
    }

    private int querySequenceWithAgg(AggType aggType, final String segmentId, final long start, final long end) throws IOException {
        StreamQueryResponse resp = this.query("profile_task_segment_snapshot", TAGS_ALL, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            public void apply(StreamQuery query) {
                query.and(this.eq("segment_id", segmentId)).and(this.lte("dump_time", end)).and(this.gte("dump_time", start));
            }
        });
        ArrayList<ProfileThreadSnapshotRecord> records = new ArrayList<ProfileThreadSnapshotRecord>();
        for (Object rowEntity : resp.getElements()) {
            ProfileThreadSnapshotRecord record = this.builder.storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToStream("profile_task_segment_snapshot", (RowEntity)rowEntity));
            records.add(record);
        }
        switch (aggType) {
            case MIN: {
                int minValue = Integer.MAX_VALUE;
                for (ProfileThreadSnapshotRecord record : records) {
                    int sequence = record.getSequence();
                    minValue = Math.min(minValue, sequence);
                }
                return minValue;
            }
            case MAX: {
                int maxValue = Integer.MIN_VALUE;
                for (ProfileThreadSnapshotRecord record : records) {
                    int sequence = record.getSequence();
                    maxValue = Math.max(maxValue, sequence);
                }
                return maxValue;
            }
        }
        throw new IllegalArgumentException("should not reach this line");
    }

    static enum AggType {
        MIN,
        MAX;

    }
}

