/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TraceScopeCondition;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBLogQueryDAO
extends AbstractBanyanDBDAO
implements ILogQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"service_id", (Object)"service_instance_id", (Object)"endpoint_id", (Object)"trace_id", (Object)"trace_segment_id", (Object)"span_id", (Object[])new String[]{"timestamp", "content_type", "content", "tags", "tags_raw_data"});

    public BanyanDBLogQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public Logs queryLogs(final String serviceId, final String serviceInstanceId, final String endpointId, final TraceScopeCondition relatedTrace, Order queryOrder, int from, int limit, Duration duration, final List<Tag> tags, List<String> keywordsOfContent, List<String> excludingKeywordsOfContent) throws IOException {
        long startTB = 0L;
        long endTB = 0L;
        if (Objects.nonNull(duration)) {
            startTB = duration.getStartTimeBucketInSec();
            endTB = duration.getEndTimeBucketInSec();
        }
        AbstractBanyanDBDAO.QueryBuilder<StreamQuery> query = new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            public void apply(StreamQuery query) {
                if (StringUtil.isNotEmpty((String)serviceId)) {
                    query.and(this.eq("service_id", serviceId));
                }
                if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
                    query.and(this.eq("service_instance_id", serviceInstanceId));
                }
                if (StringUtil.isNotEmpty((String)endpointId)) {
                    query.and(this.eq("endpoint_id", endpointId));
                }
                if (Objects.nonNull(relatedTrace)) {
                    if (StringUtil.isNotEmpty((String)relatedTrace.getTraceId())) {
                        query.and(this.eq("trace_id", relatedTrace.getTraceId()));
                    }
                    if (StringUtil.isNotEmpty((String)relatedTrace.getSegmentId())) {
                        query.and(this.eq("trace_segment_id", relatedTrace.getSegmentId()));
                    }
                    if (Objects.nonNull(relatedTrace.getSpanId())) {
                        query.and(this.eq("span_id", relatedTrace.getSpanId().intValue()));
                    }
                }
                if (CollectionUtils.isNotEmpty((List)tags)) {
                    ArrayList<String> tagsConditions = new ArrayList<String>(tags.size());
                    for (Tag tag : tags) {
                        tagsConditions.add(tag.toString());
                    }
                    query.and(this.having("tags", tagsConditions));
                }
            }
        };
        TimestampRange tsRange = null;
        if (startTB > 0L && endTB > 0L) {
            tsRange = new TimestampRange(TimeBucket.getTimestamp((long)startTB), TimeBucket.getTimestamp((long)endTB));
        }
        StreamQueryResponse resp = this.query("log", TAGS, tsRange, query);
        Logs logs = new Logs();
        for (RowEntity rowEntity : resp.getElements()) {
            Log log = new Log();
            log.setServiceId((String)rowEntity.getTagValue("service_id"));
            log.setServiceInstanceId((String)rowEntity.getTagValue("service_instance_id"));
            log.setEndpointId((String)rowEntity.getTagValue("endpoint_id"));
            if (log.getEndpointId() != null) {
                log.setEndpointName(IDManager.EndpointID.analysisId((String)log.getEndpointId()).getEndpointName());
            }
            log.setTraceId((String)rowEntity.getTagValue("trace_id"));
            log.setTimestamp(Long.valueOf(((Number)rowEntity.getTagValue("timestamp")).longValue()));
            log.setContentType(ContentType.instanceOf((int)((Number)rowEntity.getTagValue("content_type")).intValue()));
            log.setContent((String)rowEntity.getTagValue("content"));
            byte[] dataBinary = (byte[])rowEntity.getTagValue("tags_raw_data");
            if (dataBinary != null && dataBinary.length > 0) {
                this.parserDataBinary(dataBinary, log.getTags());
            }
            logs.getLogs().add(log);
        }
        return logs;
    }
}

