/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;
import org.apache.skywalking.banyandb.v1.client.metadata.Property;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingPolicy;
import org.apache.skywalking.oap.server.core.storage.profiling.continuous.IContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBContinuousProfilingPolicyDAO
extends AbstractBanyanDBDAO
implements IContinuousProfilingPolicyDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBContinuousProfilingPolicyDAO.class);
    private static final String GROUP = "sw";

    public BanyanDBContinuousProfilingPolicyDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public void savePolicy(ContinuousProfilingPolicy policy) throws IOException {
        try {
            ((BanyanDBStorageClient)this.getClient()).define(this.applyAll(policy));
        }
        catch (IOException e) {
            log.error("fail to save policy", (Throwable)e);
        }
    }

    public Property applyAll(ContinuousProfilingPolicy policy) {
        return Property.create((String)GROUP, (String)"continuous_profiling_policy", (String)policy.id().build()).addTag(TagAndValue.newStringTag((String)"uuid", (String)policy.getUuid())).addTag(TagAndValue.newStringTag((String)"configuration_json", (String)policy.getConfigurationJson())).build();
    }

    public List<ContinuousProfilingPolicy> queryPolicies(List<String> serviceIdList) throws IOException {
        return serviceIdList.stream().map(s -> {
            try {
                return ((BanyanDBStorageClient)this.getClient()).queryProperty(GROUP, "continuous_profiling_policy", (String)s);
            }
            catch (IOException e) {
                log.warn("query policy error", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).map(properties -> {
            ContinuousProfilingPolicy policy = new ContinuousProfilingPolicy();
            policy.setServiceId(properties.id());
            for (TagAndValue tag : properties.tags()) {
                if (tag.getTagName().equals("configuration_json")) {
                    policy.setConfigurationJson((String)tag.getValue());
                    continue;
                }
                if (!tag.getTagName().equals("uuid")) continue;
                policy.setUuid((String)tag.getValue());
            }
            return policy;
        }).collect(Collectors.toList());
    }
}

